/*
 * install.h
 * 
 * include file for install.c
 *
 * Copyright (c) Tuomo Valkonen 1996-1997.
 */
#ifndef INSTALL_H
#define INSTALL_H

typedef struct geom{
	unsigned char	heads;
	unsigned char	sectors;
	unsigned short 	cylinders;
	unsigned long  	start;
	unsigned short	device;
	unsigned int	spb;
}GEOMETRY;
 
int get_device(int fdp,GEOMETRY *geo);
int open_dev(dev_t device );
int verify_bios_read(GEOMETRY *geo,ulong addr);
int install_it(void);
int get_addr(int fd, int sect, GEOMETRY *geo);
char*dev_name(dev_t dev);

#define MAPFILE		map_file
#define STAGE2IMG	loader_file
#define BSECTIMG	bsect_file

extern char* map_file;
extern char* bsect_file;
extern char* loader_file;
extern char* background_file;

extern long	emerg_sect;
extern char	emerg_dev;
extern char	tmpstr[512];
extern char	tmpstr2[512];

#define VER_BIOS(_geo,_addr,_name)				\
	if( !verify_bios_read(_geo,_addr) ){			\
		fprintf(stderr, "Sector %d of %s may be outta"	\
		"BIOS-accessible range.",_addr,_name);		\
		continue_yn();					\
	}

#endif