/* --------------------------------------------------------------------*/
/*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
/*                                                                     */
/*                                     ,--^,                           */
/*                               _ ___/ /|/                            */
/*                           ,;'( )__, ) '                             */
/*                          ;;  //   L__.                              */
/*                          '   \   /  '                               */
/*                               ^   ^                                 */
/*                                                                     */
/*                                                                     */
/*    This program is distributed in the hope that it will be useful.  */
/*    Use and copying of this software and preparation of derivative   */
/*    works based upon this software are permitted, so long as the     */
/*    following conditions are met:                                    */
/*           o credit to the authors is acknowledged following         */
/*             current academic behaviour                              */
/*           o no fees or compensation are charged for use, copies,    */
/*             or access to this software                              */
/*           o this copyright notice is included intact.               */
/*      This software is made available AS IS, and no warranty is made */
/*      about the software or its performance.                         */
/*                                                                     */
/*      Bug descriptions, use reports, comments or suggestions are     */
/*      welcome. Send them to                                          */
/*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
/*-------------------------------------------------------------------- */
/*---------------------------------------------------------------------*/
/*    serrano/prgm/project/bigloo/runtime1.8/Clib/system.c             */
/*                                                                     */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Wed Jan 20 08:45:23 1993                          */
/*    Last change :  Wed May 24 13:20:14 1995 (serrano)                */
/*                                                                     */
/*    Le fichier ou on s'occupe de faire les choses `system'           */
/*---------------------------------------------------------------------*/
#include <bigloo1.9c.h>
#include <time.h>
#include <signal.h>

/*---------------------------------------------------------------------*/
/*    La table des handlers de signaux                                 */
/*---------------------------------------------------------------------*/
static obj_t handler[ 32 ];

/*---------------------------------------------------------------------*/
/*    get_handler ...                                                  */
/*---------------------------------------------------------------------*/
static obj_t
get_handler( num )
int num;
{
   return ((obj_t (*)())PROCEDURE_ENTRY(handler[ num ]))( handler[ num ],
                                                          BINT( num ),
                                                          BEOA );
}
    
/*---------------------------------------------------------------------*/
/*    obj_t ...                                                        */
/*---------------------------------------------------------------------*/
obj_t
c_signal( sig, thunk )
int   sig;
obj_t thunk;
{
   /* on met le thunk dans la table des handlers */
   handler[ sig ] = thunk;

   /* on le signal ... */
   signal( (int)sig, (void (*)())get_handler );

   return BUNSPEC;
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    get_signal_handler ...                                           */
/*---------------------------------------------------------------------*/
obj_t
get_signal_handler( sig )
int sig;
{
   return PROCEDUREP( handler[ sig ] ) ? handler[ sig ] : BFALSE;
}

/*---------------------------------------------------------------------*/
/*    c_date ...                                                       */
/*---------------------------------------------------------------------*/
char *
c_date()
{
#if( defined( sony_news ) )
   long now;
#else      
   time_t now;
#endif

   now = time( 0L );
   return ctime( &now );
}
      
