;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime1.9c/Eval/expd-struct.scm     */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jul 30 11:48:02 1992                          */
;*    Last change :  Tue Aug  5 11:13:48 1997 (serrano)                */
;*                                                                     */
;*    L'expansion des des define-struct                                */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __expander_struct
   
   (import  (__error                   "Llib/error.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__structure               "Llib/struct.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__bexit                   "Llib/bexit.scm")
	    
	    (__reader                  "Read/reader.scm")
	    
	    (__rgc                     "Rgc/runtime.scm")
	    
	    (__match_normalize         "Match/normalize.scm")
	     
	    (__r4_numbers_6_5          "Ieee/number.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_numbers_6_5_flonum   "Ieee/flonum.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_input_6_10_2         "Ieee/input.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_ports_6_10_1         "Ieee/port.scm")
	    (__r4_output_6_10_3        "Ieee/output.scm")
	    
	    (__progn                   "Eval/progn.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__evenv                   "Eval/evenv.scm"))
   
   (export  (expand-eval-define-struct x e)))

;*---------------------------------------------------------------------*/
;*    expand-eval-define-struct ...                                    */
;*---------------------------------------------------------------------*/
(define (expand-eval-define-struct x e)
   (match-case x
      ((?- ?name . ?slots)
       (match-define-structure! x)
       (let* ((len        (length slots))
	      (slots-name (map (lambda (s)
				  (match-case s
				     ((?name ?dv)
				      name)
				     ((? symbol?)
				      s)
				     (else
				      (error "define-struct"
					     "Illegal `define-struct' form"
					     x))))
			       slots))
	      (slots-val?  #f)
	      (slots-val   (map (lambda (s)
				   (match-case s
				      ((?- ?dv)
				       (set! slots-val? #t)
				       dv)
				      ((? symbol?)
				       ''())
				      (else
				       (error "define-struct"
					      "Illegal `define-struct' form"
					      x))))
				slots)))
          (cons
           'begin
           (cons
            ;; on genere l'inline make-???
            (e `(define-inline (,(symbol-append 'make- name) . init)
		   ,(if slots-val?
			`(if (pair? init)
			     (if (not (null? (cdr init)))
				 (error ',(symbol-append 'make- name)
					"Too many argument provided"
					init)
				 (make-struct ',name ,len (car init)))
			     (,name ,@slots-val))
			`(if (pair? init)
			     (if (not (null? (cdr init)))
				 (error ',(symbol-append 'make- name)
					"Too many argument provided"
					init)
				 (make-struct ',name ,len (car init)))
			     (make-struct ',name ,len '()))))
	       e)
            (cons
             (e `(define-inline (,name ,@slots-name)
                    (let ((new (make-struct ',name ,len '())))
                       ,@(let loop ((slots slots-name)
                                    (res   '()))
                            (if (null? slots)
                                res
                                (loop (cdr slots)
                                      (cons `(,(symbol-append name
                                                              '-
                                                              (car slots)
                                                              '-set!)
                                              new
                                              ,(car slots))
                                            res))))
		       new))
		e)
             (cons
              ;; on genere le predicat STRUCT?
              (e `(define-inline (,(symbol-append name '?) o)
                     (if (struct? o)
                         (eq? (struct-key o) ',name)
                         #f))
                 e)
              ;; on genere les fonctions d'access aux slots
              (let loop ((i     0)
                         (slots slots-name)
                         (res   '((unspecified))))
                 (if (=fx i len)
                     res
                     (let ((pr (car slots)))
                        (loop (+fx i 1)
                              (cdr slots)
                              (cons
                               ;; la lecture
                               (e `(define-inline
                                      (,(symbol-append name '- pr) s)
                                      (if (,(symbol-append name '?) s)
                                          (struct-ref s ,i)
                                          (error
                                           "struct-ref:not an instance of"
                                           ,(symbol->string name)
                                           s)))
                                  e)
                               (cons
                                ;; l'ecriture
                                (e `(define-inline
                                       (,(symbol-append name '- pr '-set!) s v)
                                       (if (,(symbol-append name '?) s)
                                           (struct-set! s ,i v)
                                           (error
                                            "struct-set!:not an instance of"
                                            ,(symbol->string name)
                                            s)))
                                   e)
                                res))))))))))))
      (else
       (error "define-struct" "Illegal `define-struct' form" x))))
 
       
