package biss.jde;

import java.util.Enumeration;
import java.util.Vector;

/**
 * class representing a hierarchical structure of source code segments
 * (statements). Used by the MethodBrowser
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author P.C.Mehlitz
 */
public class FoldedStmt
{
	String Prolog;
	Vector SubStmts;
	int Id;
	String Paren;
	String Name;
	String PrologLabel;

public FoldedStmt () {

}

public FoldedStmt ( int id, String name, String paren) {

	Id = id;
	Name = name;
	Paren = paren;
}

void addFoldedStmt ( FoldedStmt stmt ) {
	if ( SubStmts == null )
		SubStmts = new Vector( 5);

	SubStmts.addElement( stmt);
}

void addSimpleStmt ( String stmtText ) {

	if ( SubStmts != null ) {
		FoldedStmt last = (FoldedStmt) SubStmts.lastElement();
		if ( last.SubStmts == null ) {
			last.Prolog += '\n';
			last.Prolog += stmtText;
		}
		else {
			last = new FoldedStmt();
			last.Prolog = stmtText;
			SubStmts.addElement( last);
		}
	}
	else {
		if ( Prolog != null ) {
			Prolog += '\n';
			Prolog += stmtText;

			PrologLabel += " ..";
		}
		else {
			Prolog = stmtText;
			PrologLabel = Prolog;
		}
	}
}

void dump () {
	System.out.println( "---------------------------");
	System.out.println( "key:    " + Name);
	System.out.println( "spec:   " + Paren);
	if ( Prolog != null )
		System.out.println( Prolog);
}
}
