/*
** Copyright (c) Massachusetts Institute of Technology 1994-1997.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@larch.lcs.mit.edu).
*/
/*
** mapping.h
*/

# ifndef MAPPING_H
# define MAPPING_H

typedef struct _mappair {
  lsymbol domain, range;
  /*@null@*/ struct _mappair *next;
} mappair;

typedef /*@relnull@*/ /*@only@*/ mappair *o_mappair;

typedef struct {
  unsigned int count;
  /*@relnull@*/ /*@only@*/ o_mappair *buckets;  
} mapping;


extern /*@only@*/ mapping *mapping_create (void);
extern lsymbol mapping_find (mapping *p_t, lsymbol p_domain);
extern void mapping_bind (mapping *p_t, lsymbol p_domain, lsymbol p_range);
extern void mapping_free (/*@only@*/ mapping *p_m);

# else
# error "Multiple include"
# endif
