#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "Xsqldefs.h"
#include "Recorddefs.h"

void RecordInsert(FL_OBJECT *ob, long parent)
{
   FD_Record *fd_Rec = (FD_Record *)parent;
   Info_t *I = (Info_t *)fd_Rec->vdata;
   int   y;
   char  query[MAXQUERY];
 
   sprintf(query,INSERT,I->Table);

   for(y=0;y<I->Numflds;y++)
   {
      TypeConvert(query + strlen(query),
		  fl_get_input(fd_Rec->Inputs[y]),I->Fields[y].type);

      if(y< I->Numflds - 1)
	strcat(query,",");
   }
   strcat(query,")");
   
#ifndef FORMS081   
   if(fl_show_question("Insert this record ?",1))
#else
     if(fl_show_question("Insert this record ?","",""))
#endif
     if (! ExecuteQuery(I,query))
     Info(I->Xsql,"Record inserted");
}

void XsqlInsert(FL_OBJECT *ob, long parent)
{
   FD_Xsql *Xsql = (FD_Xsql *)parent;
   Info_t  *I    = (Info_t *) Xsql->vdata;

   if(CheckTableSelected(Xsql) < 0)
     return;

   BuildRecordForm(I,"Insert Record",INSBUT);
}
