/*
 * FILE:    bat_include.h
 * PROGRAM: RAT
 * AUTHOR:  Vicky Hardman
 * 
 * $Revision: 1.47 $
 * $Date: 1997/05/27 10:27:44 $
 * 
 * Copyright (c) 1995,1996 University College London
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, is permitted, for non-commercial use only, provided
 * that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Computer Science
 *      Department at University College London
 * 4. Neither the name of the University nor of the Department may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 * Use of this software for commercial purposes is explicitly forbidden
 * unless prior written permission is obtained from the authors.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */



#include "config.h"

#ifndef __FreeBSD__
#include <malloc.h>
#endif
#include <stdio.h>
#include <memory.h>
#include <errno.h>
#include <math.h>
#include <stdlib.h>   /* abs() */
#include <string.h>
#include "assert.h"

#ifdef WIN32
#include <winsock.h>
#else /* WIN32 */
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/uio.h>
#include <netinet/in.h>
#include <sys/time.h>
#include <unistd.h>
#include <sys/param.h>
#include <sys/fcntl.h>
#include <sys/ioctl.h>
#include <netdb.h>
#include <arpa/inet.h>
extern int h_errno;
#if !defined(HPUX) && !defined(Linux) && !defined(__FreeBSD__)
#include <stropts.h>
#include <sys/filio.h>  
#endif /* HPUX */
#endif /* WIN32 */

#include "gsm.h"

#include "tcl.h"
#include "tk.h"

#include "util.h"
#include "codec_lpc.h"
#include "codec_adpcm.h"
#include "parameters.h"

#include "rtcp_pckt_p.h"
#include "rtcp_db_p.h"

#include "bat.h"

#include "rtcp_pckt.h"
#include "rtcp_db.h"

#include "net.h"
#include "audio.h"
#include "audio_mix.h"
#include "transcoder.h"

#include "interfaces.h"
#include "codec_codec.h"

#include "lbl_confbus.h"
#include "speaker_table.h"
#include "statistics.h"
#include "repair.h"
#include "receive.h"

#include "audits.h"
#include "mix.h"
#include "codec_encoder.h"
#include "codec_decoder.h"

#include "agc.h"
#include "ui.h"
#include "transmit.h"

#include "init_net.h"
#include "init_session.h"

#include "service_rtcp.h"

#include "crypt_global.h"
#include "crypt.h"
#include "crypt_random.h"
#include "md5.h"
#include "qfDES.h"


