
/*
 * LIB/SUBS.C
 *
 */

#include "defs.h"

Prototype void ArticleFileName(char *path, History *h, int absolute);
Prototype void strlcpy(char *d, const char *s, int ssize, int dsize);
Prototype void strlcpynl(char *d, const char *s, int ssize, int dsize);

void
ArticleFileName(char *path, History *h, int absolute)
{
    int l = 0;

    if (absolute) {
	sprintf(path, "%s/", SpoolHome);
	l = strlen(path);
    }

    if (h->boffset || h->bsize) {
	sprintf(path + l, "D.%08x/B.%04x",
	    h->gmt - h->gmt % 10,
	    (int)h->iter
	);
    } else {
	sprintf(path + l, "D.%08x/%08x.%08x.%04x",
	    h->gmt - h->gmt % 10,
	    h->hv.h1,
	    h->hv.h2,
	    h->iter
	);
    }
}

void 
strlcpy(char *d, const char *s, int ssize, int dsize)
{
    while (ssize && dsize > 1 && *s) {
	*d = *s;
	--ssize;
	--dsize;
	++s;
	++d;
    }
    *d = 0;
}

void 
strlcpynl(char *d, const char *s, int ssize, int dsize)
{
    char *dold = d;

    while (ssize && *s == ' ') {
	++s;
	--ssize;
    }

    while (ssize && dsize > 1 && *s) {
	*d = *s;
	--ssize;
	--dsize;
	++s;
	++d;
    }
    *d = 0;

    /*
     * remove newlines and trailing tabs and spaces
     */
    if (d != dold && d[-1] == '\n') {
	--d;
	*d = 0;
    }
    while (d != dold && (d[-1] == '\t' || d[-1] == ' ')) {
	--d;
	*d = 0;
    }
}

