/* This file is Copyright 1993 by Clifford A. Adams */
/* smisc.c
 *
 * Lots of misc. stuff, including the Xterm mouse-handling routines.
 */

#include "EXTERN.h"
#include "common.h"
#ifdef SCAN
#include "cache.h"
#include "rt-util.h"	/* for from-compression stuff */
#include "intrp.h"
#include "term.h"
#include "util.h"
#include "scan.h"
#include "sdisp.h"
#include "sorder.h"
#include "samisc.h"
#include "sadesc.h"
#include "sgroup.h"
#include "sgmisc.h"
#include "shelp.h"
#include "shmisc.h"
#include "svirt.h"
#include "svmisc.h"
#include "INTERN.h"
#include "smisc.h"

bool
s_eligible(ent)
long ent;
{
    switch (s_cur_type) {
	case S_ART:
	    return(sa_eligible(ent));
	case S_GROUP:
	    return(sg_eligible(ent));
	case S_HELP:
	    return(sh_eligible(ent));
	case S_VIRT:
	    return(sv_eligible(ent));
	default:
	    printf("s_eligible: current type is bad!\n") FLUSH;
	    return(FALSE);
    }
}

void
s_beep()
{
    putchar(7);
    fflush(stdout);
}

char *
s_get_statchars(ent,line)
long ent;
int line;
{
    switch (s_cur_type) {
	case S_ART:
	    return(sa_get_statchars(ent,line));
	case S_GROUP:
	    return(sg_get_statchars(ent,line));
	case S_HELP:
	    return(sh_get_statchars(ent,line));
	case S_VIRT:
	    return(sv_get_statchars(ent,line));
	default:
	    return(Nullch);
    }
}

char *
s_get_desc(ent,line,trunc)
long ent;
int line;
bool_int trunc;
{
    switch (s_cur_type) {
	case S_ART:
	    return(sa_get_desc(ent,line,trunc));
	case S_GROUP:
	    return(sg_get_desc(ent,line,trunc));
	case S_HELP:
	    return(sh_get_desc(ent,line,trunc));
	case S_VIRT:
	    return(sv_get_desc(ent,line,trunc));
	default:
	    return(Nullch);
    }
}

int
s_ent_lines(ent)
long ent;
{
    switch (s_cur_type) {
	case S_ART:
	    return(sa_ent_lines(ent));
	case S_GROUP:
	    return(sg_ent_lines(ent));
	case S_HELP:
	    return(sh_ent_lines(ent));
	case S_VIRT:
	    return(sv_ent_lines(ent));
	default:
	    return(1);
    }
}

/* copied from rt-util.c and edited slightly */
/* Fit the author name in <max> chars.  Uses the comment portion if present
** and pads with spaces.
*/
char *
s_compress_from(from, size)
char *from;
int size;
{
    static char lbuf[LBUFLEN];
    char *s, *t;
    int len;

    if (from)
	s = from;
    else
	s = nullstr;

    for (t = lbuf; *s; ) {
	if ((unsigned char)*s < ' ')
	    *t++ = ' ', s++;
	else
	    *t++ = *s++;
    }
    *t = '\0';
    if ((s = extract_name(lbuf)) != NULL)
	s = compress_name(s, size);
    else
	s = compress_address(lbuf, size);
    len = strlen(s);
    if (!len) {
	strcpy(s,"NO NAME");
	len = 7;
    }
    while (len < size)
	s[len++] = ' ';
    s[size] = '\0';
    return s;
}

/* xterm mouse stuff */
void
s_jump_scrline(scrline)
int scrline;
{
    int i;

    s_rub_ptr();
    if (scrline<s_top_lines) {
	s_ptr_page_line = 0;
	return;
    }
    scrline = scrline - s_top_lines;		/* adjust */
    for (i=0;i<=s_bot_ent;i++) {
	if ((scrline == page_ents[i].start_line) ||
	    (scrline < (page_ents[i].start_line + page_ents[i].lines)))
	    break;
    }
    if (i<=s_bot_ent)
	s_ptr_page_line = i;
    else
        s_ptr_page_line = i-1;
}

/* have the mouse button behaviors been initialized? */
static bool s_m_initialized INIT(FALSE);

static int button_cmd[3];
static char *button_txt[3];

/* what to push to the input after the button is released */
static char *mouse_push INIT(Nullch);
/* if TRUE, the mouse_push text was saved */
static bool m_push_saved INIT(FALSE);

void
s_mouse_init()
{
    /* Default behaviors:
     * 1: In article or virtual scan mode, mark current article
     *    In other scan modes, use current item.
     * 2: move to pointer location
     * 3: move up/down by page, depending on pointer location.
     */
    button_cmd[0] = 2;
    button_txt[0] = savestr("%(%m=[sv]?m:\n)");
    button_cmd[1] = 1;
    button_txt[1] = Nullch;
    button_cmd[2] = 3;
    button_txt[2] = Nullch;
    s_m_initialized = TRUE;
}

void
s_do_button(button,x,y)
int button;
int x,y;
{
    switch(button_cmd[button]) {
	case 1:
	    /* jump to line */
	    s_jump_scrline(y);
	    break;
	case 2:
	    /* jump to line and do command */
	    s_jump_scrline(y);
	    if (!button_txt[button])
		break;
	    /* filexp does expansions well */
	    mouse_push = savestr(filexp(button_txt[button]));
	    m_push_saved = TRUE;
	    break;
	case 3:
	    /* move forward or backwards a page:
	     *   if cursor in top half: backwards
	     *   if cursor in bottom half: forwards
	     */
	    if (y<(LINES/2))
		mouse_push = "<";
	    else
		mouse_push = ">";
	    break;
    }
}

void
s_do_mouse(button,x,y)
int button;	/* 0: button1  1: button2  2: button3  3: release */
int x,y;
{
    if (button == 3) {
	/* do range stuff here later? */
	return;
    }
    s_do_button(button,x,y);
}

void
s_mouse_button()
{
    int x,y;
    int button;

    if (!s_m_initialized)
	s_mouse_init();
    mouse_push = Nullch;
    m_push_saved = FALSE;

    read_tty(buf,1);
    button = (int)(buf[0]);
    read_tty(buf,1);
    x = (int)(buf[0])-33;
    read_tty(buf,1);
    y = (int)(buf[0])-33;
    s_do_mouse(button&3,x,y);

    /* get the button-up event */
    while (1) {
	getcmd(buf);
	if (*buf == 3)	/* got the button-up */
	    break;
	/* otherwise just eat any other keystrokes */
    }

    /* interpret the button-up event */
    read_tty(buf,1);
    button = (int)(buf[0]);
    read_tty(buf,1);
    x = (int)(buf[0])-33;
    read_tty(buf,1);
    y = (int)(buf[0])-33;
    s_do_mouse(button&3,x,y);

    if (mouse_push)
	pushstring(mouse_push,0);
    if (m_push_saved)
	free(mouse_push);
    mouse_push = Nullch;	/* just to be really safe */
}
#endif /* SCAN */
