//============================================================================
//
//    SSSS    tt          lll  lll              
//   SS  SS   tt           ll   ll                
//   SS     tttttt  eeee   ll   ll   aaaa    "An Atari 2600 VCS Emulator"
//    SSSS    tt   ee  ee  ll   ll      aa      
//       SS   tt   eeeeee  ll   ll   aaaaa   Copyright (c) 1995,1996,1997
//   SS  SS   tt   ee      ll   ll  aa  aa         Bradford W. Mott
//    SSSS     ttt  eeeee llll llll  aaaaa    
//
//============================================================================

/**
  The 16K cartridge class used by Atari cartridges.  There
  are 4 4K banks.

  @author  Bradford W. Mott
  @version $Id: CartF6.cxx,v 1.2 1997/05/17 19:00:03 bwmott Exp $
*/

#include "CartF6.hxx"
#include "System.hxx"

//============================================================================
// Constructor
//============================================================================
CartridgeF6::CartridgeF6(System& system, uByte* image)
    : Cartridge(system),
      myImageOffset(0)
{
  // Copy the ROM image into my buffer
  for(uWord i = 0; i < 4 * 4096; ++i)
    myImage[i] = image[i];

  // Map all of my addresses in the system
  for(uWord address = 0; address < 8192; ++address)
  {
    if(address & 0x1000)
    {
      // Is this read address a "hot spot"
      if( ((address & 0x0fff) == 0x0ff6) || ((address & 0x0fff) == 0x0ff7) ||
          ((address & 0x0fff) == 0x0ff8) || ((address & 0x0fff) == 0x0ff9))
      {
        mySystem.mapPeek(address, *this);
      }
      else
      {
        mySystem.mapPeek(address, *this, 
            &myImage[address & 0x0fff], &myImageOffset);
      }

      // Map any pokes to call my poke method
      mySystem.mapPoke(address, *this);
    }
  }

  // Reset myself
  reset();
}
 
//============================================================================
// Destructor
//============================================================================
CartridgeF6::~CartridgeF6()
{
}

//============================================================================
// Reset to my power on state
//============================================================================
void CartridgeF6::reset()
{
  // Start execution in bank #3
  myImageOffset = 3 * 4096;
}

//============================================================================
// Answer the byte at the given address
//============================================================================
uByte CartridgeF6::peek(uWord addr)
{
  // Switch banks if necessary
  switch(addr & 0x0fff)
  {
    case 0x0ff6:    // Bank #0
      myImageOffset = 0 * 4096;
      break;

    case 0x0ff7:    // Bank #1
      myImageOffset = 1 * 4096;
      break;

    case 0x0ff8:    // Bank #2
      myImageOffset = 2 * 4096;
      break;

    case 0x0ff9:    // Bank #3
      myImageOffset = 3 * 4096;
      break;

    default:
      break; 
  }

  return myImage[myImageOffset + (addr & 0x0fff)];
}

//============================================================================
// Store value in the given address
//============================================================================
void CartridgeF6::poke(uWord addr, uByte)
{
  // All we really do is switch banks
  switch (addr & 0x0fff)
  {
    case 0x0ff6:    // Bank #0
      myImageOffset = 0 * 4096;
      break;

    case 0x0ff7:    // Bank #1
      myImageOffset = 1 * 4096;
      break;

    case 0x0ff8:    // Bank #2
      myImageOffset = 2 * 4096;
      break;

    case 0x0ff9:    // Bank #3
      myImageOffset = 3 * 4096;
      break;

    default:
      break; 
  }
}
 
