//============================================================================
//
//    SSSS    tt          lll  lll              
//   SS  SS   tt           ll   ll                
//   SS     tttttt  eeee   ll   ll   aaaa    "An Atari 2600 VCS Emulator"
//    SSSS    tt   ee  ee  ll   ll      aa      
//       SS   tt   eeeeee  ll   ll   aaaaa   Copyright (c) 1995,1996,1997
//   SS  SS   tt   ee      ll   ll  aa  aa         Bradford W. Mott
//    SSSS     ttt  eeeee llll llll  aaaaa    
//
//============================================================================

#ifndef JOYSTICK_HXX
#define JOYSTICK_HXX

#include "machine.hxx"
#include "Control.hxx"

/**
  The 2600's joystick controller.

  @author  Bradford W. Mott
  @version $Id: Joystick.hxx,v 1.2 1997/05/17 19:00:05 bwmott Exp $
*/
class Joystick : public Controller
{
  public:
    /// Enumeration of which physical ports a joystick can be plugged in
    enum PhysicalPort { Zero, One };

  public:
    /// Constructor
    Joystick(const System& system, PhysicalPort port);
 
    /// Destructor
    virtual ~Joystick();

  public: 
    /// Invoked before each frame is generated
    virtual void update();

  public:
    /// Configure the TIA part of the controller
    virtual void configureTIA(TIACommand command);

  private:
    PhysicalPort myPort;
};
#endif

