/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                      Copyright (c) 1995,1996                          */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                    Author :  Simon King                               */
/*                    Date   :  January 1997                             */
/*-----------------------------------------------------------------------*/
/*                Decoder class for stack decoder                        */
/*                                                                       */
/*=======================================================================*/


#ifndef __DECODER_H__
#define __DECODER_H__

#include "Hypothesis.h"
#include "Acoustic_Model.h"
#include "Language_Model.h"

#define DEFAULT_MAX_HEAP_SIZE 1000 // temporary


class Decoder {
    
    // stack decoder using a heap
    
    // N.B. this is a STACK decoder, with the stack
    // implemented as a BINARY HEAP

    // see chapter 7 of "Introduction to Algorithms" 
    // by Cormen,Leiserson,Rivest, MIT Press 1989
    // for heap algorithms

    // this is a starting point for a proper decoder ...

private:
    
protected:
    
    // somewhere to keep the hypotheses
    Heap *heap;
    
    Acoustic_Model *acoustic_model;
    Language_Model *language_model;
    
    virtual EST_TList<Hypothesis*> generate_new_hypotheses(Hypothesis *current_hypothesis_ptr);
    virtual bool extend(Hypothesis *hypothesis_ptr);
    
public:
    
    Decoder();
    Decoder(Hypothesis *initial_hypothesis_ptr,
	    Acoustic_Model &amodel,
	    Language_Model &lmodel,
	    int m=DEFAULT_MAX_HEAP_SIZE);
    
    // destructor, deletes internal storage (heap)
    virtual ~Decoder();

    virtual void make_heap(int max_size);
    
    // find n most likely sentences
    // note : can be called multiple times
    bool decode(int n=1);
    
    // if stack empties, call recover()
    void recover();
    
    virtual void set_eval_fn(Hypothesis *hypothesis_ptr);
    virtual void set_log_prob(Hypothesis *hypothesis_ptr);
    virtual void set_partial_log_prob(Hypothesis *hypothesis_ptr);
    virtual void set_estimated_remaining_log_prob(Hypothesis *hypothesis_ptr);

    virtual void print(Hypothesis *hypothesis_ptr);
    virtual void delete_hypothesis(Hypothesis *hypothesis_ptr);

    // housekeeping
    virtual void control_heap(); 

    virtual bool is_finished(Hypothesis *hypothesis_ptr);
    virtual bool lm_is_finished(Hypothesis *hypothesis_ptr);
    virtual bool am_is_finished(Hypothesis *hypothesis_ptr);

    
};


#endif

