/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                      Copyright (c) 1995,1996                          */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                     Author :  Paul Taylor                             */
/*                     Date   :  April 1995                              */
/*-----------------------------------------------------------------------*/
/*                     Template Vector Class                             */
/*                                                                       */
/*=======================================================================*/

#include "EST_TVector.h"
#include "EST_TList.h"
#include "fstream.h"
#include "EST_cutils.h"

template<class T> EST_TVector<T>::EST_TVector()
{
    default_vals();
}

template<class T> EST_TVector<T>::EST_TVector(int n)
{
    default_vals();
    // allocate space
    x = new T[n];
    N = n;
}

template<class T> void EST_TVector<T>::default_vals()
{
    x = 0;
    N = 0;
}

template<class T>void  EST_TVector<T>::fill(T &v)
{
    for (int i = 0; i < N; ++i)
	x[i] = v;
}

template<class T> void EST_TVector<T>::copy(const EST_TVector<T> &a)
{
    int i;
    resize(a.num_points());

    for (i = 0; i < N; ++i)
      x[i] = a(i);
}

template<class T> EST_TVector<T>::EST_TVector(const EST_TVector<T> &in)
{
    default_vals();    
    copy(in);
}

// should copy from and delete old version first
template<class T> void EST_TVector<T>::resize(int newn)
{
    T *newx;
    newx = new T[newn];
    int i=0;

    if (N != 0)
	for (i = 0; i < Lof(N, newn); ++i)
	    newx[i] = x[i];

    for (; i < newn; ++i)
	newx[i] = def_val;
    if (x != 0)
	delete [] x;
    x = newx;
    N = newn;
}

template<class T> ostream& operator << (ostream &st, const EST_TVector<T> &a)
{
  int i;

  for (i = 0; i < a.num_points(); ++i)
    cout << a(i) << " ";

  cout << endl;
	
  return st;
}

template<class T> EST_write_status EST_TVector<T>::save(const EST_String &file)
{
    int i;
    ostream *outf;
    if (file == "-")
	outf = &cout;
    else
	outf = new ofstream(file);
    
    for (i = 0; i < num_points(); ++i)
      *outf << x[i] << " ";
    *outf << endl;
    
    if (outf != &cout)
	delete outf;
    return write_ok;
}

template<class T> EST_TVector<T> &EST_TVector<T>::operator=(const EST_TVector<T> &in)
{
    copy(in);
//    cout << "EQUALS\n";
    return *this;
}

template<class T> EST_TVector<T> &EST_TVector<T>::operator=(const EST_TList<T> &in)
{
    this->resize(in.length());
    EST_TBI *p;
    int i;
    for (i = 0, p = in.head(); p!= 0; p = next(p), ++i)
	x[i] = in.item_C(p);

    return *this;
}

template<class T> EST_TVector<T> &copy(EST_TVector<T> a, EST_TList<T> &in)
{
    a.resize(in.length());
    EST_TBI *p;
    for (i = 0, p = in.head(); p!= 0; p = next(p), ++i)
	a(i) = in.item(p);

    return a;
}

template<class T> T &EST_TVector<T>::operator()(int n) const
{
    if (n >= N)
    {
	cerr << "Tried to access point " << n<<" of "<<N<<" column vector\n";
	n = 0;
    }

    return x[n];
}

template<class T> int EST_TVector<T>::operator ==(const EST_TVector<T> &v) const
{
  if (N != v.N)
    return 0;

  for(int i=0; i<N ; i++)
    if (x[i] != v.x[i])
      return 0;
  return 1;
}

template<class T> int EST_TVector<T>::operator !=(const EST_TVector<T> &v) const
{
  if (N != v.N)
    return 1;

  for(int i=0; i<N ; i++)
    if (x[i] != v.x[i])
      return 1;
  return 0;
}

