.TH XIDLE 1 "Release 5" "X Version 11"
.SH NAME
xidle \- CPU idle time display for X
.SH SYNOPSIS
.ta 6n
\fBxidle\fP	[-\fItoolkitoption\fP ...] [-update \fIseconds\fP]
[-hl \fIcolor\fP] [-highlight \fIcolor\fP] [-jumpscroll \fIpixels\fP]
[-label \fIstring\fP] [-nolabel] 
.SH DESCRIPTION
The 
.I xidle 
program displays a periodically updating histogram of the cpu idle time.
.SH OPTIONS
.PP
.I Xidle
accepts all of the standard X Toolkit command line options (see \fIX(1)\fP).
The order of the options in unimportant.  \fIxidle also accepts the
following additional options:
.PP
.TP 8
.B \-hl \fIcolor\fP or \-highlight \fIcolor\fP
This option specifies the color of the scale lines.  
.TP 8
.B \-jumpscroll \fPnumber of pixels\fP
The number of pixels to shift the graph to the left when the graph
reaches the right edge of the window.  The default value is 1/2 the width
of the current window.  Smooth scrolling can be achieved by setting it to 1.
.TP 8
.B \-label \fIstring\fP
The string to put into the label above the idle display.
.TP 8
.B \-nolabel
If this command line option is specified then no label will be
displayed above the idle graph.
.TP 8
.B \-update \fIseconds\fP
This option specifies the interval in seconds at which \fIxidle\fP
updates its display.  The minimum amount of time allowed between updates
is 1 second.  The default is 10.
.SH RESOURCES
In addition to the resources available to each of the widgets used by 
\fIxidle\fP there is one resource defined by the application itself.
.TP 8
.B showLabel (\fPclass\fB Boolean)
If False then no label will be displayed.
.SH WIDGETS
In order to specify resources, it is useful to know the hierarchy of
the widgets which compose \fIxidle\fR.  In the notation below,
indentation indicates hierarchical structure.  The widget class name
is given first, followed by the widget instance name.
.sp
.nf
.ta .5i 1.0i 1.5i 2.0i
Xidle  xidle
	Paned  paned
		Label  label
		StripChart  idle
.fi
.sp
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH FILES
/usr/lib/X11/app-defaults/Xidle - specifies required resources
.SH SEE ALSO
X(1), xrdb(1), mem(4), Athena StripChart Widget.
.SH COPYRIGHT
Copyright 1988, Massachusetts Institute of Technology.
.br
See \fIX(1)\fP for a full statement of rights and permissions.
.SH AUTHORS
xidle is a derivate of xload which was written by
K. Shane Hartman (MIT-LCS) and Stuart A. Malone (MIT-LCS);
.br
with features added by Jim Gettys (MIT-Athena), Bob Scheifler (MIT-LCS),
Tony Della Fera (MIT-Athena), and Chris Peterson (MIT-LCS).
The xidle enhancements wer done by Hans-Helmut Buehmann.
