/*
 * event.c
 *
 * This is the callback function for the modem to the higher level
 * routines.
 *
 */

#include "../include/voice.h"

char *libvoice_event_c = "$Id: event.c,v 1.4 1996/07/25 19:23:24 marc Exp $";

static int events_to_shell = FALSE;
int (*program_handle_event) _PROTO((int event, event_data data)) = NULL;

int voice_handle_event(int event, event_data data)
     {
     lprintf(L_JUNK, "%s: voice_handle_event got event 0x%x with data 0x%x",
      program_name, event, data.c);

     if ((voice_shell_state != OFF_LINE) && (event == SIGNAL_SIGCHLD))
          {
          voice_shell_signal = FALSE;
          voice_shell_state = OFF_LINE;

          switch (voice_modem_state)
               {
               case DIALING:
                    voice_modem_handle_event(VOICE_STOP_DIALING,
                     (event_data) 0);
                    break;
               case PLAYING:
                    voice_modem_handle_event(VOICE_STOP_PLAYING,
                     (event_data) 0);
                    break;
               case RECORDING:
                    voice_modem_handle_event(VOICE_STOP_RECORDING,
                     (event_data) 0);
                    break;
               case WAITING:
                    voice_modem_handle_event(VOICE_STOP_WAITING,
                     (event_data) 0);
                    break;
               };

          return(OK);
          };

     if (((event & SIGNAL_EVENT) != 0) && (voice_shell_state != OFF_LINE))
          voice_shell_signal = TRUE;

     if ((voice_shell_state != OFF_LINE) && (event == SIGNAL_SIGPIPE))
          {
          char buffer[VOICE_BUF_LEN];

          if (voice_read_shell(buffer) != OK)
               return(FAIL);

          if (voice_shell_state == INITIALIZING)
               {

               if (strcmp(buffer, "HELLO VOICE PROGRAM") != 0)
                    {
                    lprintf(L_ERROR,
                     "%s: cannot initialize communication!", program_name);
                    voice_shell_state = OFF_LINE;
                    return(FAIL);
                    };

               if (voice_write_shell("READY") != OK)
                    return(FAIL);

               voice_shell_state = ON_LINE;
               lprintf(L_NOISE, "%s: initialized communication", program_name);
               }
          else
               {

               if (strncmp(buffer, "BEEP", 4) == 0)
                    {
                    int frequency = cvd.beep_frequency.d.i;
                    int length = cvd.beep_length.d.i;

                    sscanf(buffer, "%*s %d %d", &frequency, &length);

                    if (voice_write_shell("BEEPING") != OK)
                         return(FAIL);

                    voice_beep(frequency, length);

                    if (voice_write_shell("READY") != OK)
                         return(FAIL);

                    }
               else if (strncmp(buffer, "DEVICE", 6) == 0)
                    {
                    char device[VOICE_BUF_LEN] = "";

                    sscanf(buffer, "%*s %s", device);

                    if (strcmp(device, "NO_DEVICE") == 0)
                         voice_set_device(NO_DEVICE);
                    else if (strcmp(device, "DIALUP_LINE") == 0)
                         voice_set_device(DIALUP_LINE);
                    else if (strcmp(device, "EXTERNAL_MICROPHONE") == 0)
                         voice_set_device(EXTERNAL_MICROPHONE);
                    else if (strcmp(device, "INTERNAL_SPEAKER") == 0)
                         voice_set_device(INTERNAL_SPEAKER);
                    else if (strcmp(device, "LOCAL_HANDSET") == 0)
                         voice_set_device(LOCAL_HANDSET);
                    else if (voice_write_shell("ERROR") != OK)
                         return(FAIL);

                    if (voice_write_shell("READY") != OK)
                         return(FAIL);

                    }
               else if (strncmp(buffer, "DIAL", 4) == 0)
                    {
                    char phone_number[VOICE_BUF_LEN] = "";

                    sscanf(buffer, "%*s %s", phone_number);

                    if (voice_write_shell("DIALING") != OK)
                         return(FAIL);

                    voice_dial((void *) phone_number);

                    if (voice_write_shell("READY") != OK)
                         return(FAIL);

                    }
               else if (strncmp(buffer, "DISABLE EVENTS", 14) == 0)
                    {
                    events_to_shell = FALSE;

                    if (voice_write_shell("READY") != OK)
                         return(FAIL);

                    }
               else if (strncmp(buffer, "ENABLE EVENTS", 13) == 0)
                    {
                    events_to_shell = TRUE;

                    if (voice_write_shell("READY") != OK)
                         return(FAIL);

                    }
               else if (strcmp(buffer, "GOODBYE") == 0)
                    {

                    if (voice_write_shell("GOODBYE SHELL") != OK)
                         return(FAIL);

                    }
               else if (strncmp(buffer, "PLAY", 4) == 0)
                    {
                    char name[VOICE_BUF_LEN] = "";

                    sscanf(buffer, "%*s %s", name);

                    if (strlen(name) != 0)
                         {

                         if (voice_write_shell("PLAYING") != OK)
                              return(FAIL);

                         voice_play_file(name);
                         }
                    else
                         {

                         if (voice_write_shell("ERROR") != OK)
                              return(FAIL);

                         }

                    if (voice_write_shell("READY") != OK)
                         return(FAIL);

                    }
               else if (strncmp(buffer, "RECORD", 6) == 0)
                    {
                    char name[VOICE_BUF_LEN] = "";

                    sscanf(buffer, "%*s %s", name);

                    if (strlen(name) != 0)
                         {

                         if (voice_write_shell("RECORDING") != OK)
                              return(FAIL);

                         voice_record_file(name);
                         }
                    else
                         {

                         if (voice_write_shell("ERROR") != OK)
                              return(FAIL);

                         }

                    if (voice_write_shell("READY") != OK)
                         return(FAIL);

                    }
               else if (strncmp(buffer, "STOP", 4) == 0)
                    {

                    switch (voice_modem_state)
                         {
                         case DIALING:
                              voice_modem_handle_event(VOICE_STOP_DIALING,
                               (event_data) 0);
                              break;
                         case IDLE:

                              if (voice_write_shell("READY") != OK)
                                   return(FAIL);

                              break;
                         case PLAYING:
                              voice_modem_handle_event(VOICE_STOP_PLAYING,
                               (event_data) 0);
                              break;
                         case RECORDING:
                              voice_modem_handle_event(VOICE_STOP_RECORDING,
                               (event_data) 0);
                              break;
                         case WAITING:
                              voice_modem_handle_event(VOICE_STOP_WAITING,
                               (event_data) 0);
                              break;
                         default:

                              if (voice_write_shell("ERROR") != OK)
                                   return(FAIL);

                         };

                    }
               else if (strncmp(buffer, "WAIT", 4) == 0)
                    {
                    int length = cvd.rec_silence_len.d.i / 10;

                    sscanf(buffer, "%*s %d", &length);

                    if (voice_write_shell("WAITING") != OK)
                         return(FAIL);

                    voice_wait(length);

                    if (voice_write_shell("READY") != OK)
                         return(FAIL);

                    }
               else
                    {

                    if (voice_write_shell("ERROR") != OK)
                         return(FAIL);

                    }

               };

          return(OK);
          };

     if ((voice_shell_state == ON_LINE) && events_to_shell &&
      ((event & VOICE_MODEM_EVENT) != 0))
          {

          switch (event)
               {
               case BUSY_TONE:

                    if (voice_write_shell("BUSY_TONE") != OK)
                         return(FAIL);

                    return(OK);
               case DIAL_TONE:

                    if (voice_write_shell("DIAL_TONE") != OK)
                         return(FAIL);

                    return(OK);
               case DATA_CALLING_TONE:

                    if (voice_write_shell("DATA_CALLING_TONE") != OK)
                         return(FAIL);

                    return(OK);
               case FAX_CALLING_TONE:

                    if (voice_write_shell("FAX_CALLING_TONE") != OK)
                         return(FAIL);

                    return(OK);
               case NO_VOICE_ENERGY:

                    if (voice_write_shell("NO_VOICE_ENERGY") != OK)
                         return(FAIL);

                    return(OK);
               case RECEIVED_DTMF:

                    if (voice_write_shell("RECEIVED_DTMF") != OK)
                         return(FAIL);

                    if (voice_write_shell("%c", data.c) != OK)
                         return(FAIL);
                         ;
                    return(OK);
               case SILENCE_DETECTED:

                    if (voice_write_shell("SILENCE_DETECTED") != OK)
                         return(FAIL);

                    return(OK);
               case HANDSET_ON_HOOK:

                    if (voice_write_shell("HANDSET_ON_HOOK") != OK)
                         return(FAIL);

                    return(OK);
               case HANDSET_OFF_HOOK:

                    if (voice_write_shell("HANDSET_OFF_HOOK") != OK)
                         return(FAIL);

                    return(OK);
               case LOOP_BREAK:

                    if (voice_write_shell("LOOP_BREAK") != OK)
                         return(FAIL);

                    return(OK);
               };

          };

     if (program_handle_event != NULL)

          if (program_handle_event(event, data) == OK)
               return(OK);

     switch (voice_modem_state)
          {
          case DIALING:

               switch (event)
                    {
                    case SIGNAL_SIGALRM:
                    case SIGNAL_SIGHUP:
                    case SIGNAL_SIGINT:
                    case SIGNAL_SIGQUIT:
                    case SIGNAL_SIGTERM:
                    case BUSY_TONE:
                    case DATA_CALLING_TONE:
                    case FAX_CALLING_TONE:
                         return(voice_modem_handle_event(VOICE_STOP_DIALING,
                          (event_data) 0));
                    };

               break;
          case PLAYING:

               switch (event)
                    {
                    case SIGNAL_SIGALRM:
                    case SIGNAL_SIGHUP:
                    case SIGNAL_SIGINT:
                    case SIGNAL_SIGQUIT:
                    case SIGNAL_SIGTERM:
                    case BUSY_TONE:
                    case DIAL_TONE:
                    case DATA_CALLING_TONE:
                    case FAX_CALLING_TONE:
                    case HANDSET_OFF_HOOK:
                    case HANDSET_ON_HOOK:
                         return(voice_modem_handle_event(VOICE_STOP_PLAYING,
                          (event_data) 0));
                    };

               break;
          case RECORDING:

               switch (event)
                    {
                    case SIGNAL_SIGALRM:
                    case SIGNAL_SIGHUP:
                    case SIGNAL_SIGINT:
                    case SIGNAL_SIGQUIT:
                    case SIGNAL_SIGTERM:
                    case BUSY_TONE:
                    case DIAL_TONE:
                    case DATA_CALLING_TONE:
                    case FAX_CALLING_TONE:
                    case NO_VOICE_ENERGY:
                    case SILENCE_DETECTED:
                    case HANDSET_OFF_HOOK:
                    case HANDSET_ON_HOOK:
                         return(voice_modem_handle_event(VOICE_STOP_RECORDING,
                          (event_data) 0));
                    };

               break;
          case WAITING:

               switch (event)
                    {
                    case SIGNAL_SIGALRM:
                    case SIGNAL_SIGHUP:
                    case SIGNAL_SIGINT:
                    case SIGNAL_SIGQUIT:
                    case SIGNAL_SIGTERM:
                    case BUSY_TONE:
                    case DIAL_TONE:
                    case DATA_CALLING_TONE:
                    case FAX_CALLING_TONE:
                         return(voice_modem_handle_event(VOICE_STOP_WAITING,
                          (event_data) 0));
                    };

               break;
          };

     lprintf(L_WARN,
      "%s: voice_handle_event got unknown event 0x%x with data 0x%x",
      program_name, event, data.c);
     return(FAIL);
     };

int voice_register_event_handler(int (*new_program_handle_event) (int event,
 event_data data))
     {
     program_handle_event = new_program_handle_event;
     return(OK);
     };

int voice_unregister_event_handler(void)
     {
     program_handle_event = NULL;
     return(OK);
     };
