.\" Generated by html2man
.TH ical 1
.SH NAME
ical - An X based Calendar Program
.SH SYNOPSIS
\fIIcal\fR provides an X interface for maintaining a calendar.  A
calendar is basically just a set of items. An item is either an
appointment, or a notice. An appointment starts
at a particular time of the day, and finishes at a particular time of
the day. A notice does not have any starting or
ending time. Notices are useful for marking certain days as
special. For example, a calendar may contain a notice for April 15th
indicating that taxes are due.  When the documentation below refers to
an \fIitem\fR, it applies both to notices and appointments.  The
main features of \fIical\fR are:
.RS
.PD 0
.HP 2
.PD
* Items can be created and edited easily.
.PD 0
.HP 2
.PD
* Items can be cut, copied and pasted.
.PD 0
.HP 2
.PD
* Items can be made to repeat in various ways.
.PD 0
.HP 2
.PD
* Ical will generate alarms for upcoming
appointments.
.PD 0
.HP 2
.PD
* Users can view many calendars at a time.
.PD 0
.HP 2
.PD
* Calendars can be shared by many users.
.PD 0
.HP 2
.PD
* Related items can be grouped in their own calendar.
.RE
.SH INVOCATION
You can specify various command line options to control \fIical\fR.
.SS General Options
The following options can be used even when you are not logged in on
an X display.
.RS
.IP " -calendar \fIfile-name\fR"
The calendar is read from the specified file.  See the
description of calendar files
for more information.
.IP " -date \fIdate\fR"
Set the starting date for item listings or window display to
the specified date.
.IP " -list"
Print a listing of the starting date's items and exit immediately.
See the description of listing items
for details on the actual items printed by this option.
The starting date is usually today, but may be changed with
the -date option.
.IP " -show +\fIdays\fR"
Print a listing for items in the range
\fR[starting date...(starting date + days - 1)]\fR
and exit immediately.
See the description of listing items
for details on the actual items printed by this option.
The starting date is usually today, but may be changed with
the -date option.
.IP " -print \fR1|2|4|8|10|month\fR"
Generate postscript on standard output for range of days and exit.
The starting date is usually today, but may be changed with
the -date option.
.RE
.SS X Options
The following options are valid only if you are logged in on an X
display.
.RS
.IP " -iconic"
Start up with the main window iconified.
.IP " -iconposition \fIx\fR,\fIy\fR"
Icon is placed at the specified position.
.IP " -popup"
Popup a window containing a listing of the starting date's items
and exit as soon as the window is dismissed.
See the description of listing items
for details on the actual items printed by this option.
The starting date is usually today, but may be changed with
the -date option.
.IP " -geometry \fIgeometry\fR"
Use \fIgeometry\fR as the geometry for the main window.
.IP " -fg \fIcolor\fR"
Use \fIcolor\fR as the foreground for all windows.
.IP " -bg \fIcolor\fR"
Use \fIcolor\fR as the background for all windows.
.IP " -display \fIdisplay\fR"
Run \fIical\fR on the specified X display.
.RE
.SH WINDOWS
The main calendar window displays the appointments and notices for a
particular date.
.RS
.IP " Date Selector"
The top left portion of the window contains a date selector.  You
can click on the various arrows to change the month or the year.  The
day of the month can be selected by clicking on the appropriate day in
the month display.  The date selector contains various other buttons
for convenient date selection.
.IP " Notice Window"
The bottom left portion of the window contains the notices for
the selected date. A scroll bar is provided if all of the notices for
the selected date do not fit into the notice window.
.IP " Appointment Window"
The right portion of the window contains the appointments for the
selected day. You can scroll this region by using the scroll bar, or
by dragging with the middle mouse button in the background.
.IP " Menubar"
A menubar runs along the top of the calendar window.  The
\fIFile menu\fR allows you to create and destroy application
windows.
.IP " Status Line"
The bottom portion of the window contains a status line. This
status line indicates the calendar from which the selected item comes
and whether or not the selected item repeats.
.RE
.SH CALENDAR FILES
A calendar is stored in a calendar file. The default calendar file is
named \fR.calendar\fR and is kept in the user's home
directory. If the \fRCALENDAR\fR environment variable is set,
its value is used as the name of the calendar file. The
\fRCALENDAR\fR environment variable and the default can both be
overridden by specifying a file name on the command line as follows --
.DS
ical -calendar \fIfile-name\fR.
.DE
\fIIcal\fR periodically saves any modifications made to a
calendar to the corresponding calendar file. It also periodically
incorporates changes made to a shared calendar file by other instances
of ical.  You can explicitly trigger these periodic saves and
reads by using the File menu.
.SS Including and Sharing Calendars
You can include other calendars into your private calendar. This
facility is mainly useful for allowing a group of people to share a
common set of items. For example, members of a particular group might
have a calendar that contains the birthdays for each member of the
group. This calendar can be included in each group member's private
calendar.  Use the File menu to include and
exclude shared calendars.  Use the \fIMove Item To ...\fR entry
from the Item menu to move items between
calendars.  Use the \fIFrom Calendar ...\fR entry in the List menu to list all items a particular
calendar.
.SH ITEMS
.SS Notices
You can enter notices by clicking in the background in the bottom-left
portion of the main calendar window. This click will create a new
notice for the selected date.  You can enter text into the notice by
typing into it while it is selected (selected notices are highlighted
by being displayed in different colors).  A notice can be selected for
editing by clicking with left button.
.SS Appointments
You can enter appointments by left-clicking in the background in the
right portion of the main calendar window. This click will create a
new appointment for the selected date. The start time for this
appointment is determined by the click location. You can move the
appointment by dragging it with the middle mouse button held down. The
appointment can be resized by dragging with the right mouse button
held down.
.PP
Appointment text can be edited by typing into the appointment window
while it is selected.  If the appointment text you are typing in does
not fit into the appointment area, then it will overflow out of the
appointment area, but will be editable normally.  If you do not like
overflowing text, you should turn off the \fIAllow Text Overflow\fR
option in the Options menu .  With this
option turned off, if the current text completely fills the area
allocated to the appointment, then any attempts to add to the
appointment text will be ignored until the appointment is enlarged
with the right mouse button.  Likewise, the right mouse button will
refuse to shrink an appointment window if the appointment text
completely fills the appointment window.
.SS Alarms
\fIIcal\fR generates alarms for appointments. By default, the first
alarm is generated fifteen minutes before the appointment is supposed
to start and successive alarms are generated every five minutes until
the appointment actually starts.  You can change this default behavior
by selecting the \fIDefault Alarms\fR entry from the Options menu.  You can also change the timings
of these alarms on an appointment-by-appointment basis by
double-clicking on the appointment, or by selecting the appointment
and then chosing the \fIProperties\fR entry in the Item menu.
.SS Repeating Items
Items can be made to repeat in various ways. Item repetition can be
controlled by using the entries in the Repeat
menu.  These entries make the item repeat in certain frequently
used ways. For example, the \fIMonthly\fR entry makes the selected
item repeat once per month and the \fIWeekly\fR entry makes the
selected item repeat once per week.  The \fIEdit Monthly\fR... and
\fIEdit Weekly\fR... entries can be used to make items that repeat
in more complex ways: for example, an item that occurs on the last
Friday of each month, or an item that occurs on Monday, Wednesday, and
Friday every week.
.PP
In addition to making an item repeat in one of the pre-defined ways,
you can also restrict an item's starting and finishing date by
selecting the \fISet Range\fR... entry from the
Repeat menu.
.PP
Normally, a modification to a repeating item applies to all
occurrences of that item. A single occurrence of a repeating item can
be modified by selecting the occurrence and then choosing the
\fIMake\fR \fIUnique\fR entry from the Repeat menu.  The selected occurrence can now
be modified independently of the repeating item.
.SS Todo Items
Items can be marked as \fItodo\fR items by selecting the
\fITodo\fR entry in the Item menu.  A
\fItodo\fR item is automatically moved forward to today's date
every day until the item is deleted or marked as done.  An item
can be marked as done by clicking in the little check-box right
next to the displayed item.
.SS Highlighting
By default, if any item occurs on a date, then the date is highlighted
in the date selector located in the top-left corner of the calendar
window.  You can use the \fIHighlight\fR entries in the Item menu to control this highlighting behavior
on an item-by-item basis.
.SH KEY BINDINGS
\fIThis section is currently incomplete.\fR
.SH EDITING
Dragging with the left mouse button in a selected appointment or
notice sets the X selection.  The Edit menu
provides commands for dealing with the X selection.
.PP
Ical also has a clipboard that can store a single item. The
\fICopy\fR entry in the Edit menu copies
the selected item into the clipboard.  The \fICut\fR entry does the
same, but it also deletes the item from the calendar. If the selected
item repeats, then the \fICut\fR command allows the user to delete
all occurrences of the item, or just the selected occurrence.
However, if the selected item does not belong to you, then
\fICut\fR just hides the item from you.  Other people will still
see the item.  An item in the clipboard can be inserted into the
current day by selecting \fIPaste\fR entry. The newly pasted item
loses all repetition information, and occurs just on the day in which
it was pasted.
.SH LISTING ITEMS
You can generate listings of imminent items by selecting one of the
listing options in the List menu.  You can
also use the command line options \fR-list\fR,
\fR-show\fR, or \fR-popup\fR to generate item listings.
The command line options are most useful in \fR.login\fR files.
.PP
By default an item is included in a listing for a particular date if
it occurs either on that date, or on the very next day.  You can
control this feature of item listings with the \fIList item\fR
entry in the Item menu.
.SH PRINTING
Calendar contents can be printed by selecting the \fIPrint\fR
option from the File menu.
.SH CUSTOMIZATION
Some of \fIical's\fR behavior can be customized via the Options menu.  Other aspects of ical's
behavior can be controlled via X Resources.
.SS X Resources
.SS Behavior
The following X resources can be used to control various aspects of
ical's behavior.
.RS
.IP " Ical.pollSeconds"
Shared calendars are checked for changes made by other people
once every \fIpollSeconds\fR seconds.  The default value is
120.  If \fIical\fR appears sluggish, or if it is using too
much CPU time, increase this value.
.IP " Ical.saveSeconds"
Calendar files are saved once every \fIsaveSeconds\fR seconds.
The default value is 30.  If \fIical\fR appears sluggish, or
if it is using too much CPU time, increase this value.
.RE
.SS Dimensions
The following X resources can be used to control various dimensions of
ical's appearance.
.RS
.IP " Ical.itemSelectWidth"
The border width of selected items is set to the value of this
option to display the selected status of the item to to the user.
On color displays, the default value of this option is 1
because on color displays selection is indicated by changing the
color of the selected item.  On monochrome displays, the default
value of \fIitemSelectWidth\fR is 4.
.IP " Ical.Dayview.geometry"
X geometry specification for main calendar window.  Usually, you
will just specify the window position here.  The size of the
window is easier to control via the \fIOptions\fR menu.
.IP " Ical.Reminder.geometry"
X geometry specification for alarms.  Usually, you will just
specify the window position here.  The window size will be
calculated automatically.
.IP " Ical.Listing.geometry"
X geometry specification for item listings.  Usually, you will
just specify the window position here.  The window size will be
calculated automatically.
.RE
.SS Colors
The following X resources can be used to customize ical's use of
colors.  If ical windows show up with illegible colors (not enough
distinction between background and foreground), it may be because your
X resources contain definitions for \fR*foreground\fR or
\fR*background\fR that conflict with ical colors.  In general,
it is a bad idea to define \fR*foreground\fR and
\fR*background\fR in your resources because it will break a
number of programs.  You will be better off defining resources on an
application by application basis.
.RS
.IP " Ical*foreground/Ical*background"
Foreground and background colors for most of ical's windows.
.IP " Ical*disabledForeground"
Foreground color assigned to disabled buttons and menu entries.
.IP " Ical.itemFg/Ical.itemBg"
Foreground and background colors for unselected items.  The
default foreground is black and the default background is gray.
.IP " Ical.itemSelectFg/Ical.itemSelectBg"
Foreground and background colors for selected items.  The default
foreground is black and the default background is SlateBlue1.
.IP " Ical.itemOverflowColor/Ical.itemOverflowStipple"
Background color and stippling used for appointment text that
overflows out of the appointment area.  On color displays, the
default overflow background is SlateBlue3 and no stippling is done
(specified by an empty stipple option).  On monochrome displays,
the default overflow background is black, and the default
overflow stippling is gray50.
.IP " Ical.apptLineColor"
The color for the background lines and times displayed in the
appointment window.
.IP " Ical.weekdayColor"
The color used to display days of the week.  The default is black.
.IP " Ical.weekendColor"
The color used to display weekends.  The default is red.
.IP " Ical.interestColor"
The color used to highlight interesting dates.  The default is blue.
.IP " Ical.weekendInterestColor"
The color used to highlight interesting dates on weekends and
holidays.  The default is purple.
.RE
.SS Fonts
The following resources can be used to customize ical's use of fonts.
.RS
.IP " Ical.fontFamily"
Preferred font family.  Fonts for various purposes are obtained
from this family unless overridden with one of the specifications
below.  The default font family is \fRtimes\fR.  Some other font
families you can specify here are \fRcharter\fR, \fRnew
century schoolbook\fR, and \fRhelvetica\fR.  My
personal favorite is \fRnew century schoolbook\fR.
.IP " Ical.fontSize"
Font sizes used for ical.  Use the value \fRsmall\fR to
use small font sizes everywhere.  Any other value for this option
defaults to the normal fonts.
.IP " Ical*itemFont"
Font used to display item contents.
.IP " Ical.weekdayFont"
Font used for displaying days of the week.
.IP " Ical.weekendFont"
Font used for displaying weekends.
.IP " Ical.interestFont"
Font used to highlight interesting dates.
.IP " Ical.weekendInterestFont"
Font used to highlight interesting dates on weekends and holidays.
.IP " Ical.smallHeadingFont"
Font used for small headings.
.IP " Ical.largeHeadingFont"
Font used for large headings.
.IP " Ical*<\fIclass\fR>*font:"
Font used for windows of a certain class.  Possible values for
<\fIclass\fR> are \fRDialog\fR,
\fRButton\fR, \fRLabel\fR, \fRMenubutton\fR,
\fRMenu\fR, \fRListbox\fR, and \fRReminder\fR.
.RE
.SS Tcl Code
Users can also customize ical by writing tcl code and storing it in
the file \fR~/.tk/ical/user.tcl\fR.  The code stored in this
file is executed when ical starts up.
.PP
Ical also looks for site-specific customizations at startup.  These
customizations can be placed in the file \fRsite.tcl\fR in
either the ical library directory, or its parent directory.  (By
default, ical looks for site.tcl in
\fR/usr/local/lib/ical/v[\fIversion\fR]/\fR, and
\fR/usr/local/lib/ical/\fR, but these directories
may be located elsewhere on your system.)  The site specific files
will be loaded in before any user specific customization file is
loaded in.
.PP
See the document
Customizing Ical for help on writing tcl code for customizing ical.
This document is available via the World Wide Web at the following location.
.RS
http://www.pmg.lcs.mit.edu/~sanjay/ical/interface.ps
.RE
.PP
\fBIcal can run even when X is not available, therefore
customization files should be written so that they will function
even when Tk commands are not available.\fR
.SH MENUS
.SS File Menu
.RS
.IP " Save"
Save any modifications to the appropriate calendar files.
.IP " Re-Read"
Read any changes made to a shared calendar by another user
or another instance of ical.
Ical will automatically invoke this function periodically.
It is provided as a menu entry only so for people who do not
want to wait for ical's periodic checks.
.IP " Print"
Print calendar contents.  The user has the option of saving the
print-out to a file, pre viewing the print-out by specifying a
PostScript displaying program, or sending the print-out directly
to a PostScript printer by specifying a printing command.
.IP " Include Calendar"
Select a calendar to include into your private calendar.
Included calendars are normally used to share calendars between
different users.
.IP " Remove Include"
Remove a previously included calendar from your private calendar.
.IP " New Window"
Open a new calendar window. This new window can be used to view the
items for a different date than the original window.
.IP " Close Window"
Close the selected window.
.IP " Exit"
Save any changes and kill ical.
.RE
.SS Edit Menu
.RS
.IP " Cut"
Delete the currently selected item and store it in the
clipboard.
.IP " Copy"
Copy selected item to the clipboard.
.IP " Paste"
Paste item from clipboard into calendar.
.IP " Import Text"
Import the current X selection as a new item into the calendar.
The date and time of this new item are parsed from the X
selection if possible.
.IP " Search Forward"
Search forward looking for an item that contains a user specified string.
.IP " Search Backward"
Search backward looking for an item that contains a user specified string.
.RE
.SS Item Menu
.RS
.IP " Todo"
Toggle the item between being a todo item and not being a todo
item.
.IP " Always Highlight"
The item always causes the corresponding date to be highlighted.  This
is the default behavior.
.IP " Never Highlight"
The item never causes the corresponding date to be highlighted.
.IP " Highlight Future"
The item causes the corresponding date to be highlighted if and only
if the date is not in the past.
.IP " Holiday"
The item causes the corresponding date to be highlighted as a holiday.
.IP " Change Alarms"
This item pops up a dialog box that allows you to edit the alarm
times for an appointment.
.PP
Note that this will only change the alarm times for the
selected appointments.  You can make this change for all appointments
that do not have special alarm times by using the
\fIDefault Alarms\fR entry in the
Options menu.
.IP " Early Warning"
By default an item is included in a listing for a particular date
if it occurs either on that date, or on the very next day.
Sometimes, you may want to include an item in listings for
earlier dates. For example, if you have an item reminding you of
a birthday on March 17th, you might want this item to be included
in all listings from March 7th to March 17th so that you will
have enough time to go out and buy a present.  You can achieve
this effect by selecting this menu entry and then entering "10 days"
into the resulting dialog.
.PP
Note that this will only change the listing behavior for the
selected item.  You can make this change for all items you create
from now on by using the \fIDefault Listings\fR entry in the
Options menu.
.IP " Properties ..."
Edit various item properties, including the calendar to which the
item belongs, highlighting information, early warning options, alarm
times, and starting and ending times for appointments.  You can
also double-click on an item to pop up the property editing dialog.
.RE
.SS Repeat Menu
.RS
.IP " Don't Repeat"
Make the selected item a non-repeating item.
.IP " Daily"
Make the item repeat every day.
.IP " Weekly"
Make the item repeat once every week.
.IP " Monthly"
Make the item repeat once every month.
.IP " Annually"
Make the item repeat once every year.
.IP " Edit Weekly"
Make the item repeat on a weekly basis in a complicated fashion.  For
example, on Tuesday and Thursday every week.
.IP " Edit Monthly"
Make the item repeat on a monthly basis in a complicated fashion.
For example, on the third Sunday in June, or the last working day
of each month.
.IP " Set Range..."
Restrict the range for a repeating item.
.IP " Last Occurrence"
Make the current occurrence the last occurrence of the selected item.
I.e., remove any occurrences after the current date.
.IP " Make Unique"
If you want to modify just a single occurrence of a repeating
item, select the item occurrence you want to modify and then
activate this menu entry.  Now all modifications to this item
occurrence will only affect this particular occurrence.
.RE
.SS List Menu
.RS
.IP " One Day"
List the item occurrences for one day.
.IP " Seven Days"
List the item occurrences for the next seven days.
.IP " Ten Days"
List the item occurrences for the next ten days.
.IP " Thirty Days"
List the item occurrences for the next thirty days.
.IP " Week"
List the item occurrences for this week.
.IP " Month"
List the item occurrences for this month.
.IP " Year"
List the item occurrences for this year.
.IP " From Calendar ..."
List all item occurrences from a selected calendar.
.RE
.SS Option Menu
.RS
.IP " Appointment Range"
Controls the subset of a day displayed by default in the
appointment listing.  The factory settings display 8:00am to
6:00pm.
.IP " Notice Window Height"
This entry can be used to change the height of the notice window.
.IP " Item Width"
This entry can be used to change the width of displayed appointments
and notices.
.IP " Allow Text Overflow"
If this option is selected, then you can type in any amount of
text into an appointment.  The part of the text that does not fit
into the appointment will be allowed to overflow out of the
appointment.  If you do not like text overflowing out of an
appointment, then you should turn off this option.
.IP " Display Am/Pm"
If this option is selected, time will be printed in twelve hour
mode with \fRam\fR or \fRpm\fR indicators.
Otherwise, time will be printed in twenty-four hour mode.
.IP " Start Week on Monday"
If this option is selected, month displays will start each week off on
a Monday.  Otherwise, each week will start on a Sunday.
.IP " Default Alarms"
Use this menu entry to change the time intervals at which alarms
go off.  The factory settings cause alarms to be triggered
fifteen minutes before each appointment, and then once every five
minutes until the appointment actually starts.  This menu entry
changes the default alarm behavior for all appointments.  You can
override this default behavior on an appointment-by-appointment
basis by selecting an appointment and then selecting the
\fIChange\fR \fIAlarms\fR entry in the \fIitem\fR menu.
.IP " Default Listings"
This menu can be used to select the default listing behavior for
newly created items.  If the \fIOn Occurrence\fR entry is
selected, then a newly created item will only be shown in the
listing of the day on which the item occurs.  If the \fIA Day
Early\fR entry is selected, then a new item will be shown in
listings starting a day before the item occurrence.  Similarly,
the other menu entries can be selected to make new items show up
in listings a number of days before their actual occurrence.
This menu selects the default behavior for new items.  Individual
item behavior can be controlled by similar entries in the
Item menu.
.RE
.SS Help Menu
.RS
.IP " About Ical"
Displays ical version number and author information.
.IP " User Guide"
Displays this document.
.RE
.SH AUTHOR
Sanjay Ghemawat (sanjay@lcs.mit.edu)
http://www.pmg.lcs.mit.edu/~sanjay
.SH COPYRIGHT
Copyright (c) 1993 by Sanjay Ghemawat.  Permission is granted to make
and distribute verbatim copies of this manual provided the copyright
notice and this permission notice are preserved on all copies.
.SH SEE ALSO
Ical http://www.pmg.lcs.mit.edu/~sanjay/ical.html
