/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.X509Name;

public class GeneralName
implements DEREncodable {
    DEREncodable obj;
    int tag;
    boolean isInsideImplicit = false;

    public GeneralName(X509Name directoryName) {
        this.obj = directoryName;
        this.tag = 4;
    }

    public GeneralName(DERObject name, int tag) {
        this.obj = name;
        this.tag = tag;
    }

    public static GeneralName getInstance(Object obj) {
        if (obj == null || obj instanceof GeneralName) {
            return (GeneralName)obj;
        }
        if (obj instanceof ASN1TaggedObject) {
            ASN1TaggedObject tagObj = (ASN1TaggedObject)obj;
            int tag = tagObj.getTagNo();
            switch (tag) {
                case 0: {
                    return new GeneralName(tagObj.getObject(), tag);
                }
                case 1: {
                    return new GeneralName(DERIA5String.getInstance(tagObj, false), tag);
                }
                case 2: {
                    return new GeneralName(DERIA5String.getInstance(tagObj, false), tag);
                }
                case 3: {
                    throw new IllegalArgumentException("unknown tag: " + tag);
                }
                case 4: {
                    return new GeneralName(tagObj.getObject(), tag);
                }
                case 5: {
                    return new GeneralName(tagObj.getObject(), tag);
                }
                case 6: {
                    return new GeneralName(DERIA5String.getInstance(tagObj, false), tag);
                }
                case 7: {
                    return new GeneralName(ASN1OctetString.getInstance(tagObj, false), tag);
                }
                case 8: {
                    return new GeneralName(DERObjectIdentifier.getInstance(tagObj, false), tag);
                }
            }
        }
        throw new IllegalArgumentException("unknown object in getInstance");
    }

    public static GeneralName getInstance(ASN1TaggedObject tagObj, boolean explicit) {
        return GeneralName.getInstance(ASN1TaggedObject.getInstance(tagObj, explicit));
    }

    public void markInsideImplicit(boolean isInsideImplicit) {
        this.isInsideImplicit = isInsideImplicit;
    }

    public int getTagNo() {
        return this.tag;
    }

    public DEREncodable getName() {
        return this.obj;
    }

    public DERObject getDERObject() {
        if (this.tag == 4) {
            return new DERTaggedObject(true, this.tag, this.obj);
        }
        return new DERTaggedObject(false, this.tag, this.obj);
    }
}

