/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.encodings;

import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.params.RSAKeyParameters;

public class ISO9796d1Encoding
implements AsymmetricBlockCipher {
    private static byte[] shadows;
    private static byte[] inverse;
    private AsymmetricBlockCipher engine;
    private boolean forEncryption;
    private int bitSize;
    private int padBits = 0;

    static {
        byte[] byArray = new byte[16];
        byArray[0] = 14;
        byArray[1] = 3;
        byArray[2] = 5;
        byArray[3] = 8;
        byArray[4] = 9;
        byArray[5] = 4;
        byArray[6] = 2;
        byArray[7] = 15;
        byArray[9] = 13;
        byArray[10] = 11;
        byArray[11] = 6;
        byArray[12] = 7;
        byArray[13] = 10;
        byArray[14] = 12;
        byArray[15] = 1;
        shadows = byArray;
        byte[] byArray2 = new byte[16];
        byArray2[0] = 8;
        byArray2[1] = 15;
        byArray2[2] = 6;
        byArray2[3] = 1;
        byArray2[4] = 5;
        byArray2[5] = 2;
        byArray2[6] = 11;
        byArray2[7] = 12;
        byArray2[8] = 3;
        byArray2[9] = 4;
        byArray2[10] = 13;
        byArray2[11] = 10;
        byArray2[12] = 14;
        byArray2[13] = 9;
        byArray2[15] = 7;
        inverse = byArray2;
    }

    public ISO9796d1Encoding(AsymmetricBlockCipher cipher) {
        this.engine = cipher;
    }

    public AsymmetricBlockCipher getUnderlyingCipher() {
        return this.engine;
    }

    public void init(boolean forEncryption, CipherParameters param) {
        RSAKeyParameters kParam = null;
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            kParam = (RSAKeyParameters)rParam.getParameters();
        } else {
            kParam = (RSAKeyParameters)param;
        }
        this.engine.init(forEncryption, kParam);
        this.bitSize = kParam.getModulus().bitLength();
        this.forEncryption = forEncryption;
    }

    public int getInputBlockSize() {
        int baseBlockSize = this.engine.getInputBlockSize();
        if (this.forEncryption) {
            return (baseBlockSize + 1) / 2;
        }
        return baseBlockSize;
    }

    public int getOutputBlockSize() {
        int baseBlockSize = this.engine.getOutputBlockSize();
        if (this.forEncryption) {
            return baseBlockSize;
        }
        return (baseBlockSize + 1) / 2;
    }

    public void setPadBits(int padBits) {
        if (padBits > 7) {
            throw new IllegalArgumentException("padBits > 7");
        }
        this.padBits = padBits;
    }

    public int getPadBits() {
        return this.padBits;
    }

    public byte[] processBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        if (this.forEncryption) {
            return this.encodeBlock(in, inOff, inLen);
        }
        return this.decodeBlock(in, inOff, inLen);
    }

    private byte[] encodeBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        byte[] block = new byte[(this.bitSize + 7) / 8];
        int r = this.padBits + 1;
        int z = inLen;
        int t = (this.bitSize + 13) / 16;
        int i = 0;
        while (i < t) {
            if (i > t - z) {
                System.arraycopy(in, inOff + inLen - (t - i), block, block.length - t, t - i);
            } else {
                System.arraycopy(in, inOff, block, block.length - (i + z), z);
            }
            i += z;
        }
        i = block.length - 2 * t;
        while (i != block.length) {
            byte val = block[block.length - t + i / 2];
            block[i] = (byte)(shadows[(val & 0xFF) >>> 4] << 4 | shadows[val & 0xF]);
            block[i + 1] = val;
            i += 2;
        }
        int n = block.length - 2 * z;
        block[n] = (byte)(block[n] ^ r);
        block[block.length - 1] = (byte)(block[block.length - 1] << 4 | 6);
        int maxBit = 8 - (this.bitSize - 1) % 8;
        int offSet = 0;
        if (maxBit != 8) {
            block[0] = (byte)(block[0] & 255 >>> maxBit);
            block[0] = (byte)(block[0] | 128 >>> maxBit);
        } else {
            block[0] = 0;
            block[1] = (byte)(block[1] | 0x80);
            offSet = 1;
        }
        return this.engine.processBlock(block, offSet, block.length - offSet);
    }

    private byte[] decodeBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        byte[] block = this.engine.processBlock(in, inOff, inLen);
        int r = 1;
        int t = (this.bitSize + 13) / 16;
        if ((block[block.length - 1] & 0xF) != 6) {
            throw new InvalidCipherTextException("invalid forcing byte in block");
        }
        block[block.length - 1] = (byte)((block[block.length - 1] & 0xFF) >>> 4 | inverse[(block[block.length - 2] & 0xFF) >> 4] << 4);
        block[0] = (byte)(shadows[(block[1] & 0xFF) >>> 4] << 4 | shadows[block[1] & 0xF]);
        boolean boundaryFound = false;
        int boundary = 0;
        int i = block.length - 1;
        while (i >= block.length - 2 * t) {
            int val = shadows[(block[i] & 0xFF) >>> 4] << 4 | shadows[block[i] & 0xF];
            if (((block[i - 1] ^ val) & 0xFF) != 0) {
                if (!boundaryFound) {
                    boundaryFound = true;
                    r = (block[i - 1] ^ val) & 0xFF;
                    boundary = i - 1;
                } else {
                    throw new InvalidCipherTextException("invalid tsums in block");
                }
            }
            i -= 2;
        }
        block[boundary] = 0;
        byte[] nblock = new byte[(block.length - boundary) / 2];
        int i2 = 0;
        while (i2 < nblock.length) {
            nblock[i2] = block[2 * i2 + boundary + 1];
            ++i2;
        }
        this.padBits = r - 1;
        return nblock;
    }
}

