/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.encodings;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ParametersWithRandom;

public class PKCS1Encoding
implements AsymmetricBlockCipher {
    private static int HEADER_LENGTH = 10;
    private SecureRandom random;
    private AsymmetricBlockCipher engine;
    private boolean forEncryption;
    private boolean forPrivateKey;

    public PKCS1Encoding(AsymmetricBlockCipher cipher) {
        this.engine = cipher;
    }

    public AsymmetricBlockCipher getUnderlyingCipher() {
        return this.engine;
    }

    public void init(boolean forEncryption, CipherParameters param) {
        AsymmetricKeyParameter kParam;
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            this.random = rParam.getRandom();
            kParam = (AsymmetricKeyParameter)rParam.getParameters();
        } else {
            this.random = new SecureRandom();
            kParam = (AsymmetricKeyParameter)param;
        }
        this.engine.init(forEncryption, kParam);
        this.forPrivateKey = kParam.isPrivate();
        this.forEncryption = forEncryption;
    }

    public int getInputBlockSize() {
        int baseBlockSize = this.engine.getInputBlockSize();
        if (this.forEncryption) {
            return baseBlockSize - HEADER_LENGTH;
        }
        return baseBlockSize;
    }

    public int getOutputBlockSize() {
        int baseBlockSize = this.engine.getOutputBlockSize();
        if (this.forEncryption) {
            return baseBlockSize;
        }
        return baseBlockSize - HEADER_LENGTH;
    }

    public byte[] processBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        if (this.forEncryption) {
            return this.encodeBlock(in, inOff, inLen);
        }
        return this.decodeBlock(in, inOff, inLen);
    }

    /*
     * Unable to fully structure code
     */
    private byte[] encodeBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        block4: {
            block3: {
                block = new byte[this.engine.getInputBlockSize()];
                if (!this.forPrivateKey) break block3;
                block[0] = 1;
                i = 1;
                while (i != block.length - inLen - 1) {
                    block[i] = -1;
                    ++i;
                }
                break block4;
            }
            this.random.nextBytes(block);
            block[0] = 2;
            i = 1;
            ** GOTO lbl19
            {
                block[i] = (byte)this.random.nextInt();
                do {
                    if (block[i] == 0) continue block1;
                    ++i;
lbl19:
                    // 2 sources

                } while (i != block.length - inLen - 1);
            }
        }
        block[block.length - inLen - 1] = 0;
        System.arraycopy(in, inOff, block, block.length - inLen, inLen);
        return this.engine.processBlock(block, 0, block.length);
    }

    private byte[] decodeBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        byte[] block = this.engine.processBlock(in, inOff, inLen);
        if (block.length < this.getOutputBlockSize()) {
            throw new InvalidCipherTextException("block truncated");
        }
        if (block[0] != 1 && block[0] != 2) {
            throw new InvalidCipherTextException("unknown block type");
        }
        int start = 1;
        while (start != block.length) {
            if (block[start] == 0) break;
            ++start;
        }
        if (++start >= block.length || start < HEADER_LENGTH) {
            throw new InvalidCipherTextException("no data in block");
        }
        byte[] result = new byte[block.length - start];
        System.arraycopy(block, start, result, 0, result.length);
        return result;
    }
}

