/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk;

import org.gudy.azureus2.core3.disk.DiskManagerCheckRequestListener;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerListener;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequestListener;
import org.gudy.azureus2.core3.disk.DiskManagerWriteRequestListener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public interface DiskManager {
    public static final int INITIALIZING = 1;
    public static final int ALLOCATING = 2;
    public static final int CHECKING = 3;
    public static final int READY = 4;
    public static final int FAULTY = 10;
    public static final int BLOCK_SIZE = 16384;

    public void start();

    public void stop();

    public boolean filesExist();

    public DirectByteBuffer readBlock(int var1, int var2, int var3);

    public void enqueueWriteRequest(int var1, int var2, DirectByteBuffer var3, Object var4, DiskManagerWriteRequestListener var5);

    public DiskManagerReadRequest createReadRequest(int var1, int var2, int var3);

    public void enqueueReadRequest(DiskManagerReadRequest var1, DiskManagerReadRequestListener var2);

    public void enqueueCheckRequest(int var1, DiskManagerCheckRequestListener var2, Object var3);

    public void enqueueCompleteRecheckRequest(DiskManagerCheckRequestListener var1, Object var2);

    public void dumpResumeDataToDisk(boolean var1, boolean var2) throws Exception;

    public void computePriorityIndicator();

    public DiskManagerPiece[] getPieces();

    public int getPieceNumberToDownload(boolean[] var1);

    public int getNumberOfPieces();

    public DiskManagerFileInfo[] getFiles();

    public int getState();

    public long getTotalLength();

    public int getPieceLength();

    public int getLastPieceLength();

    public long getRemaining();

    public int getPercentDone();

    public String getErrorMessage();

    public void downloadEnded();

    public boolean isChecking();

    public boolean checkBlockConsistency(int var1, int var2, DirectByteBuffer var3);

    public boolean checkBlockConsistency(int var1, int var2, int var3);

    public void addListener(DiskManagerListener var1);

    public void removeListener(DiskManagerListener var1);

    public void storeFilePriorities();

    public DownloadManager getDownloadManager();
}

