/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl;

import java.util.List;
import org.gudy.azureus2.core3.disk.impl.PieceMapEntry;

public class PieceList {
    private final PieceMapEntry[] pieces;
    private final int[] cumulativeLengths;

    public static PieceList convert(List pieceList) {
        return new PieceList(pieceList.toArray(new PieceMapEntry[pieceList.size()]));
    }

    protected PieceList(PieceMapEntry[] _pieces) {
        this.pieces = _pieces;
        this.cumulativeLengths = new int[this.pieces.length];
        this.initializeCumulativeLengths();
    }

    private void initializeCumulativeLengths() {
        int runningLength = 0;
        int i = 0;
        while (i < this.pieces.length) {
            this.cumulativeLengths[i] = runningLength += this.pieces[i].getLength();
            ++i;
        }
    }

    public int size() {
        return this.pieces.length;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public PieceMapEntry get(int index) {
        return this.pieces[index];
    }

    public int getCumulativeLengthToPiece(int index) {
        return this.cumulativeLengths[index];
    }
}

