/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerStats;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.util.TimeFormatter;

public class DisplayFormatters {
    public static final int UNIT_B = 0;
    public static final int UNIT_KB = 1;
    public static final int UNIT_MB = 2;
    public static final int UNIT_GB = 3;
    public static final int UNIT_TB = 4;
    protected static final int[] UNITS_PRECISION;
    protected static String[] units;
    protected static String[] units_rate;
    protected static int unitsStopAt;
    protected static boolean use_si_units;
    protected static boolean use_units_rate_bits;
    protected static boolean not_use_GB_TB;

    static {
        int[] nArray = new int[5];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 2;
        nArray[4] = 3;
        UNITS_PRECISION = nArray;
        unitsStopAt = 4;
        use_si_units = COConfigurationManager.getBooleanParameter("config.style.useSIUnits", false);
        COConfigurationManager.addParameterListener("config.style.useSIUnits", new ParameterListener(){

            public void parameterChanged(String value) {
                use_si_units = COConfigurationManager.getBooleanParameter("config.style.useSIUnits", false);
                DisplayFormatters.setUnits();
            }
        });
        use_units_rate_bits = COConfigurationManager.getBooleanParameter("config.style.useUnitsRateBits", false);
        COConfigurationManager.addParameterListener("config.style.useUnitsRateBits", new ParameterListener(){

            public void parameterChanged(String value) {
                use_units_rate_bits = COConfigurationManager.getBooleanParameter("config.style.useUnitsRateBits", false);
                DisplayFormatters.setUnits();
            }
        });
        not_use_GB_TB = COConfigurationManager.getBooleanParameter("config.style.doNotUseGB", false);
        unitsStopAt = not_use_GB_TB ? 2 : 4;
        COConfigurationManager.addParameterListener("config.style.doNotUseGB", new ParameterListener(){

            public void parameterChanged(String value) {
                not_use_GB_TB = COConfigurationManager.getBooleanParameter("config.style.doNotUseGB", false);
                unitsStopAt = not_use_GB_TB ? 2 : 4;
                DisplayFormatters.setUnits();
            }
        });
        DisplayFormatters.setUnits();
    }

    protected static void setUnits() {
        units = new String[unitsStopAt + 1];
        units_rate = new String[unitsStopAt + 1];
        if (use_si_units) {
            switch (unitsStopAt) {
                case 4: {
                    DisplayFormatters.units[4] = " TiB";
                    DisplayFormatters.units_rate[4] = use_units_rate_bits ? " Tibit" : " TiB";
                }
                case 3: {
                    DisplayFormatters.units[3] = " GiB";
                    DisplayFormatters.units_rate[3] = use_units_rate_bits ? " Gibit" : " GiB";
                }
                case 2: {
                    DisplayFormatters.units[2] = " MiB";
                    DisplayFormatters.units_rate[2] = use_units_rate_bits ? " Mibit" : " MiB";
                }
                case 1: {
                    DisplayFormatters.units[1] = " KiB";
                    DisplayFormatters.units_rate[1] = use_units_rate_bits ? " Kibit" : " KiB";
                }
                case 0: {
                    DisplayFormatters.units[0] = " B";
                    DisplayFormatters.units_rate[0] = use_units_rate_bits ? " bit" : " B";
                }
            }
        } else {
            switch (unitsStopAt) {
                case 4: {
                    DisplayFormatters.units[4] = " TB";
                    DisplayFormatters.units_rate[4] = use_units_rate_bits ? " Tbit" : " TB";
                }
                case 3: {
                    DisplayFormatters.units[3] = " GB";
                    DisplayFormatters.units_rate[3] = use_units_rate_bits ? " Gbit" : " GB";
                }
                case 2: {
                    DisplayFormatters.units[2] = " MB";
                    DisplayFormatters.units_rate[2] = use_units_rate_bits ? " Mbit" : " MB";
                }
                case 1: {
                    DisplayFormatters.units[1] = " kB";
                    DisplayFormatters.units_rate[1] = use_units_rate_bits ? " kbit" : " kB";
                }
                case 0: {
                    DisplayFormatters.units[0] = " B";
                    DisplayFormatters.units_rate[0] = use_units_rate_bits ? " bit" : " B";
                }
            }
        }
        int i = 0;
        while (i <= unitsStopAt) {
            DisplayFormatters.units[i] = units[i];
            DisplayFormatters.units_rate[i] = String.valueOf(units_rate[i]) + "/s";
            ++i;
        }
        NumberFormat.getPercentInstance().setMinimumFractionDigits(1);
        NumberFormat.getPercentInstance().setMaximumFractionDigits(1);
    }

    public static String getRateUnit(int unit_size) {
        return units_rate[unit_size].substring(1, units_rate[unit_size].length());
    }

    public static String getUnit(int unit_size) {
        return units[unit_size].substring(1, units[unit_size].length());
    }

    public static String formatByteCountToKiBEtc(int n) {
        return DisplayFormatters.formatByteCountToKiBEtc((long)n);
    }

    public static String formatByteCountToKiBEtc(long n) {
        return DisplayFormatters.formatByteCountToKiBEtc(n, false);
    }

    protected static String formatByteCountToKiBEtc(long n, boolean rate) {
        double dbl = rate && use_units_rate_bits ? n * 8L : n;
        int unitIndex = 0;
        while (dbl >= 1024.0 && unitIndex < unitsStopAt) {
            dbl /= 1024.0;
            ++unitIndex;
        }
        return String.valueOf(DisplayFormatters.formatDecimal(dbl, UNITS_PRECISION[unitIndex])) + (rate ? units_rate[unitIndex] : units[unitIndex]);
    }

    public static String formatByteCountToKiBEtcPerSec(long n) {
        return DisplayFormatters.formatByteCountToKiBEtc(n, true);
    }

    public static String formatByteCountToBase10KBEtc(long n) {
        if (n < 1000L) {
            return String.valueOf(n).concat(" B");
        }
        if (n < 1000000L) {
            return String.valueOf(n / 1000L).concat(".").concat(String.valueOf(n % 1000L / 100L)).concat(" KB");
        }
        if (n < 1000000000L || not_use_GB_TB) {
            return String.valueOf(n / 1000000L).concat(".").concat(String.valueOf(n % 1000000L / 100000L)).concat(" MB");
        }
        if (n < 1000000000000L) {
            return String.valueOf(n / 1000000000L).concat(".").concat(String.valueOf(n % 1000000000L / 100000000L)).concat(" GB");
        }
        if (n < 1000000000000000L) {
            return String.valueOf(n / 1000000000000L).concat(".").concat(String.valueOf(n % 1000000000000L / 100000000000L)).concat(" TB");
        }
        return "A lot !!!";
    }

    public static String formatByteCountToBase10KBEtcPerSec(long n) {
        return DisplayFormatters.formatByteCountToBase10KBEtc(n).concat("/s");
    }

    public static String formatETA(long eta) {
        if (eta == 0L) {
            return MessageText.getString("PeerManager.status.finished");
        }
        if (eta == -1L) {
            return "";
        }
        if (eta > 0L) {
            return TimeFormatter.format(eta);
        }
        return MessageText.getString("PeerManager.status.finishedin").concat(" ").concat(TimeFormatter.format(eta * -1L));
    }

    public static String formatDownloaded(DownloadManagerStats stats) {
        long total_discarded = stats.getDiscarded();
        long total_received = stats.getDownloaded();
        if (total_discarded == 0L) {
            return DisplayFormatters.formatByteCountToKiBEtc(total_received);
        }
        return DisplayFormatters.formatByteCountToKiBEtc(total_received).concat(" ( ").concat(DisplayFormatters.formatByteCountToKiBEtc(total_discarded)).concat(" ").concat(MessageText.getString("discarded")).concat(" )");
    }

    public static String formatHashFails(DownloadManager download_manager) {
        PEPeerManager pm = download_manager.getPeerManager();
        DiskManager dm = download_manager.getDiskManager();
        if (pm != null) {
            long nbFails = pm.getNbHashFails();
            long size = nbFails * (long)dm.getPieceLength();
            String result = String.valueOf(nbFails).concat(" ( ~ ").concat(DisplayFormatters.formatByteCountToKiBEtc(size)).concat(" )");
            return result;
        }
        return "";
    }

    public static String formatDownloadStatus(DownloadManager manager) {
        int state = manager.getState();
        String tmp = "";
        switch (state) {
            case 0: {
                tmp = MessageText.getString("ManagerItem.waiting");
                break;
            }
            case 5: {
                tmp = MessageText.getString("ManagerItem.initializing");
                break;
            }
            case 10: {
                tmp = MessageText.getString("ManagerItem.initializing");
                break;
            }
            case 20: {
                tmp = MessageText.getString("ManagerItem.allocating");
                break;
            }
            case 30: {
                tmp = MessageText.getString("ManagerItem.checking");
                break;
            }
            case 55: {
                tmp = MessageText.getString("ManagerItem.finishing");
                break;
            }
            case 40: {
                tmp = MessageText.getString("ManagerItem.ready");
                break;
            }
            case 50: {
                tmp = MessageText.getString("ManagerItem.downloading");
                break;
            }
            case 60: {
                DiskManager diskManager = manager.getDiskManager();
                if (diskManager != null && diskManager.isChecking()) {
                    tmp = MessageText.getString("ManagerItem.seeding").concat(" + ").concat(MessageText.getString("ManagerItem.checking"));
                    break;
                }
                if (manager.getPeerManager() != null && manager.getPeerManager().isSuperSeedMode()) {
                    tmp = MessageText.getString("ManagerItem.superseeding");
                    break;
                }
                tmp = MessageText.getString("ManagerItem.seeding");
                break;
            }
            case 65: {
                tmp = MessageText.getString("ManagerItem.stopping");
                break;
            }
            case 70: {
                tmp = MessageText.getString("ManagerItem.stopped");
                break;
            }
            case 75: {
                tmp = MessageText.getString("ManagerItem.queued");
                break;
            }
            case 100: {
                tmp = MessageText.getString("ManagerItem.error").concat(": ").concat(manager.getErrorDetails());
                break;
            }
            default: {
                tmp = String.valueOf(state);
            }
        }
        if (manager.isForceStart() && (state == 60 || state == 50)) {
            tmp = String.valueOf(MessageText.getString("ManagerItem.forced")) + " " + tmp;
        }
        return tmp;
    }

    public static String formatDownloadStatusDefaultLocale(DownloadManager manager) {
        int state = manager.getState();
        String tmp = "";
        switch (state) {
            case 0: {
                tmp = MessageText.getDefaultLocaleString("ManagerItem.waiting");
                break;
            }
            case 5: {
                tmp = MessageText.getDefaultLocaleString("ManagerItem.initializing");
                break;
            }
            case 10: {
                tmp = MessageText.getDefaultLocaleString("ManagerItem.initializing");
                break;
            }
            case 20: {
                tmp = MessageText.getDefaultLocaleString("ManagerItem.allocating");
                break;
            }
            case 30: {
                tmp = MessageText.getDefaultLocaleString("ManagerItem.checking");
                break;
            }
            case 55: {
                tmp = MessageText.getDefaultLocaleString("ManagerItem.finishing");
                break;
            }
            case 40: {
                tmp = MessageText.getDefaultLocaleString("ManagerItem.ready");
                break;
            }
            case 50: {
                tmp = MessageText.getDefaultLocaleString("ManagerItem.downloading");
                break;
            }
            case 60: {
                if (manager.getDiskManager().isChecking()) {
                    tmp = MessageText.getDefaultLocaleString("ManagerItem.seeding").concat(" + ").concat(MessageText.getDefaultLocaleString("ManagerItem.checking"));
                    break;
                }
                if (manager.getPeerManager() != null && manager.getPeerManager().isSuperSeedMode()) {
                    tmp = MessageText.getDefaultLocaleString("ManagerItem.superseeding");
                    break;
                }
                tmp = MessageText.getDefaultLocaleString("ManagerItem.seeding");
                break;
            }
            case 65: {
                tmp = MessageText.getDefaultLocaleString("ManagerItem.stopping");
                break;
            }
            case 70: {
                tmp = MessageText.getDefaultLocaleString("ManagerItem.stopped");
                break;
            }
            case 75: {
                tmp = MessageText.getDefaultLocaleString("ManagerItem.queued");
                break;
            }
            case 100: {
                tmp = MessageText.getDefaultLocaleString("ManagerItem.error").concat(": ").concat(manager.getErrorDetails());
                break;
            }
            default: {
                tmp = String.valueOf(state);
            }
        }
        return tmp;
    }

    public static String formatPercentFromThousands(int thousands) {
        NumberFormat nf = NumberFormat.getPercentInstance();
        nf.setMinimumFractionDigits(1);
        nf.setMaximumFractionDigits(1);
        return nf.format((double)thousands / 1000.0);
    }

    public static String formatTimeStamp(long time) {
        StringBuffer sb = new StringBuffer();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        sb.append('[');
        sb.append(DisplayFormatters.formatIntToTwoDigits(calendar.get(5)));
        sb.append('.');
        sb.append(DisplayFormatters.formatIntToTwoDigits(calendar.get(2) + 1));
        sb.append('.');
        sb.append(calendar.get(1));
        sb.append(' ');
        sb.append(DisplayFormatters.formatIntToTwoDigits(calendar.get(11)));
        sb.append(':');
        sb.append(DisplayFormatters.formatIntToTwoDigits(calendar.get(12)));
        sb.append(':');
        sb.append(DisplayFormatters.formatIntToTwoDigits(calendar.get(13)));
        sb.append(']');
        return sb.toString();
    }

    public static String formatIntToTwoDigits(int n) {
        return n < 10 ? "0".concat(String.valueOf(n)) : String.valueOf(n);
    }

    public static String formatDate(long date) {
        if (date == 0L) {
            return "";
        }
        SimpleDateFormat temp = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
        return temp.format(new Date(date));
    }

    public static String formatDateShort(long date) {
        if (date == 0L) {
            return "";
        }
        SimpleDateFormat temp = new SimpleDateFormat("MMM dd, HH:mm");
        return temp.format(new Date(date));
    }

    public static String formatTime(long time) {
        if (time == 0L) {
            return "";
        }
        SimpleDateFormat temp = new SimpleDateFormat("HH:mm:ss");
        return temp.format(new Date(time));
    }

    public static String formatDecimal(double value, int precision) {
        String res = String.valueOf(value);
        int pos = res.indexOf(46);
        if (pos == -1) {
            if (precision != 0) {
                res = String.valueOf(res) + ".";
                int i = 0;
                while (i < precision) {
                    res = String.valueOf(res) + '0';
                    ++i;
                }
            }
        } else if (precision == 0) {
            res = res.substring(0, pos);
        } else {
            int digits = res.length() - pos - 1;
            if (digits < precision) {
                int i = 0;
                while (i < precision - digits) {
                    res = String.valueOf(res) + '0';
                    ++i;
                }
            } else if (digits > precision) {
                res = res.substring(0, pos + 1 + precision);
            }
        }
        return res;
    }
}

