/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.platform;

import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerException;
import org.gudy.azureus2.platform.win32.PlatformManagerImpl;

public class PlatformManagerFactory {
    protected static boolean init_tried;
    protected static PlatformManager platform_manager;
    protected static AEMonitor class_mon;

    static {
        class_mon = new AEMonitor("PlatformManagerFactory");
    }

    public static PlatformManager getPlatformManager() throws PlatformManagerException {
        try {
            class_mon.enter();
            if (platform_manager == null && !init_tried) {
                init_tried = true;
                if (PlatformManagerFactory.getPlatformType() == 1) {
                    platform_manager = PlatformManagerImpl.getSingleton();
                }
            }
            PlatformManager platformManager = platform_manager;
            class_mon.exit();
            return platformManager;
        }
        catch (Throwable throwable) {
            class_mon.exit();
            throw throwable;
        }
    }

    public static int getPlatformType() {
        if (Constants.isWindows) {
            return 1;
        }
        return 2;
    }
}

