/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.mainwindow;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.mainwindow.HSLColor;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;

public class Colors
implements ParameterListener {
    private static Colors instance = null;
    public static final int BLUES_LIGHTEST = 0;
    public static final int BLUES_DARKEST = 9;
    public static final int BLUES_MIDLIGHT = 2;
    public static final int BLUES_MIDDARK = 7;
    public static final int FADED_LIGHTEST = 0;
    public static final int FADED_DARKEST = 9;
    public static Color[] blues = new Color[10];
    public static Color[] faded = new Color[10];
    public static Color colorProgressBar;
    public static Color colorInverse;
    public static Color colorShiftLeft;
    public static Color colorShiftRight;
    public static Color colorError;
    public static Color colorAltRow;
    public static Color colorWarning;
    public static Color black;
    public static Color blue;
    public static Color grey;
    public static Color red;
    public static Color white;
    public static Color background;
    public static Color red_ConsoleView;
    private static AEMonitor class_mon;
    private Display display;

    static {
        class_mon = new AEMonitor("Colors");
    }

    private void allocateBlues() {
        int r = 0;
        int g = 128;
        int b = 255;
        try {
            r = COConfigurationManager.getIntParameter("Color Scheme.red", r);
            g = COConfigurationManager.getIntParameter("Color Scheme.green", g);
            b = COConfigurationManager.getIntParameter("Color Scheme.blue", b);
            HSLColor hslColor = new HSLColor();
            Color colorTables = this.display.getSystemColor(25);
            int tR = colorTables.getRed();
            int tG = colorTables.getGreen();
            int tB = colorTables.getBlue();
            int i = 0;
            while (i < blues.length) {
                Color toBeDisposed = blues[i];
                hslColor.initHSLbyRGB(r, g, b);
                float blendBy = i == 0 ? 1.0f : 1.0f - (float)i / (float)(blues.length - 1);
                hslColor.blend(tR, tG, tB, blendBy);
                Colors.blues[i] = new Color((Device)this.display, hslColor.getRed(), hslColor.getGreen(), hslColor.getBlue());
                int iSat = hslColor.getSaturation();
                if (iSat != 0) {
                    hslColor.setSaturation(iSat / 2);
                }
                Colors.faded[i] = new Color((Device)this.display, hslColor.getRed(), hslColor.getGreen(), hslColor.getBlue());
                if (toBeDisposed != null && !toBeDisposed.isDisposed()) {
                    toBeDisposed.dispose();
                }
                ++i;
            }
            Color toBeDisposed = colorInverse;
            hslColor.initHSLbyRGB(r, g, b);
            hslColor.reverseColor();
            colorInverse = new Color((Device)this.display, hslColor.getRed(), hslColor.getGreen(), hslColor.getBlue());
            if (toBeDisposed != null && !toBeDisposed.isDisposed()) {
                toBeDisposed.dispose();
            }
            toBeDisposed = colorShiftRight;
            hslColor.initHSLbyRGB(r, g, b);
            hslColor.setHue(hslColor.getHue() + 20);
            colorShiftRight = new Color((Device)this.display, hslColor.getRed(), hslColor.getGreen(), hslColor.getBlue());
            if (toBeDisposed != null && !toBeDisposed.isDisposed()) {
                toBeDisposed.dispose();
            }
            toBeDisposed = colorShiftLeft;
            hslColor.initHSLbyRGB(r, g, b);
            hslColor.setHue(hslColor.getHue() - 20);
            colorShiftLeft = new Color((Device)this.display, hslColor.getRed(), hslColor.getGreen(), hslColor.getBlue());
            if (toBeDisposed != null && !toBeDisposed.isDisposed()) {
                toBeDisposed.dispose();
            }
        }
        catch (Exception e) {
            LGLogger.log(3, "Error allocating colors");
            Debug.printStackTrace(e);
        }
    }

    public void disposeColors() {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        this.display.syncExec((Runnable)new AERunnable(){

            public void runSupport() {
                if (colorProgressBar != null && !colorProgressBar.isDisposed()) {
                    colorProgressBar.dispose();
                }
                int i = 0;
                while (i < blues.length) {
                    if (blues[i] != null && !blues[i].isDisposed()) {
                        blues[i].dispose();
                    }
                    ++i;
                }
                Color[] colorsToDispose = new Color[]{colorInverse, colorShiftLeft, colorShiftRight, colorError, grey, black, blue, red, white, red_ConsoleView, colorAltRow, colorWarning};
                int i2 = 0;
                while (i2 < colorsToDispose.length) {
                    if (colorsToDispose[i2] != null && !colorsToDispose[i2].isDisposed()) {
                        colorsToDispose[i2].dispose();
                    }
                    ++i2;
                }
            }
        });
    }

    public void setBackground(Color background) {
        if (Colors.background != null && !Colors.background.isDisposed()) {
            Color old = Colors.background;
            Colors.background = background;
            old.dispose();
        }
    }

    private void allocateColorProgressBar() {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        this.display.syncExec((Runnable)new AERunnable(){

            public void runSupport() {
                colorProgressBar = new AllocateColor("progressBar", colorShiftRight.getRGB(), colorProgressBar).getColor();
            }
        });
    }

    private void allocateColorError() {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        this.display.syncExec((Runnable)new AERunnable(){

            public void runSupport() {
                colorError = new AllocateColor("error", new RGB(255, 68, 68), colorError).getColor();
            }
        });
    }

    private void allocateColorWarning() {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        this.display.syncExec((Runnable)new AERunnable(){

            public void runSupport() {
                Color colorTables = Colors.this.display.getSystemColor(25);
                HSLColor hslBG = new HSLColor();
                hslBG.initHSLbyRGB(colorTables.getRed(), colorTables.getGreen(), colorTables.getBlue());
                int lum = hslBG.getLuminence();
                HSLColor hslColor = new HSLColor();
                hslColor.initRGBbyHSL(25, 200, lum > 127 ? lum - 128 : lum + 92);
                colorWarning = new AllocateColor("warning", new RGB(hslColor.getRed(), hslColor.getGreen(), hslColor.getBlue()), colorWarning).getColor();
            }
        });
    }

    private void allocateColorAltRow() {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        this.display.syncExec((Runnable)new AERunnable(){

            public void runSupport() {
                Color colorTables = Colors.this.display.getSystemColor(25);
                HSLColor hslColor = new HSLColor();
                hslColor.initHSLbyRGB(colorTables.getRed(), colorTables.getGreen(), colorTables.getBlue());
                int lum = hslColor.getLuminence();
                lum = lum > 127 ? (lum -= 10) : (lum += 30);
                hslColor.setLuminence(lum);
                colorAltRow = new AllocateColor("altRow", new RGB(hslColor.getRed(), hslColor.getGreen(), hslColor.getBlue()), colorAltRow).getColor();
            }
        });
    }

    private void allocateDynamicColors() {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        this.display.syncExec((Runnable)new AERunnable(){

            public void runSupport() {
                Colors.this.allocateBlues();
                Colors.this.allocateColorProgressBar();
            }
        });
    }

    private void allocateNonDynamicColors() {
        this.allocateColorWarning();
        this.allocateColorError();
        this.allocateColorAltRow();
        black = new Color((Device)this.display, new RGB(0, 0, 0));
        blue = new Color((Device)this.display, new RGB(0, 0, 170));
        grey = new Color((Device)this.display, new RGB(170, 170, 170));
        red = new Color((Device)this.display, new RGB(255, 0, 0));
        white = new Color((Device)this.display, new RGB(255, 255, 255));
        background = new Color((Device)this.display, new RGB(248, 248, 248));
        red_ConsoleView = new Color((Device)this.display, new RGB(255, 192, 192));
    }

    public Colors() {
        instance = this;
        this.display = SWTThread.getInstance().getDisplay();
        this.allocateDynamicColors();
        this.allocateNonDynamicColors();
        this.addColorsChangedListener(this);
    }

    public static Colors getInstance() {
        try {
            class_mon.enter();
            if (instance == null) {
                instance = new Colors();
            }
            Colors colors = instance;
            class_mon.exit();
            return colors;
        }
        catch (Throwable throwable) {
            class_mon.exit();
            throw throwable;
        }
    }

    public void addColorsChangedListener(ParameterListener l) {
        COConfigurationManager.addParameterListener("Color Scheme", l);
        COConfigurationManager.addParameterListener("Colors.progressBar.override", l);
        COConfigurationManager.addParameterListener("Colors.progressBar", l);
        COConfigurationManager.addParameterListener("Colors.error.override", l);
        COConfigurationManager.addParameterListener("Colors.error", l);
        COConfigurationManager.addParameterListener("Colors.warning.override", l);
        COConfigurationManager.addParameterListener("Colors.warning", l);
        COConfigurationManager.addParameterListener("Colors.altRow.override", l);
        COConfigurationManager.addParameterListener("Colors.altRow", l);
    }

    public void removeColorsChangedListener(ParameterListener l) {
        COConfigurationManager.removeParameterListener("Color Scheme", l);
        COConfigurationManager.removeParameterListener("Colors.progressBar.override", l);
        COConfigurationManager.removeParameterListener("Colors.progressBar", l);
        COConfigurationManager.removeParameterListener("Colors.error.override", l);
        COConfigurationManager.removeParameterListener("Colors.error", l);
        COConfigurationManager.removeParameterListener("Colors.warning.override", l);
        COConfigurationManager.removeParameterListener("Colors.warning", l);
        COConfigurationManager.removeParameterListener("Colors.altRow.override", l);
        COConfigurationManager.removeParameterListener("Colors.altRow", l);
    }

    public void parameterChanged(String parameterName) {
        if (parameterName.equals("Color Scheme")) {
            this.allocateDynamicColors();
        }
        if (parameterName.startsWith("Colors.progressBar")) {
            this.allocateColorProgressBar();
        }
        if (parameterName.startsWith("Colors.error")) {
            this.allocateColorError();
        }
        if (parameterName.startsWith("Colors.warning")) {
            this.allocateColorWarning();
        }
        if (parameterName.startsWith("Colors.altRow")) {
            this.allocateColorAltRow();
        }
    }

    private class AllocateColor
    extends AERunnable {
        private Color toBeDeleted = null;
        private String sName;
        private RGB rgbDefault;
        private Color newColor;

        public AllocateColor(String sName, RGB rgbDefault, Color colorOld) {
            this.toBeDeleted = colorOld;
            this.sName = sName;
            this.rgbDefault = rgbDefault;
        }

        public Color getColor() {
            Colors.this.display.syncExec((Runnable)this);
            return this.newColor;
        }

        public void runSupport() {
            if (COConfigurationManager.getBooleanParameter("Colors." + this.sName + ".override")) {
                this.newColor = new Color((Device)Colors.this.display, COConfigurationManager.getIntParameter("Colors." + this.sName + ".red", this.rgbDefault.red), COConfigurationManager.getIntParameter("Colors." + this.sName + ".green", this.rgbDefault.green), COConfigurationManager.getIntParameter("Colors." + this.sName + ".blue", this.rgbDefault.blue));
            } else {
                this.newColor = new Color((Device)Colors.this.display, this.rgbDefault);
                COConfigurationManager.setRGBParameter("Colors." + this.sName, this.rgbDefault.red, this.rgbDefault.green, this.rgbDefault.blue);
            }
            if (this.toBeDeleted != null && !this.toBeDeleted.isDisposed()) {
                this.toBeDeleted.dispose();
            }
        }
    }
}

