/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.mainwindow;

import com.aelitis.azureus.core.AzureusCore;
import java.util.Iterator;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.ipfilter.IpFilter;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.ui.swt.MinimizedWindow;
import org.gudy.azureus2.ui.swt.Tab;
import org.gudy.azureus2.ui.swt.mainwindow.MainWindow;
import org.gudy.azureus2.ui.swt.views.IView;

public class GUIUpdater
extends AEThread
implements ParameterListener {
    private AzureusCore azureus_core;
    private MainWindow mainWindow;
    private Display display;
    boolean finished = false;
    boolean refreshed = true;
    int waitTime = COConfigurationManager.getIntParameter("GUI Refresh");

    public GUIUpdater(AzureusCore _azureus_core, MainWindow mainWindow) {
        super("GUI updater");
        this.azureus_core = _azureus_core;
        this.mainWindow = mainWindow;
        this.display = mainWindow.getDisplay();
        this.setPriority(8);
        COConfigurationManager.addParameterListener("GUI Refresh", this);
    }

    public void runSupport() {
        while (!this.finished) {
            if (this.refreshed) {
                this.update();
            }
            try {
                Thread.sleep(this.waitTime);
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void parameterChanged(String parameterName) {
        this.waitTime = COConfigurationManager.getIntParameter("GUI Refresh");
    }

    private void update() {
        this.refreshed = false;
        if (this.display != null && !this.display.isDisposed()) {
            this.display.asyncExec((Runnable)new AERunnable(){

                public void runSupport() {
                    try {
                        try {
                            IView view = null;
                            if (!GUIUpdater.this.mainWindow.getShell().isDisposed() && GUIUpdater.this.mainWindow.isVisible() && !GUIUpdater.this.mainWindow.getShell().getMinimized()) {
                                view = GUIUpdater.this.mainWindow.getCurrentView();
                                if (view != null) {
                                    view.refresh();
                                    Tab.refresh();
                                }
                                IpFilter ip_filter = GUIUpdater.this.azureus_core.getIpFilterManager().getIPFilter();
                                ((GUIUpdater)GUIUpdater.this).mainWindow.ipBlocked.setText("{" + DisplayFormatters.formatDateShort(ip_filter.getLastUpdateTime()) + "} IPs: " + ip_filter.getNbRanges() + " - " + ip_filter.getNbIpsBlocked() + "/" + ip_filter.getNbBannedIps() + "/" + GUIUpdater.this.azureus_core.getIpFilterManager().getBadIps().getNbBadIps());
                                int ul_limit = COConfigurationManager.getIntParameter("Max Upload Speed KBs");
                                int dl_limit = COConfigurationManager.getIntParameter("Max Download Speed KBs");
                                ((GUIUpdater)GUIUpdater.this).mainWindow.statusDown.setText(String.valueOf(MessageText.getString("ConfigView.download.abbreviated")) + " " + (dl_limit == 0 ? "" : "[" + dl_limit + "K] ") + DisplayFormatters.formatByteCountToKiBEtcPerSec(((GUIUpdater)GUIUpdater.this).mainWindow.globalManager.getStats().getDownloadAverage()));
                                ((GUIUpdater)GUIUpdater.this).mainWindow.statusUp.setText(String.valueOf(MessageText.getString("ConfigView.upload.abbreviated")) + " " + (ul_limit == 0 ? "" : "[" + ul_limit + "K] ") + DisplayFormatters.formatByteCountToKiBEtcPerSec(((GUIUpdater)GUIUpdater.this).mainWindow.globalManager.getStats().getUploadAverage()));
                            }
                            if (((GUIUpdater)GUIUpdater.this).mainWindow.systemTraySWT != null) {
                                ((GUIUpdater)GUIUpdater.this).mainWindow.systemTraySWT.update();
                            }
                            try {
                                ((GUIUpdater)GUIUpdater.this).mainWindow.downloadBars_mon.enter();
                                Iterator iter = ((GUIUpdater)GUIUpdater.this).mainWindow.downloadBars.values().iterator();
                                while (iter.hasNext()) {
                                    MinimizedWindow mw = (MinimizedWindow)iter.next();
                                    mw.refresh();
                                }
                            }
                            finally {
                                ((GUIUpdater)GUIUpdater.this).mainWindow.downloadBars_mon.exit();
                            }
                        }
                        catch (Exception e) {
                            LGLogger.log(3, "Error while trying to update GUI");
                            Debug.printStackTrace(e);
                        }
                    }
                    finally {
                        GUIUpdater.this.refreshed = true;
                    }
                }
            });
        }
    }

    public void stopIt() {
        this.finished = true;
        COConfigurationManager.removeParameterListener("GUI Refresh", this);
        COConfigurationManager.removeParameterListener("config.style.refreshMT", this);
    }
}

