/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.stats;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.stats.transfer.OverallStats;
import org.gudy.azureus2.core3.stats.transfer.StatsFactory;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.BufferedLabel;
import org.gudy.azureus2.ui.swt.views.AbstractIView;

public class TransferStatsView
extends AbstractIView {
    GlobalManager manager;
    GlobalManagerStats stats;
    OverallStats totalStats;
    Composite panel;
    BufferedLabel sessionDown;
    BufferedLabel sessionUp;
    BufferedLabel sessionTime;
    BufferedLabel totalDown;
    BufferedLabel totalUp;
    BufferedLabel totalTime;

    public TransferStatsView(GlobalManager manager) {
        this.manager = manager;
        this.stats = manager.getStats();
        this.totalStats = StatsFactory.getStats();
    }

    public void initialize(Composite composite) {
        this.panel = new Composite(composite, 0);
        GridLayout panelLayout = new GridLayout();
        panelLayout.numColumns = 4;
        panelLayout.makeColumnsEqualWidth = true;
        this.panel.setLayout((Layout)panelLayout);
        Label lbl = new Label(this.panel, 0);
        lbl = new Label(this.panel, 0);
        Messages.setLanguageText((Widget)lbl, "SpeedView.stats.downloaded");
        lbl = new Label(this.panel, 0);
        Messages.setLanguageText((Widget)lbl, "SpeedView.stats.uploaded");
        lbl = new Label(this.panel, 0);
        Messages.setLanguageText((Widget)lbl, "SpeedView.stats.uptime");
        lbl = new Label(this.panel, 0);
        Messages.setLanguageText((Widget)lbl, "SpeedView.stats.session");
        this.sessionDown = new BufferedLabel(this.panel, 0);
        GridData gridData = new GridData(768);
        this.sessionDown.setLayoutData(gridData);
        this.sessionUp = new BufferedLabel(this.panel, 0);
        gridData = new GridData(768);
        this.sessionUp.setLayoutData(gridData);
        this.sessionTime = new BufferedLabel(this.panel, 0);
        gridData = new GridData(768);
        this.sessionTime.setLayoutData(gridData);
        lbl = new Label(this.panel, 0);
        Messages.setLanguageText((Widget)lbl, "SpeedView.stats.total");
        this.totalDown = new BufferedLabel(this.panel, 0);
        gridData = new GridData(768);
        this.totalDown.setLayoutData(gridData);
        this.totalUp = new BufferedLabel(this.panel, 0);
        gridData = new GridData(768);
        this.totalUp.setLayoutData(gridData);
        this.totalTime = new BufferedLabel(this.panel, 0);
        gridData = new GridData(768);
        this.totalTime.setLayoutData(gridData);
    }

    public void delete() {
        Utils.disposeComposite(this.panel);
    }

    public String getFullTitle() {
        return MessageText.getString("SpeedView.title.full");
    }

    public Composite getComposite() {
        return this.panel;
    }

    public void refresh() {
        this.sessionDown.setText(DisplayFormatters.formatByteCountToKiBEtc(this.stats.getTotalReceivedRaw()));
        this.sessionUp.setText(DisplayFormatters.formatByteCountToKiBEtc(this.stats.getTotalSentRaw()));
        this.totalDown.setText(DisplayFormatters.formatByteCountToKiBEtc(this.totalStats.getDownloadedBytes()));
        this.totalUp.setText(DisplayFormatters.formatByteCountToKiBEtc(this.totalStats.getUploadedBytes()));
        this.sessionTime.setText(DisplayFormatters.formatETA(this.totalStats.getSessionUpTime()));
        this.totalTime.setText(DisplayFormatters.formatETA(this.totalStats.getTotalUpTime()));
    }

    public String getData() {
        return "TransferStatsView.title.full";
    }
}

