/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.ImageList;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;

public class TableItem
extends Item {
    Table parent;
    boolean cached;

    public TableItem(Table parent, int style, int index) {
        this(parent, style, index, true);
    }

    public TableItem(Table parent, int style) {
        this(parent, style, TableItem.checkNull(parent).getItemCount(), true);
    }

    TableItem(Table parent, int style, int index, boolean create) {
        super(parent, style);
        this.parent = parent;
        if (create) {
            parent.createItem(this, index);
        } else {
            this.handle = OS.g_malloc((int)OS.GtkTreeIter_sizeof());
            OS.gtk_tree_model_iter_nth_child((int)parent.modelHandle, (int)this.handle, (int)0, (int)index);
        }
    }

    static Table checkNull(Table control) {
        if (control == null) {
            SWT.error(4);
        }
        return control;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void clear() {
        if (this.cached || (this.parent.style & 0x10000000) == 0) {
            int columnCount = OS.gtk_tree_model_get_n_columns((int)this.parent.modelHandle);
            int i = 0;
            while (i < columnCount) {
                OS.gtk_list_store_set((int)this.parent.modelHandle, (int)this.handle, (int)i, (int)0, (int)-1);
                ++i;
            }
        }
        this.cached = false;
    }

    public Color getBackground() {
        this.checkWidget();
        int[] ptr = new int[1];
        OS.gtk_tree_model_get((int)this.parent.modelHandle, (int)this.handle, (int)3, (int[])ptr, (int)-1);
        if (ptr[0] == 0) {
            return this.parent.getBackground();
        }
        GdkColor gdkColor = new GdkColor();
        OS.memmove((GdkColor)gdkColor, (int)ptr[0], (int)GdkColor.sizeof);
        return Color.gtk_new(this.display, gdkColor);
    }

    public Color getBackground(int index) {
        this.checkWidget();
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return this.getBackground();
        }
        int[] ptr = new int[1];
        int modelIndex = this.parent.columnCount == 0 ? 5 : this.parent.columns[index].modelIndex;
        OS.gtk_tree_model_get((int)this.parent.modelHandle, (int)this.handle, (int)(modelIndex + 3), (int[])ptr, (int)-1);
        if (ptr[0] == 0) {
            return this.getBackground();
        }
        GdkColor gdkColor = new GdkColor();
        OS.memmove((GdkColor)gdkColor, (int)ptr[0], (int)GdkColor.sizeof);
        return Color.gtk_new(this.display, gdkColor);
    }

    public Rectangle getBounds(int index) {
        this.checkWidget();
        int parentHandle = this.parent.handle;
        int column = OS.gtk_tree_view_get_column((int)parentHandle, (int)index);
        if (column == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        GdkRectangle rect = new GdkRectangle();
        int path = OS.gtk_tree_model_get_path((int)this.parent.modelHandle, (int)this.handle);
        OS.gtk_widget_realize((int)parentHandle);
        OS.gtk_tree_view_get_cell_area((int)parentHandle, (int)path, (int)column, (GdkRectangle)rect);
        OS.gtk_tree_path_free((int)path);
        int[] wx = new int[1];
        OS.gtk_tree_view_tree_to_widget_coords((int)parentHandle, (int)rect.x, (int)0, (int[])wx, null);
        rect.x = wx[0];
        if (index == 0 && (this.parent.style & 0x20) != 0 && OS.gtk_major_version() * 100 + OS.gtk_minor_version() * 10 + OS.gtk_micro_version() >= 213) {
            int[] x = new int[1];
            int[] w = new int[1];
            OS.gtk_tree_view_column_cell_get_position((int)column, (int)this.parent.checkRenderer, (int[])x, (int[])w);
            rect.x += x[0] + w[0];
            rect.width -= x[0] + w[0];
        }
        int border = this.parent.getBorderWidth();
        int headerHeight = this.parent.getHeaderHeight();
        return new Rectangle(rect.x + border, rect.y + headerHeight, rect.width + 1, rect.height + 1);
    }

    public boolean getChecked() {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        int[] ptr = new int[1];
        OS.gtk_tree_model_get((int)this.parent.modelHandle, (int)this.handle, (int)0, (int[])ptr, (int)-1);
        return ptr[0] != 0;
    }

    public Font getFont() {
        this.checkWidget();
        int[] ptr = new int[1];
        OS.gtk_tree_model_get((int)this.parent.modelHandle, (int)this.handle, (int)4, (int[])ptr, (int)-1);
        if (ptr[0] == 0) {
            return this.parent.getFont();
        }
        return Font.gtk_new(this.display, ptr[0]);
    }

    public Font getFont(int index) {
        this.checkWidget();
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return this.getFont();
        }
        int[] ptr = new int[1];
        int modelIndex = this.parent.columnCount == 0 ? 5 : this.parent.columns[index].modelIndex;
        OS.gtk_tree_model_get((int)this.parent.modelHandle, (int)this.handle, (int)(modelIndex + 4), (int[])ptr, (int)-1);
        if (ptr[0] == 0) {
            return this.getFont();
        }
        return Font.gtk_new(this.display, ptr[0]);
    }

    public Color getForeground() {
        this.checkWidget();
        int[] ptr = new int[1];
        OS.gtk_tree_model_get((int)this.parent.modelHandle, (int)this.handle, (int)2, (int[])ptr, (int)-1);
        if (ptr[0] == 0) {
            return this.parent.getForeground();
        }
        GdkColor gdkColor = new GdkColor();
        OS.memmove((GdkColor)gdkColor, (int)ptr[0], (int)GdkColor.sizeof);
        return Color.gtk_new(this.display, gdkColor);
    }

    public Color getForeground(int index) {
        this.checkWidget();
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return this.getForeground();
        }
        int[] ptr = new int[1];
        int modelIndex = this.parent.columnCount == 0 ? 5 : this.parent.columns[index].modelIndex;
        OS.gtk_tree_model_get((int)this.parent.modelHandle, (int)this.handle, (int)(modelIndex + 2), (int[])ptr, (int)-1);
        if (ptr[0] == 0) {
            return this.getForeground();
        }
        GdkColor gdkColor = new GdkColor();
        OS.memmove((GdkColor)gdkColor, (int)ptr[0], (int)GdkColor.sizeof);
        return Color.gtk_new(this.display, gdkColor);
    }

    public boolean getGrayed() {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        int[] ptr = new int[1];
        OS.gtk_tree_model_get((int)this.parent.modelHandle, (int)this.handle, (int)1, (int[])ptr, (int)-1);
        return ptr[0] != 0;
    }

    public Image getImage() {
        this.checkWidget();
        return this.getImage(0);
    }

    public Image getImage(int index) {
        this.checkWidget();
        if (index < 0 || index > this.parent.columnCount) {
            return null;
        }
        int parentHandle = this.parent.handle;
        int column = OS.gtk_tree_view_get_column((int)parentHandle, (int)index);
        if (column == 0) {
            return null;
        }
        int[] ptr = new int[1];
        int modelIndex = this.parent.columnCount == 0 ? 5 : this.parent.columns[index].modelIndex;
        OS.gtk_tree_model_get((int)this.parent.modelHandle, (int)this.handle, (int)modelIndex, (int[])ptr, (int)-1);
        if (ptr[0] == 0) {
            return null;
        }
        ImageList imageList = this.parent.imageList;
        int imageIndex = imageList.indexOf(ptr[0]);
        if (imageIndex == -1) {
            return null;
        }
        return imageList.get(imageIndex);
    }

    public Rectangle getImageBounds(int index) {
        this.checkWidget();
        int parentHandle = this.parent.handle;
        int column = OS.gtk_tree_view_get_column((int)parentHandle, (int)index);
        if (column == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int list = OS.gtk_tree_view_column_get_cell_renderers((int)column);
        if (list == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int count = OS.g_list_length((int)list);
        int pixbufRenderer = 0;
        int i = 0;
        while (i < count) {
            int renderer = OS.g_list_nth_data((int)list, (int)i);
            if (OS.GTK_IS_CELL_RENDERER_PIXBUF((int)renderer)) {
                pixbufRenderer = renderer;
                break;
            }
            ++i;
        }
        OS.g_list_free((int)list);
        if (pixbufRenderer == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        GdkRectangle rect = new GdkRectangle();
        int path = OS.gtk_tree_model_get_path((int)this.parent.modelHandle, (int)this.handle);
        OS.gtk_widget_realize((int)parentHandle);
        OS.gtk_tree_view_get_cell_area((int)parentHandle, (int)path, (int)column, (GdkRectangle)rect);
        OS.gtk_tree_path_free((int)path);
        int[] wx = new int[1];
        OS.gtk_tree_view_tree_to_widget_coords((int)parentHandle, (int)rect.x, (int)0, (int[])wx, null);
        rect.x = wx[0];
        int[] w = new int[1];
        if (OS.gtk_major_version() * 100 + OS.gtk_minor_version() * 10 + OS.gtk_micro_version() < 213) {
            OS.gtk_tree_view_column_cell_set_cell_data((int)column, (int)this.parent.modelHandle, (int)this.handle, (boolean)false, (boolean)false);
            OS.gtk_cell_renderer_get_size((int)pixbufRenderer, (int)parentHandle, null, null, null, (int[])w, null);
        } else {
            int[] x = new int[1];
            OS.gtk_tree_view_column_cell_get_position((int)column, (int)pixbufRenderer, (int[])x, (int[])w);
            rect.x += x[0];
        }
        int border = this.parent.getBorderWidth();
        int headerHeight = this.parent.getHeaderHeight();
        return new Rectangle(rect.x + border, rect.y + headerHeight, w[0], rect.height + 1);
    }

    public int getImageIndent() {
        this.checkWidget();
        return 0;
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    public String getText() {
        this.checkWidget();
        return this.getText(0);
    }

    public String getText(int index) {
        this.checkWidget();
        if (index < 0 || index > this.parent.columnCount) {
            return "";
        }
        int parentHandle = this.parent.handle;
        int column = OS.gtk_tree_view_get_column((int)parentHandle, (int)index);
        if (column == 0) {
            this.error(12);
        }
        int[] ptr = new int[1];
        int modelIndex = this.parent.columnCount == 0 ? 5 : this.parent.columns[index].modelIndex;
        OS.gtk_tree_model_get((int)this.parent.modelHandle, (int)this.handle, (int)(modelIndex + 1), (int[])ptr, (int)-1);
        if (ptr[0] == 0) {
            return "";
        }
        int length = OS.strlen((int)ptr[0]);
        byte[] buffer = new byte[length];
        OS.memmove((byte[])buffer, (int)ptr[0], (int)length);
        OS.g_free((int)ptr[0]);
        return new String(Converter.mbcsToWcs(null, buffer));
    }

    void releaseChild() {
        super.releaseChild();
        this.parent.destroyItem(this);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.handle != 0) {
            OS.g_free((int)this.handle);
        }
        this.handle = 0;
        this.parent = null;
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        GdkColor gdkColor = color != null ? color.handle : null;
        OS.gtk_list_store_set((int)this.parent.modelHandle, (int)this.handle, (int)3, (GdkColor)gdkColor, (int)-1);
        this.cached = true;
    }

    public void setBackground(int index, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return;
        }
        GdkColor gdkColor = color != null ? color.handle : null;
        int parentHandle = this.parent.handle;
        int column = OS.gtk_tree_view_get_column((int)parentHandle, (int)index);
        if (column == 0) {
            return;
        }
        int modelIndex = this.parent.columnCount == 0 ? 5 : this.parent.columns[index].modelIndex;
        OS.gtk_list_store_set((int)this.parent.modelHandle, (int)this.handle, (int)(modelIndex + 3), (GdkColor)gdkColor, (int)-1);
        this.cached = true;
        if (color != null) {
            boolean customDraw;
            boolean bl = customDraw = this.parent.columnCount == 0 ? this.parent.firstCustomDraw : this.parent.columns[index].customDraw;
            if (!customDraw) {
                int list = OS.gtk_tree_view_column_get_cell_renderers((int)column);
                int length = OS.g_list_length((int)list);
                int textRenderer = OS.g_list_nth_data((int)list, (int)(length - 1));
                int pixbufRenderer = OS.g_list_nth_data((int)list, (int)(length - 2));
                OS.g_list_free((int)list);
                if ((this.parent.style & 0x10000000) == 0) {
                    OS.gtk_tree_view_column_set_cell_data_func((int)column, (int)textRenderer, (int)this.display.textCellDataProc, (int)this.parent.handle, (int)0);
                    OS.gtk_tree_view_column_set_cell_data_func((int)column, (int)pixbufRenderer, (int)this.display.pixbufCellDataProc, (int)this.parent.handle, (int)0);
                }
                if (this.parent.columnCount == 0) {
                    this.parent.firstCustomDraw = true;
                } else {
                    this.parent.columns[index].customDraw = true;
                }
            }
        }
    }

    public void setChecked(boolean checked) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        OS.gtk_list_store_set((int)this.parent.modelHandle, (int)this.handle, (int)0, (boolean)checked, (int)-1);
        this.cached = true;
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        int fontHandle = font != null ? font.handle : 0;
        OS.gtk_list_store_set((int)this.parent.modelHandle, (int)this.handle, (int)4, (int)fontHandle, (int)-1);
        this.cached = true;
    }

    public void setFont(int index, Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return;
        }
        int parentHandle = this.parent.handle;
        int column = OS.gtk_tree_view_get_column((int)parentHandle, (int)index);
        if (column == 0) {
            return;
        }
        int modelIndex = this.parent.columnCount == 0 ? 5 : this.parent.columns[index].modelIndex;
        int fontHandle = font != null ? font.handle : 0;
        OS.gtk_list_store_set((int)this.parent.modelHandle, (int)this.handle, (int)(modelIndex + 4), (int)fontHandle, (int)-1);
        this.cached = true;
        if (font != null) {
            boolean customDraw;
            boolean bl = customDraw = this.parent.columnCount == 0 ? this.parent.firstCustomDraw : this.parent.columns[index].customDraw;
            if (!customDraw) {
                int list = OS.gtk_tree_view_column_get_cell_renderers((int)column);
                int length = OS.g_list_length((int)list);
                int imageRenderer = OS.g_list_nth_data((int)list, (int)(length - 2));
                int textRenderer = OS.g_list_nth_data((int)list, (int)(length - 1));
                OS.g_list_free((int)list);
                if ((this.parent.style & 0x10000000) == 0) {
                    OS.gtk_tree_view_column_set_cell_data_func((int)column, (int)imageRenderer, (int)this.display.pixbufCellDataProc, (int)this.parent.handle, (int)0);
                    OS.gtk_tree_view_column_set_cell_data_func((int)column, (int)textRenderer, (int)this.display.textCellDataProc, (int)this.parent.handle, (int)0);
                }
                if (this.parent.columnCount == 0) {
                    this.parent.firstCustomDraw = true;
                } else {
                    this.parent.columns[index].customDraw = true;
                }
            }
        }
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        GdkColor gdkColor = color != null ? color.handle : null;
        OS.gtk_list_store_set((int)this.parent.modelHandle, (int)this.handle, (int)2, (GdkColor)gdkColor, (int)-1);
        this.cached = true;
    }

    public void setForeground(int index, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return;
        }
        GdkColor gdkColor = color != null ? color.handle : null;
        int parentHandle = this.parent.handle;
        int column = OS.gtk_tree_view_get_column((int)parentHandle, (int)index);
        if (column == 0) {
            return;
        }
        int modelIndex = this.parent.columnCount == 0 ? 5 : this.parent.columns[index].modelIndex;
        OS.gtk_list_store_set((int)this.parent.modelHandle, (int)this.handle, (int)(modelIndex + 2), (GdkColor)gdkColor, (int)-1);
        this.cached = true;
        if (color != null) {
            boolean customDraw;
            boolean bl = customDraw = this.parent.columnCount == 0 ? this.parent.firstCustomDraw : this.parent.columns[index].customDraw;
            if (!customDraw) {
                int list = OS.gtk_tree_view_column_get_cell_renderers((int)column);
                int length = OS.g_list_length((int)list);
                int textRenderer = OS.g_list_nth_data((int)list, (int)(length - 1));
                int imageRenderer = OS.g_list_nth_data((int)list, (int)(length - 2));
                OS.g_list_free((int)list);
                if ((this.parent.style & 0x10000000) == 0) {
                    OS.gtk_tree_view_column_set_cell_data_func((int)column, (int)textRenderer, (int)this.display.textCellDataProc, (int)this.parent.handle, (int)0);
                    OS.gtk_tree_view_column_set_cell_data_func((int)column, (int)imageRenderer, (int)this.display.pixbufCellDataProc, (int)this.parent.handle, (int)0);
                }
                if (this.parent.columnCount == 0) {
                    this.parent.firstCustomDraw = true;
                } else {
                    this.parent.columns[index].customDraw = true;
                }
            }
        }
    }

    public void setGrayed(boolean grayed) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        OS.gtk_list_store_set((int)this.parent.modelHandle, (int)this.handle, (int)1, (boolean)grayed, (int)-1);
        this.cached = true;
    }

    public void setImage(int index, Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if (index < 0 || index > this.parent.columnCount) {
            return;
        }
        int parentHandle = this.parent.handle;
        int column = OS.gtk_tree_view_get_column((int)parentHandle, (int)index);
        if (column == 0) {
            return;
        }
        int pixbuf = 0;
        if (image != null) {
            int imageIndex;
            ImageList imageList = this.parent.imageList;
            if (imageList == null) {
                imageList = this.parent.imageList = new ImageList();
            }
            if ((imageIndex = imageList.indexOf(image)) == -1) {
                imageIndex = imageList.add(image);
            }
            pixbuf = imageList.getPixbuf(imageIndex);
        }
        int modelIndex = this.parent.columnCount == 0 ? 5 : this.parent.columns[index].modelIndex;
        OS.gtk_list_store_set((int)this.parent.modelHandle, (int)this.handle, (int)modelIndex, (int)pixbuf, (int)-1);
        this.cached = true;
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.setImage(0, image);
    }

    public void setImage(Image[] images) {
        this.checkWidget();
        if (images == null) {
            this.error(4);
        }
        int i = 0;
        while (i < images.length) {
            this.setImage(i, images[i]);
            ++i;
        }
    }

    public void setImageIndent(int indent) {
        this.checkWidget();
        if (indent < 0) {
            return;
        }
        this.cached = true;
    }

    public void setText(int index, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (index < 0 || index > this.parent.columnCount) {
            return;
        }
        int parentHandle = this.parent.handle;
        int column = OS.gtk_tree_view_get_column((int)parentHandle, (int)index);
        if (column == 0) {
            return;
        }
        byte[] buffer = Converter.wcsToMbcs(null, string, true);
        int modelIndex = this.parent.columnCount == 0 ? 5 : this.parent.columns[index].modelIndex;
        OS.gtk_list_store_set((int)this.parent.modelHandle, (int)this.handle, (int)(modelIndex + 1), (byte[])buffer, (int)-1);
        this.cached = true;
    }

    public void setText(String string) {
        this.checkWidget();
        this.setText(0, string);
    }

    public void setText(String[] strings) {
        this.checkWidget();
        if (strings == null) {
            this.error(4);
        }
        int i = 0;
        while (i < strings.length) {
            String string = strings[i];
            if (string != null) {
                this.setText(i, string);
            }
            ++i;
        }
    }
}

