;; @(#) extra-java-font-lock.el -- extra highlighting for java
;; @(#) $Id: jde-java-font-lock.el,v 1.3 2000/12/18 05:22:45 paulk Exp $

;; This file is not part of Emacs

;; Copyright (C) 1998, 1999, 2000 by David Ponce
;; Author:       David Ponce david.ponce@wanadoo.fr
;; Maintainer:   David Ponce david.ponce@wanadoo.fr
;;               Paul Kinnucan paulk@mathworks.com
;; Created:      September 28 1998

;; LCD Archive Entry:
;; jde-java-font-lock|David Ponce|david.ponce@wanadoo.fr|
;; extra highlighting for java|
;; $Date: 2000/12/18 05:22:45 $|$Revision: 1.3 $|~/misc/extra-java-font-lock.el|

;; COPYRIGHT NOTICE
;;
;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Description:
;;
;;  Adds some extra highlighting to `java-mode' and `jde-mode'


;;; Customization:
;;

;;; Support:
;;
;;  Any comments, suggestions, bug reports or upgrade requests are welcome.
;;  Please send them to David Ponce at david.ponce@wanadoo.fr.
;;
;;  This version of jpack was developed with NTEmacs 20.3.1 under MS Windows
;;  NT 4 WKS SP3 and also tested with Emacs 20.3 under Sun Solaris 2.5.
;;  Please, let me know if it works with other OS and versions of Emacs.

;;; Code:

;; java-font-lock20a.el --- patch font-lock for Java in Gnu Emacs20
;;(load "java-font-lock20a")

(defcustom jde-use-font-lock t
  "*Turn on font-locking if on.
	Set to nil to disable the use of font-locking."
  :group 'jde-project
  :type 'boolean)


;; creates a specific face for numbers
(defface jde-java-font-lock-number-face
  '((((class grayscale) (background light)) (:foreground "DimGray" :italic t))
    (((class grayscale) (background dark)) (:foreground "LightGray" :italic t))
    (((class color) (background light)) (:foreground "RosyBrown"))
    (((class color) (background dark)) (:foreground "LightSalmon"))
    (t (:italic t)))
  "Font Lock mode face used to highlight numbers."
  :group 'font-lock-highlighting-faces)

;; creates a specific face for links
(defface jde-java-font-lock-link-face
  '((t (:foreground "blue" :italic nil :underline t)))
  "Font Lock mode face used to highlight links."
  :group 'font-lock-highlighting-faces)

(if jde-xemacsp
    (progn
      (defvar font-lock-builtin-face		'font-lock-builtin-face
	"Face name to use for builtins.")

      (defface font-lock-builtin-face
	'((t (:foreground "blue" :italic nil :underline t)))
	"Font Lock mode face used to highlight links."
	:group 'font-lock-highlighting-faces)

      (defvar font-lock-constant-face		'font-lock-constant-face
	"Face name to use for constant and label names.")

      (defface font-lock-constant-face
	'((((class grayscale) (background light))
	   (:foreground "LightGray" :bold t :underline t))
	  (((class grayscale) (background dark))
	   (:foreground "Gray50" :bold t :underline t))
	  (((class color) (background light)) (:foreground "CadetBlue"))
	  (((class color) (background dark)) (:foreground "Aquamarine"))
	  (t (:bold t :underline t)))
	"Font Lock mode face used to highlight constants and labels."
	:group 'font-lock-highlighting-faces)

      ))


;; defines the extra font lock faces
(defvar jde-java-font-lock-number-face    'jde-java-font-lock-number-face)
(defvar jde-java-font-lock-link-face      'jde-java-font-lock-link-face)
(defvar jde-java-font-lock-bold-face      'bold)
(defvar jde-java-font-lock-italic-face    'italic)
(defvar jde-java-font-lock-underline-face 'underline)
(defvar jde-java-font-lock-pre-face       'default)
(defvar jde-java-font-lock-code-face      'font-lock-builtin-face)

;; extra fontification regexps
(defvar java-font-lock-keywords-4
  (eval-when-compile
    (list
     
     ;; Use a different face for modifiers
      (cons (concat "\\<\\("
                    (regexp-opt '("abstract" "const" "final" "synchronized"
                                  "transient" "static" "volatile" "public"
                                  "private" "protected" "native"))
                    "\\)\\>")
            'font-lock-builtin-face)
       
     '("\\b\\(0[xX][0-9a-fA-F]+[lL]?\\|[0-9]+\\.?[0-9]*\\([eE][-+]?[0-9]+\\)?\\([lL]\\|[fF]\\|[dD]\\)?\\)\\b" . jde-java-font-lock-number-face)
       
     '("\\b\\(\\.[0-9]+\\([eE][-+]?[0-9]+\\)?\\([lL]\\|[fF]\\|[dD]\\)?\\)\\b" . jde-java-font-lock-number-face)
       
     ;; Fontify capitalised identifiers as constant
;;     '("\\(\\.\\|\\b\\)\\([A-Z_]+[A-Z0-9_]*\\)\\([]-[;,.=><!~?:&|+*/^%) \n\r\t]\\)"
;;       2 font-lock-constant-face             keep)
     '("\\b[A-Z_]+[A-Z0-9_]*\\b" . font-lock-constant-face)

     ;; Fontify text between `' in comments
     '("`\\(.*\\)'"
       1 font-lock-constant-face             prepend)
       
     ;; Javadoc tags within comments.
     '("@\\(deprecated\\|since\\|serial\\|serialData\\|serialField\\|throws\\)\\>"
       1 font-lock-constant-face            prepend)
     '("{@\\(docRoot\\)}"
       1 font-lock-constant-face            prepend)
;;;     '("{@\\(link\\)\\>[^}\n\r]*}?" ;; no newlines in link tag
     '("{@\\(link\\)\\>\\s-+\\(.*\\)\\s-*}"
       (1 font-lock-constant-face            prepend)
       (2 jde-java-font-lock-link-face     prepend))
     
     ;; Basic HTML highlighting in javadoc comments
     ;; Fontify the text of a HREF anchor.
     '("<[Aa]\\s-+[Hh][Rr][Ee][Ff][^>]*>\\([^>]+\\)</[Aa]>"
       1 jde-java-font-lock-link-face      t)
     ;; Fontify <b>, <strong>, <i>, <u>, <code> and <pre> tags when no tags inside
     '("<[Ss][Tt][Rr][Oo][Nn][Gg]>\\([^<]*\\)</[Ss][Tt][Rr][Oo][Nn][Gg]>"
       1 jde-java-font-lock-bold-face      t)
     '("<[Bb]>\\([^<]*\\)</[Bb]>"
       1 jde-java-font-lock-bold-face      t)
     '("<[Ii]>\\([^<]*\\)</[Ii]>"
       1 jde-java-font-lock-italic-face    t)
     '("<[Uu]>\\([^<]*\\)</[Uu]>"
       1 jde-java-font-lock-underline-face t)
     '("<[Cc][Oo][Dd][Ee]>\\([^<]*\\)</[Cc][Oo][Dd][Ee]>"
       1 jde-java-font-lock-code-face      t)
     '("<[Pp][Rr][Ee]>\\([^<]*\\)</[Pp][Rr][Ee]>"
       1 jde-java-font-lock-pre-face       t))))


;; Setup jde-mode for font locking.
(if jde-xemacsp
    (progn 
      (put 'jde-mode 'font-lock-defaults
	 '((java-font-lock-keywords
	    java-font-lock-keywords-1 
	    java-font-lock-keywords-2
	    java-font-lock-keywords-3
	    ;; Adding the next line breaks font-locking
            ;; in XEmacs for some reason that I cannot
            ;; fathom. So I'm disabling for now.
	    ;; java-font-lock-keywords-4
	    )
	   nil nil ((?_ . "w")) beginning-of-defun)))
  (progn 
    (font-lock-add-keywords 'jde-mode java-font-lock-keywords)
    (font-lock-add-keywords 'jde-mode java-font-lock-keywords-1)
    (font-lock-add-keywords 'jde-mode java-font-lock-keywords-2)
    (font-lock-add-keywords 'jde-mode java-font-lock-keywords-3)
    (font-lock-add-keywords 'jde-mode java-font-lock-keywords-4)))


(defun jde-setup-syntax-coloring() 
  ;; Set up syntax coloring.
  (cond (window-system

	 ;; If not XEmacs 20.1 turn on font lock.
	 ;; (XEmacs 21 has font-lock on by default.)
	 (if (or
	      (not jde-xemacsp)
	      (not
	       (and
		(eq emacs-major-version 21)
		(eq emacs-minor-version 0))))
	     (turn-on-font-lock))

	 (setq font-lock-maximum-decoration t)

	 (if (not jde-xemacsp)
	     (global-font-lock-mode 1 t))
	 )))


(provide 'jde-java-font-lock)

;;; Change History:

;;
;; $Log: jde-java-font-lock.el,v $
;; Revision 1.3  2000/12/18 05:22:45  paulk
;; *** empty log message ***
;;
;; Revision 1.2  2000/10/10 06:41:47  paulk
;; Fixed some XEmacs compatibility problems.
;;
;; Revision 1.1  2000/10/08 12:53:22  paulk
;; Initial revision.
;;


;;; extra-java-font-lock.el ends here.
