/*********************************************************************
 *
 *	Copyright (C) 1999-2001 Nathan Fiedler
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * PROJECT:	Utilities
 * MODULE:	Assert
 * FILE:	AssertionException.java
 *
 * AUTHOR:      Nathan Fiedler
 *
 * REVISION HISTORY:
 *	Name	Date		Description
 *	----	----		-----------
 *	nf	04/10/99	Initial version
 *
 * DESCRIPTION:
 *      This file defines the AssertException class for providing
 *      assertion capabilities to Java programs.
 *
 * $Id: AssertionException.java,v 1.2 2001/09/17 01:07:07 nfiedler Exp $
 *
 ********************************************************************/

package com.bluemarsh.util;

/**
 * A subclass of RuntimeException that simply provides a type
 * to be associated with failed assertions.
 *
 * @author  Nathan Fiedler
 */
public class AssertionException extends RuntimeException {

    /**
     * Create a new runtime exception.
     */
    public AssertionException() {
	super();
    } // AssertionException

    /**
     * Create a new runtime exception. Will display the given
     * string along with the usual exception message, to assist
     * in identifying the cause of the failed assertion.
     *
     * @param  s  string to display with exception
     */
    public AssertionException(String s) {
	super(s);
    } // AssertionException
} // AssertionException
