/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log;

public interface Priority {
    public static final Enum DEBUG = new Enum("DEBUG", 5);
    public static final Enum INFO = new Enum("INFO", 10);
    public static final Enum WARN = new Enum("WARN", 15);
    public static final Enum ERROR = new Enum("ERROR", 20);
    public static final Enum FATAL_ERROR = new Enum("FATAL_ERROR", 20);

    public static final class Enum {
        protected final String m_name;
        protected final int m_priority;

        Enum(String name, int priority) {
            this.m_name = name;
            this.m_priority = priority;
        }

        public int getPriority() {
            return this.m_priority;
        }

        public String getName() {
            return this.m_name;
        }

        public boolean isGreater(Enum level) {
            return this.m_priority > level.getPriority();
        }

        public boolean isLower(Enum level) {
            return this.m_priority < level.getPriority();
        }

        public boolean isLowerOrEqual(Enum level) {
            return this.m_priority <= level.getPriority();
        }
    }
}

