/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.webmacro.NotFoundException;
import org.webmacro.broker.CreateResourceEvent;
import org.webmacro.broker.RequestResourceEvent;
import org.webmacro.broker.ResourceBroker;
import org.webmacro.broker.ResourceEvent;
import org.webmacro.broker.ResourceInitException;
import org.webmacro.broker.ResourceProvider;
import org.webmacro.engine.Engine;
import org.webmacro.engine.IntrospectionException;
import org.webmacro.engine.Parser;

public final class ParserProvider
implements ResourceProvider {
    private static final Hashtable _parsers = new Hashtable();
    private final Class[] _brokerParam = new Class[]{class$org$webmacro$Broker == null ? (class$org$webmacro$Broker = ParserProvider.class$("org.webmacro.Broker")) : class$org$webmacro$Broker};
    private final Object[] _brokerArg = new Object[1];
    private static final String[] _types = new String[]{"parser"};
    static /* synthetic */ Class class$org$webmacro$Broker;

    public final void register(String string) throws IntrospectionException, ResourceInitException {
        String string2 = ParserProvider.extractName(string);
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (Exception exception) {
            throw new IntrospectionException("No class " + string);
        }
        try {
            Parser parser = (Parser)_parsers.get(string2);
            if (parser == null) {
                Constructor<?> constructor = clazz.getConstructor(this._brokerParam);
                parser = (Parser)constructor.newInstance(this._brokerArg);
                _parsers.put(string2, parser);
            } else if (!clazz.equals(parser.getClass())) {
                throw new ResourceInitException("Attempt to register parser " + string + " failed because " + parser.getClass() + " is already registered for type " + string2);
            }
        }
        catch (InstantiationException instantiationException) {
            throw new IntrospectionException("Parsers could not be instantiated: " + instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IntrospectionException("Parser class must be public: " + illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ResourceInitException("Parser threw an exception: " + invocationTargetException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IntrospectionException("Parser missing the required constructor: " + noSuchMethodException);
        }
    }

    public final Parser getParser(String string) throws NotFoundException {
        Parser parser = (Parser)_parsers.get(string);
        if (parser == null) {
            throw new NotFoundException("No parser registered for type " + string);
        }
        return parser;
    }

    private static String extractName(String string) throws IntrospectionException {
        if (!string.endsWith("Parser")) {
            throw new IntrospectionException("Malformed classname, must end with Parser");
        }
        int n = string.length() - 6;
        int n2 = string.lastIndexOf(46, n) + 1;
        String string2 = string.substring(n2, n);
        if (string.startsWith("org.webmacro.")) {
            string2 = string2.toLowerCase();
        }
        return string2;
    }

    public String[] getTypes() {
        return _types;
    }

    public void init(ResourceBroker resourceBroker) throws ResourceInitException {
        this._brokerArg[0] = resourceBroker;
        try {
            String string = (String)resourceBroker.getValue("config", "Parsers");
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreElements()) {
                String string2 = (String)stringTokenizer.nextElement();
                try {
                    this.register(string2);
                }
                catch (Exception exception) {
                    Engine.log.exception(exception);
                    Engine.log.error("Could not load parser: " + string2);
                }
            }
        }
        catch (Exception exception) {
            Engine.log.exception(exception);
            throw new ResourceInitException("Could not init ParserProvider: " + exception);
        }
    }

    public void destroy() {
        _parsers.clear();
    }

    public void resourceRequest(RequestResourceEvent requestResourceEvent) throws NotFoundException {
        try {
            requestResourceEvent.set(this.getParser(requestResourceEvent.getName()));
        }
        catch (Exception exception) {
            throw new NotFoundException("No such directive: " + requestResourceEvent.getName() + ":" + exception.getMessage());
        }
    }

    public void resourceCreate(CreateResourceEvent createResourceEvent) throws NotFoundException, InterruptedException {
    }

    public boolean resourceDelete(ResourceEvent resourceEvent) {
        return false;
    }

    public boolean resourceSave(ResourceEvent resourceEvent) {
        return false;
    }

    public int resourceThreads() {
        return 0;
    }

    public int resourceExpireTime() {
        return 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

