// $Id: xxl_count.cc,v 1.3 1996/12/11 21:39:45 aml Exp $

#include "xxl_funcs.hh"
#include "sheet.hh"


Stack_elem *Count::eval(Stack_elem *p,Sheet *sheet, short col, short row) {
    double x;
    Range_iter r(p->contents.rg_val);
    Ref ref;
    Stack_elem *s;
    Cell *c;

    switch(p->type) {
      case FORM_FP:
      case FORM_INT:
        count++;
        break;
      case FORM_REF:
        c = sheet->cellFind(p->contents.ref_val);
        if (c->type == CODE_INTEGER ||
            c->type == CODE_NUMBER ||
            (c->type == CODE_FORMULA && 
             (c->formula->typ == FORM_FP ||
              c->formula->typ == FORM_INT)))
          count++;
        break;
        
      case FORM_STRING:
        break;
      case FORM_RANGE:
        short i,j;

        for(r.first(ref); !r.last();  r.next(ref)){
            i = cell_address(ref.col,col);
            j = cell_address(ref.row,row);
            c = sheet->cellFind(i,j);
            if (c->type == CODE_INTEGER ||
                c->type == CODE_NUMBER ||
                (c->type == CODE_FORMULA && 
                 (c->formula->typ == FORM_FP ||
                  c->formula->typ == FORM_INT)))
                count++;
        }
        break;
      default:
        internal_error();
    }
    se->type = FORM_INT;
    se->contents.int_val = count;
    return(se);

}

Count::Count() {
    count = 0;
    se = new Stack_elem;
}

Count::~Count() {
    delete se;
}

// $Log: xxl_count.cc,v $
// Revision 1.3  1996/12/11  21:39:45  aml
// Sumif implemented.
// Diverse time functions implemented.
// Fixed needtoscroll2 to avoid out of control scroll.
//
// Revision 1.2  1996/08/28 17:17:13  aml
// Load and save now accept string_value for formula cells.
// This fixes previous thought problem of formula values not
// being stored.
// Functions upper,lower and proper created.
// Function if can now return labels.
// Fixed problem with function count.
// Reasonably stable version, very used to manipulate notas.wk1.
//
// Revision 1.1  1996/03/08 12:48:11  aml
// Initial revision
//
