# $Id: funcmenu.tcl,v 1.3 1998/09/30 00:42:29 cthulhu Exp $

proc SwapLLBox {y} {
    global listOfFunctions MathAndTrigFunctions InformationFunctions \
	LogicalFunctions DateAndTimeFunctions TextFunctions \
	StatisticalFunctions

    set new [.funcmenu.midf.leftcol.bottom.f1.list nearest $y]
    if {$new==[.funcmenu.midf.leftcol.bottom.f1.list curselection]} {
	return
    } else {
	switch $new {
	    0 {ChangeListboxMenu \
		   .funcmenu.midf.rightcol.bottom $listOfFunctions}
	    1 {ChangeListboxMenu \
		   .funcmenu.midf.rightcol.bottom $MathAndTrigFunctions}
	    2 {ChangeListboxMenu \
		   .funcmenu.midf.rightcol.bottom $InformationFunctions}
	    3 {ChangeListboxMenu \
		   .funcmenu.midf.rightcol.bottom $LogicalFunctions}
	    4 {ChangeListboxMenu \
		   .funcmenu.midf.rightcol.bottom $DateAndTimeFunctions}
	    5 {ChangeListboxMenu \
		   .funcmenu.midf.rightcol.bottom $TextFunctions}
	    6 {ChangeListboxMenu \
		   .funcmenu.midf.rightcol.bottom $StatisticalFunctions}
	}
	.funcmenu.midf.rightcol.bottom.f1.list selection set 0
    }
}

proc DoInsert {} {
    source "[xxl_library]/globalvars.tcl"
    global listOfFunctions MathAndTrigFunctions InformationFunctions \
	LogicalFunctions DateAndTimeFunctions TextFunctions \
	StatisticalFunctions
    
    set res "="
    switch [.funcmenu.midf.leftcol.bottom.f1.list curselection] {
	0 {append res \
	       [lindex $listOfFunctions \
		    [.funcmenu.midf.rightcol.bottom.f1.list curselection]]}
	1 {append res \
	       [lindex $MathAndTrigFunctions \
		    [.funcmenu.midf.rightcol.bottom.f1.list curselection]]}
	2 {append res \
	       [lindex $InformationFunctions \
		    [.funcmenu.midf.rightcol.bottom.f1.list curselection]]}
	3 {append res \
	       [lindex $LogicalFunctions \
		    [.funcmenu.midf.rightcol.bottom.f1.list curselection]]}
	4 {append res \
	       [lindex $DateAndTimeFunctions \
		    [.funcmenu.midf.rightcol.bottom.f1.list curselection]]}
	5 {append res \
	       [lindex $TextFunctions \
		    [.funcmenu.midf.rightcol.bottom.f1.list curselection]]}
	6 {append res \
	       [lindex $StatisticalFunctions \
		    [.funcmenu.midf.rightcol.bottom.f1.list curselection]]}
    }
    destroy .funcmenu
    set len [expr [string length $res] +1]
    append res "()"
    set globalState formulaEnter
    focus .$activeSheet.fr.header.entry.active
    set activeText($activeSheet) $res
    .$activeSheet.fr.header.entry.active icursor $len
}

proc FuncMenu {} {
    source "[xxl_library]/globalvars.tcl"
    global listOfFunctions

    toplevel .funcmenu
    wm title .funcmenu "Paste Function"
	
    frame .funcmenu.midf
    frame .funcmenu.botf

    # left column, text and scrollwindow
    frame .funcmenu.midf.leftcol
    frame .funcmenu.midf.leftcol.top
    label .funcmenu.midf.leftcol.top.label -text "Type:"
    frame .funcmenu.midf.leftcol.bottom
    createListboxMenu .funcmenu.midf.leftcol.bottom \
	[list All "Math & Trig" "Information" "Logical" "Date & Time" "Text" \
	     "Statistical"] lixo 0
    .funcmenu.midf.leftcol.bottom.f1.list selection set 0

    bind .funcmenu.midf.leftcol.bottom.f1.list <Button-1> {SwapLLBox %y}
    pack .funcmenu.midf.leftcol.top.label -side left -expand yes
    pack .funcmenu.midf.leftcol.top -side top -expand yes -anchor w
    pack .funcmenu.midf.leftcol.bottom -side top -expand yes

    pack .funcmenu.midf.leftcol -side left -expand yes

    # right column, text and scrollwindow 
    frame .funcmenu.midf.rightcol
    frame .funcmenu.midf.rightcol.top
    label .funcmenu.midf.rightcol.top.label -text "Function:"
    frame .funcmenu.midf.rightcol.bottom
    createListboxMenu .funcmenu.midf.rightcol.bottom \
	$listOfFunctions lixo 0
    .funcmenu.midf.rightcol.bottom.f1.list selection set 0
    pack .funcmenu.midf.rightcol.top.label -side left -expand yes
    pack .funcmenu.midf.rightcol.top -side top -expand yes -anchor w
    pack .funcmenu.midf.rightcol.bottom -side top -expand yes
    
    pack .funcmenu.midf.rightcol -side left -expand yes

    bind .funcmenu.midf.rightcol.bottom.f1.list <Double-Button-1> {DoInsert} 

    # bottom row with two buttons
    button .funcmenu.botf.ok -text Ok -command {DoInsert}
    button .funcmenu.botf.help -text Help -command {
	grab release .funcmenu;

	switch [.funcmenu.midf.leftcol.bottom.f1.list curselection] {
	    0 {set tmp [lindex $listOfFunctions \
			     [.funcmenu.midf.rightcol.bottom.f1.list \
				  curselection]];
		AbacusHelp functions \
		    [string range $tmp 1 [string length $tmp]]}
	    1 {set tmp [lindex $InformationFunctions \
			     [.funcmenu.midf.rightcol.bottom.f1.list \
				  curselection]];
		AbacusHelp functions \
		    [string range $tmp 1 [string length $tmp]]}
	    2 {set tmp [lindex $InformationFunctions \
			     [.funcmenu.midf.rightcol.bottom.f1.list \
				  curselection]];
		AbacusHelp functions \
		    [string range $tmp 1 [string length $tmp]]}
	    3 {set tmp [lindex $LogicalFunctions \
			     [.funcmenu.midf.rightcol.bottom.f1.list \
				  curselection]];
		AbacusHelp functions \
		    [string range $tmp 1 [string length $tmp]]}
	    4 {set tmp [lindex $DateAndTimeFunctions \
			     [.funcmenu.midf.rightcol.bottom.f1.list \
				  curselection]];
		AbacusHelp functions \
		    [string range $tmp 1 [string length $tmp]]}
	    5 {set tmp [lindex $TextFunctions \
			     [.funcmenu.midf.rightcol.bottom.f1.list \
				  curselection]];
		AbacusHelp functions \
		    [string range $tmp 1 [string length $tmp]]}
	    6 {set tmp [lindex $StatisticalFunctions \
			     [.funcmenu.midf.rightcol.bottom.f1.list \
				  curselection]];
		AbacusHelp functions \
		    [string range $tmp 1 [string length $tmp]]}
	}
        grab .help;
        tkwait window .help;
        focus .funcmenu;
        grab .funcmenu;
        }

    button .funcmenu.botf.abort -text Abort -command {destroy .funcmenu}
    pack .funcmenu.botf.ok .funcmenu.botf.help -side bottom -fill x \
	-expand yes
    pack .funcmenu.botf.abort .funcmenu.botf.help -side bottom -fill x \
	-expand yes

    pack .funcmenu.midf -side top -expand yes
    pack .funcmenu.botf -side top -expand yes -fill x

    focus .funcmenu
    grab .funcmenu
    tkwait window .funcmenu
}

# $Log: funcmenu.tcl,v $
# Revision 1.3  1998/09/30 00:42:29  cthulhu
# Interface details affecting mouse behaviour.
#
# Revision 1.2  1998/08/27 14:12:59  cthulhu
# Added function help with AbacusHelp function.
#
# Revision 1.1  1998/08/17 20:04:14  cthulhu
# Initial revision
#