# $Id: menubar.tcl,v 1.25 1998/10/25 22:24:33 cthulhu Exp $
#
#

#
# Displays the main menu bar
#

proc displayMenuBar {mother} {
    frame $mother.menu -relief raised -bd 2

#
# First, the pulldown menus
#    

    menubutton $mother.menu.file -text File -menu $mother.menu.file.menu
    menubutton $mother.menu.edit -text Edit -menu $mother.menu.edit.menu
    menubutton $mother.menu.view -text View -menu $mother.menu.view.menu
#    menubutton $mother.menu.insert -text Insert -menu $mother.menu.insert.menu
    menubutton $mother.menu.format -text Format -menu $mother.menu.format.menu
    menubutton $mother.menu.tools -text Tools -menu $mother.menu.tools.menu
    menubutton $mother.menu.graphs -text Graphs -menu $mother.menu.graphs.menu
    menubutton $mother.menu.help -text Help -menu $mother.menu.help.menu


#
# The file menu
#

menu $mother.menu.file.menu
$mother.menu.file.menu add command -label New -command newSpreadsheet
$mother.menu.file.menu add command -label "Open ..." \
       -command loadSheet
$mother.menu.file.menu add command -label Close \
        -command {deleteSpreadsheet $activeSheet}
$mother.menu.file.menu add separator
$mother.menu.file.menu add command -label Save \
        -command {SaveSheet $activeSheet $activeSheet.wk1}
$mother.menu.file.menu add command -label "Save as ..." \
        -command saveSheet
$mother.menu.file.menu add separator
$mother.menu.file.menu add command -label "Import ..." -command {ImportBox}
$mother.menu.file.menu add command -label "Export ..." -command {ExportBox}
    
$mother.menu.file.menu add separator
$mother.menu.file.menu add command -label "Print ... " -command {printSheet}
$mother.menu.file.menu add command -label "Print setup ..." -command {printSetup}
$mother.menu.file.menu add separator
$mother.menu.file.menu add command -label Exit -command {set graphstate 1;exitXxl}


proc editPasteSpecial {} {
    source "[xxl_library]/globalvars.tcl"
    
    toplevel .special
    
    wm title .special "Paste Special"
    wm iconname .special "Paste Special"
    wm geometry .special 200x300

#
# Label Paste Special Types
#

    frame .special.f0 -relief raised -borderwidth 3
    label .special.f0.lab -text "Paste: " 
    pack .special.f0.lab -anchor center -side left -fill x 

#
# Special Types Radio Buttons : All,Formulas,Values,Formats
#

    frame .special.f1
    
    radiobutton .special.f1.r1 -variable specialtypes \
	-anchor w \
	-text "All" \
	-value 0 \
	-command { 
	    .special.f3.r1 configure -state normal
	    .special.f3.r2 configure -state normal
	    .special.f3.r3 configure -state normal
	    .special.f3.r4 configure -state normal
	    .special.f3.r5 configure -state normal
	}
    .special.f1.r1 select
    radiobutton .special.f1.r2 -variable specialtypes \
	-anchor w \
	-text "Formulas" \
	-value 1 \
	-command { 
	    .special.f3.r1 configure -state normal
	    .special.f3.r2 configure -state normal
	    .special.f3.r3 configure -state normal
	    .special.f3.r4 configure -state normal
	    .special.f3.r5 configure -state normal
	}

    radiobutton .special.f1.r3 -variable specialtypes \
	-anchor w \
	-text "Values" \
	-value 2 \
	-command { 
	    .special.f3.r1 configure -state normal
	    .special.f3.r2 configure -state normal
	    .special.f3.r3 configure -state normal
	    .special.f3.r4 configure -state normal
	    .special.f3.r5 configure -state normal
	}

    radiobutton .special.f1.r4 -variable specialtypes \
	-anchor w \
	-text "Formats" \
	-value 3 \
	-command { 
	    .special.f3.r1 configure -state disabled
	    .special.f3.r2 configure -state disabled
	    .special.f3.r3 configure -state disabled
	    .special.f3.r4 configure -state disabled
	    .special.f3.r5 configure -state disabled
	    set operations 0
	}

    pack .special.f1.r1 -fill x -side top -padx 45 -anchor w
    pack .special.f1.r2 -fill x -side top -padx 45 -anchor w
    pack .special.f1.r3 -fill x -side top -padx 45 -anchor w
    pack .special.f1.r4 -fill x -side top -padx 45 -anchor w

    pack .special.f0 -fill x -expand yes
    pack .special.f1 -fill x -expand yes

#
# Label Supported Operations
#

    frame .special.f2 -relief raised -borderwidth 3
    label .special.f2.lab -text "Operation: "
    pack .special.f2.lab -anchor center -side left -fill x

#
# Types of operations Supported:None,Add,Subtract,Multiply,Divide
#
    frame .special.f3 

    radiobutton .special.f3.r1 -variable operations \
	-anchor w \
	-text "None" \
	-value 0
    .special.f3.r1 select
    radiobutton .special.f3.r2 -variable operations \
	-anchor w \
	-text "Add" \
	-value 1
    radiobutton .special.f3.r3 -variable operations \
	-anchor w \
	-text "Subtract" \
	-value 2 
    radiobutton .special.f3.r4 -variable operations \
	-anchor w \
	-text "Multiply" \
	-value 3 
    radiobutton .special.f3.r5 -variable operations \
	-anchor w \
	-text "Divide" \
	-value 4 

    pack .special.f3.r1 -fill x -side top -padx 45 -anchor w
    pack .special.f3.r2 -fill x -side top -padx 45 -anchor w
    pack .special.f3.r3 -fill x -side top -padx 45 -anchor w
    pack .special.f3.r4 -fill x -side top -padx 45 -anchor w
    pack .special.f3.r5 -fill x -side top -padx 45 -anchor w

    pack .special.f2 -fill x -expand yes
    pack .special.f3 -fill x -expand yes

#
# Pack Ok,Abort Buttons
#

    frame .special.f4

    button .special.f4.ok -text Ok -command {
	if {$currentRange != ""} {
	    Paste $activeSheet \
                [lindex $currentRange 0] [lindex $currentRange 1] \
                [lindex $currentRange 2] [lindex $currentRange 3] \
		$specialtypes $operations
	    unhighlightCurrentRange [canvasFromSheet $activeSheet]
	    highlightActiveCell
	} else {
	    Paste $activeSheet $activeCellCol $activeCellRow \
		$specialtypes $operations
	    highlightActiveCell
	};
	destroy .special
	set globalState2 normal
    }

    button .special.f4.abort -text ABORT -command {destroy .special}

    pack .special.f4.abort -fill x -side bottom -expand yes
    pack .special.f4.ok -fill x -side bottom -expand yes

    pack .special.f1 .special.f2 .special.f3 .special.f4 -fill x -expand yes

#
# Some Bindings
#

    grab .special
}

proc ImportBox {} {

    toplevel .import
    wm title .import "Import Method"
    
    frame .import.topf
    createListboxMenu .import.topf [list \
					"Comma Separated Values" \
					"TAB Separated Values" \
					"Space Separated Values" \
					"Semicolon Separated Values" \
				       ] lixo
    pack .import.topf -side top -expand yes
    
    frame .import.botf
    button .import.botf.ok -text Ok \
	-command {
	    switch  [.import.topf.f1.list curselection] {
		0 {destroy .import ; importText "," }
		1 {destroy .import ; importText "\t" }
		2 {destroy .import ; importText " " }
		3 {destroy .import ; importText ";" }
	    }
	    highlightActiveCell
	}
    button .import.botf.abort -text Abort -command {destroy .import}
    pack .import.botf.ok .import.botf.abort -side top -expand yes -fill x
    pack .import.botf -side top -expand yes -fill x

    focus .import
    grab .import
    tkwait window .import
}

proc CheckPostScript {y} {
    
    set new [.export.topf.f1.list nearest $y]
    if {$new==5} {
	.export.midf.options.val configure -state disabled
	.export.midf.options.res configure -state disabled
    } else {
	.export.midf.options.val configure -state normal
	.export.midf.options.res configure -state normal
    }
}

proc ExportBox {} {
    toplevel .export
    wm title .export "Export Method"
    source "[xxl_library]/globalvars.tcl"
    
    frame .export.topf
    createListboxMenu .export.topf [list \
					"Comma Separated Values" \
					"TAB Separated Values" \
					"Space Separated Values" \
					"Semicolon Separated Values" \
					"TinySheet Format" \
					"Encapsulated PostScript" \
				       ] lixo
    .export.topf.f1.list selection set 0
    bind .export.topf.f1.list <Button-1> {CheckPostScript %y}
    pack .export.topf -side top -expand yes -fill both
    
    frame .export.midf
    label .export.midf.label -justify left \
	-text "Formulas should be exported using:"
    set ValOrForm 0
    frame .export.midf.options
    radiobutton .export.midf.options.val -variable ValOrForm \
	-text "Result" -value 0
    radiobutton .export.midf.options.res -variable ValOrForm \
	-text "Formula string" -value 1
    .export.midf.options.val select
    pack .export.midf.options.val .export.midf.options.res -side left
    pack .export.midf.label -side top -expand yes -fill both
    pack .export.midf.options -side top
    pack .export.midf -side top -expand yes
    
    frame .export.botf
    button .export.botf.ok -text Ok \
	-command {
	    switch  [.export.topf.f1.list curselection] {
		0 {destroy .export ; exportText "," $ValOrForm}
		1 {destroy .export ; exportText "\t" $ValOrForm}
		2 {destroy .export ; exportText " " $ValOrForm}
		3 {destroy .export ; exportText ";" $ValOrForm}
		4 {destroy .export ; exportTinySheetFile $ValOrForm}
		5 {destroy .export ; printCurrentRange}
	    }
	}
    button .export.botf.abort -text Abort -command {destroy .export}
    pack .export.botf.ok .export.botf.abort -side top -expand yes -fill x
    pack .export.botf -side top -expand yes -fill x

    focus .export
    grab .export
    tkwait window .export
}
    
#
# The edit menu
#

menu $mother.menu.edit.menu
$mother.menu.edit.menu add command -label Undo \
    -command {UndoRedo $activeSheet 0} -state disabled
$mother.menu.edit.menu add command -label Redo \
    -command {UndoRedo $activeSheet 1} -state disabled
$mother.menu.edit.menu add separator
$mother.menu.edit.menu add command -label Cut \
    -command {rangeInitCommand copyData ; \
		  killCommand}
$mother.menu.edit.menu add command -label Copy \
    -command {rangeInitCommand copyData}
$mother.menu.edit.menu add command -label Move \
    -command {rangeInitCommand moveData}
$mother.menu.edit.menu add command -label Paste -command {copyExec}
$mother.menu.edit.menu add command -label "Paste special" \
    -command {editPasteSpecial}
$mother.menu.edit.menu add separator
$mother.menu.edit.menu add cascade -label "Insert" \
    -menu $mother.menu.edit.menu.insert 

menu $mother.menu.edit.menu.insert
$mother.menu.edit.menu.insert add command -label Column \
    -command {
	if {$cols_selected!=""} {
	    set first [lindex $cols_selected 0]
	    set last [lindex $cols_selected 1]
	    if {$first < $last} {
		set activeCellCol $first
		InsertRowOrColumn $activeSheet $first \
		    [expr $last - $first + 1] c 1
	    } else {
		set activeCellCol $last
		InsertRowOrColumn $activeSheet $last \
		    [expr $first - $last + 1] c 1
	    }
	} elseif {$currentRange==""} {
	    set activeCellCol $activeCellCol
	    InsertRowOrColumn $activeSheet $activeCellCol 1 c 1
	} else {
	    set first [lindex $currentRange 0]
	    set last [lindex $currentRange 2]
	    set activeCellCol $first
	    InsertRowOrColumn $activeSheet $first \
		    [expr $last - $first + 1] c 1
	}
	redrawCanvas $activeSheet
	unhighlightColSelection 1
	unhighlightRowSelection 1
	unhighlightCurrentRange [canvasFromSheet $activeSheet]
	highlightActiveCell
    }
$mother.menu.edit.menu.insert add command -label Row \
    -command {
	if {$rows_selected!=""} {
	    set first [lindex $rows_selected 0]
	    set last [lindex $rows_selected 1]
	    if {$first < $last} {
		set activeCellRow $first
		InsertRowOrColumn $activeSheet $first \
		    [expr $last - $first + 1] r 1
	    } else {
		set activeCellRow $last
		InsertRowOrColumn $activeSheet $last \
		    [expr $first - $last + 1] r 1
	    }
	} elseif {$currentRange==""} {
	    set activeCellRow $activeCellRow
	    InsertRowOrColumn $activeSheet $activeCellRow 1 r 1
	} else {
	    set first [lindex $currentRange 1]
	    set last [lindex $currentRange 3]
	    set activeCellRow $first
	    InsertRowOrColumn $activeSheet $first \
		    [expr $last - $first + 1] r 1
	}
	redrawCanvas $activeSheet
	unhighlightColSelection 1
	unhighlightRowSelection 1
	unhighlightCurrentRange [canvasFromSheet $activeSheet]
	highlightActiveCell
    }
$mother.menu.edit.menu add command -label Delete -command {killCommand}
$mother.menu.edit.menu add separator
$mother.menu.edit.menu add command -label "Find ..." \
    -command {Search $activeSheet}
$mother.menu.edit.menu add command -label "Replace ..." \
    -command {Replace $activeSheet}

#
# The view menu
#

global showStandard 
set showStandard 1

menu $mother.menu.view.menu 
$mother.menu.view.menu add checkbutton -variable showCellBorders \
        -label "Cell borders" \
        -command {ToggleDisplayBorders $activeSheet ;\
        toggleCellBordersDisplay }

$mother.menu.view.menu add checkbutton -variable showPageBorders \
        -label "Page borders" \
        -command { TogglePageBorders $activeSheet ;\
        togglePageBordersDisplay }





#$mother.menu.view.menu add separator
#$mother.menu.view.menu add command -label "Toolbars" -foreground gray50
#$mother.menu.view.menu add checkbutton -variable showStandard \
        -label "Standard" -foreground gray50 \
        -command {toggleToolBarDisplay standard}
#$mother.menu.view.menu add checkbutton -variable showFormat \
        -label "Format" -foreground gray50 \
        -command {toggleToolBarDisplay format}

proc toggleCellBordersDisplay {} {
    global showCellBorders activeSheet

    if {$showCellBorders == 1} {
        redrawCanvas $activeSheet
    } else {
        deleteCellBorders $activeSheet
        refreshCanvas $activeSheet
    }
}

proc togglePageBordersDisplay {} {
    global showPageBorders activeSheet
    global printRange paperWidth paperHeight typeView scale  

    if {$showPageBorders == 0} {
        [canvasFromSheet $activeSheet] delete pageLimits
    } else {
        getPrintParamsFromSheet
        computePrintParams
    }
}

proc toggleToolBarDisplay {toolbar} {
    global show$toolbar

}

proc autosave {time} {
    source "[xxl_library]/globalvars.tcl"

    if {$time <= 0} {
	if {[info exists autoSaveID]} {
	    after cancel $autoSaveID
	}
    } elseif {$time==$autoSave} {
	SaveSheet $activeSheet $activeSheet.autosave NoDialog
	set autoSaveID [after $time [list autosave $time]]
    } else {
	if {[info exists autoSaveID]} {
	    after cancel $autoSaveID
	}
	SaveSheet $activeSheet $activeSheet.autosave NoDialog
	set autoSaveID [after $time [list autosave $time]]
    }
}

proc AutoSaveDlg {} {
    source "[xxl_library]/globalvars.tcl"

    toplevel .autosave
    
    frame .autosave.f0 -relief raised -borderwidth 3
    label .autosave.f0.lab -text Autosave
    pack .autosave.f0.lab -anchor center -side left -fill x

    frame .autosave.f1
    label .autosave.f1.lab -text "Autosave timeout in seconds (0 to disable): "
    entry .autosave.f1.auto -textvar autoSave -bg white
    pack .autosave.f1.lab .autosave.f1.auto -fill x -side left -expand yes

    frame .autosave.f2
    button .autosave.f2.ok -text Ok -command {
	autosave [ expr $autoSave * 1000]
	destroy .autosave
    }
    pack .autosave.f2.ok -fill x -side left -expand yes

    pack .autosave.f0 .autosave.f1 .autosave.f2 -fill x -expand yes
    grab .autosave
}

#
# The insert menu
#

#menu $mother.menu.insert.menu
#$mother.menu.insert.menu add command -label Cells -foreground gray50
#$mother.menu.insert.menu add command -label Rows -foreground gray50
#$mother.menu.insert.menu add command -label Columns -foreground gray50
#$mother.menu.insert.menu add separator
#$mother.menu.insert.menu add command -label Chart -foreground gray50
#$mother.menu.insert.menu add command -label Pictures -foreground gray50

#
# The format menu
#

menu $mother.menu.format.menu
$mother.menu.format.menu add command -label Fonts \
        -command {set f [fontSelect] ; applyFontToSelection $f }
        
#$mother.menu.format.menu add command -label Cells -foreground gray50
$mother.menu.format.menu add cascade \
        -label Columns -menu $mother.menu.format.menu.columns 
$mother.menu.format.menu add cascade \
        -label Rows -menu $mother.menu.format.menu.rows 
# $mother.menu.format.menu add separator
# $mother.menu.format.menu add command -label Sheet -foreground gray50

#
# Submenus for the format menu
#
menu $mother.menu.format.menu.columns 
$mother.menu.format.menu.columns add command -label "Column width" \
        -command "setColumnWidth"
menu $mother.menu.format.menu.rows
$mother.menu.format.menu.rows add command -label "Row height" \
        -command "setRowHeight"



proc setColumnWidth {} {
    global activeCellCol activeSheet colwidth maxwidth
    global colWidthChoice
    global activeColName 
    global cols_selected 

    set colWidthChoice 0

    toplevel .colwidth
    
    frame .colwidth.f0 -relief raised -borderwidth 3
    frame .colwidth.f1 

    if {[llength $cols_selected]!=0} {
	label .colwidth.f0.lab -text "Width for columns: "
	if {[lindex $cols_selected 0]>[lindex $cols_selected 1]} {
	    set tmp0 [lindex $cols_selected 0]
	    set tmp1 [lindex $cols_selected 1]
	    set cols_selected [lreplace $cols_selected 0 1 $tmp1 $tmp0]}

	set txt "[ColName [lindex $cols_selected 0]] until [ColName [lindex $cols_selected 1]]"

	label .colwidth.f0.lab2 -text $txt
    } else { 
	label .colwidth.f0.lab -text "Width for column "
	label .colwidth.f0.lab2 -text "$activeColName"
    }

    pack .colwidth.f0.lab .colwidth.f0.lab2 -anchor center -side left -fill x
    set colwidth [defCellWidth]
    radiobutton .colwidth.f1.r1 -variable colWidthChoice \
	-text "Set to width " \
	-value 1 \
	-command { 
	    if {[llength $cols_selected]!=0} {
		for {set i [lindex $cols_selected 0]} {$i <= [lindex $cols_selected 1]} \
		    {incr i} { doSetColWidth $colwidth $i }
	    } else {doSetColWidth $colwidth}
	}

    entry .colwidth.f1.width -textvar colwidth -bg white
    bind .colwidth.f1.width <Return> {destroy .colwidth}
    bind .colwidth.f1.width <Key> {set colWidtChoice 1}
    pack .colwidth.f1.r1 .colwidth.f1.width -fill x -side left -expand yes
    pack .colwidth.f0 -fill x -expand yes
    pack .colwidth.f1 -fill x -expand yes

    frame .colwidth.f2 
    radiobutton .colwidth.f2.r2 -variable colWidthChoice \
	-text "Set to width of largest item" -value 2 \
	-command { 
	    if {[llength $cols_selected]!=0} {
		for {set i [lindex $cols_selected 0]} {$i <= [lindex $cols_selected 1]} \
		    {incr i} {doSetColWidth [MaxTextWidth $activeSheet $i] $i }
	    } else {doSetColWidth [MaxTextWidth $activeSheet $activeCellCol] }
	}
    
    #    set maxwidth [MaxTextWidth $activeSheet $activeCellCol]
    set maxwidth ""
#    label .colwidth.f2.width2 -textvar maxwidth -bg white -relief sunken
     pack .colwidth.f2.r2 -side left -anchor w
#    pack .colwidth.f2.width2 -side right -fill x -expand yes
    pack .colwidth.f2 -fill x -expand yes

    frame .colwidth.f3
    button .colwidth.f3.ok -text Ok -command {destroy .colwidth}

    pack .colwidth.f3.ok -fill x -side left -expand yes
    pack .colwidth.f1 .colwidth.f2 .colwidth.f3 -fill x -expand yes
    bind .colwidth <Leave> {set colWidthChoice 0}
    bind .colwidth.f1.width <Return> {
	set colWidthChoice 0 ; 
	if {[llength $cols_selected]!=0} {
	    for {set i [lindex $cols_selected 0]} {$i <= [lindex $cols_selected 1]} \
		{incr i} { doSetColWidth $colwidth $i }
	} else {doSetColWidth $colwidth}
    }
    grab .colwidth
}

proc doSetColWidth {wid {col -1}} {
    global activeCellCol activeSheet

    if {$col==-1} { set col $activeCellCol}

    SetColWidth $activeSheet $col $wid 
    [canvasFromSheet $activeSheet] yview scroll 1 units 
    [canvasFromSheet $activeSheet] yview scroll -1 units 
    redrawCanvas $activeSheet
}

proc setRowHeight {} {
    global activeCellRow activeSheet rowheight
    global rows_selected 

    toplevel .rowheight
    
    set rowheight [GetRowHeight $activeSheet $activeCellRow]

    if {[llength $rows_selected]!=0} {
	if {[lindex $rows_selected 0]>[lindex $rows_selected 1]} {
	    set tmp0 [lindex $rows_selected 0]
	    set tmp1 [lindex $rows_selected 1]
	    set rows_selected [lreplace $rows_selected 0 1 $tmp1 $tmp0]}
	set txt "New height for rows [expr [lindex $rows_selected 0]+1] until [expr [lindex $rows_selected 1]+1]"

    } else { set txt "New height for row [expr $activeCellRow +1]"}
    label .rowheight.label -text $txt

    entry .rowheight.width -textvar rowheight -bg white
    bind .rowheight.width <Return> {
	if {[llength $rows_selected]!=0} {
	    for {set i [lindex $rows_selected 0]} {$i <= [lindex $rows_selected 1]} \
		{incr i} {SetRowHeight $activeSheet $i $rowheight}
	} else { SetRowHeight $activeSheet $activeCellRow $rowheight}
	redrawCanvas $activeSheet
	[canvasFromSheet $activeSheet] yview scroll 1 units
	[canvasFromSheet $activeSheet] yview scroll -1 units
    }

    button .rowheight.ok -text Ok -command {destroy .rowheight}

    pack .rowheight.label .rowheight.width .rowheight.ok -fill x
    
    grab .rowheight
}


#
# The data menu
#

menu $mother.menu.tools.menu
$mother.menu.tools.menu add command -label "Sort" -command {SortCommand}
$mother.menu.tools.menu add cascade -label "Recalculation" \
    -menu $mother.menu.tools.menu.recalculate
$mother.menu.tools.menu add separator
$mother.menu.tools.menu add command -label "Run Script ..." \
    -command { fileSelection "Select Script" "*.tcl" "$activeSheet.tcl" ; \
		   if {[file exists $fileSelected]!=0} \
		   {RunScript $activeSheet $fileSelected }  }
$mother.menu.tools.menu add cascade -label "Edit Script" \
    -menu $mother.menu.tools.menu.script
$mother.menu.tools.menu add separator
$mother.menu.tools.menu add command \
    -label "Autosave ..."\
    -command { AutoSaveDlg }

menu $mother.menu.tools.menu.script
$mother.menu.tools.menu.script add command -label "New ..." \
    -command { if [info exists env(ABACUS_EDITOR)] \
		   { exec [split $env(ABACUS_EDITOR) !] &
		   } else {
		       HelpMessage "Please configure you environment variable ABACUS_EDITOR first" 1 1 } }
$mother.menu.tools.menu.script add command -label "Open ..." \
    -command { fileSelection "Select Script" "*.tcl" "$activeSheet.tcl" ; \
		   if {[file exists $fileSelected]!=0} {
		       if [info exists env(ABACUS_EDITOR)] \
			   { exec $env(ABACUS_EDITOR) $fileSelected &
			   } else {
			       HelpMessage "Please configure you environment variable ABACUS_EDITOR first" 1 1} } }

set recalcBeforeSaving 1
menu $mother.menu.tools.menu.recalculate \
        -postcommand {set calcMode [GetAutomaticRecalc $activeSheet] }
$mother.menu.tools.menu.recalculate add radiobutton -variable calcMode \
        -value 0 -label "Manual" \
        -command {SetAutomaticRecalc $activeSheet $calcMode}
$mother.menu.tools.menu.recalculate add radiobutton -variable calcMode \
        -value 255 -label "Automatic" \
        -command {SetAutomaticRecalc $activeSheet $calcMode}
$mother.menu.tools.menu.recalculate add separator 
$mother.menu.tools.menu.recalculate add checkbutton \
        -variable recalcBeforeSaving -label "Recalc before saving"\
        -command {RecalculateBeforeSaving $activeSheet $recalcBeforeSaving}
$mother.menu.tools.menu.recalculate add separator 
$mother.menu.tools.menu.recalculate add command \
    -label "Calculate Now" \
    -command {SheetRecalc $activeSheet}


#
# The graphs menu
#

menu $mother.menu.graphs.menu
$mother.menu.graphs.menu add command -label New -command {createGraph} 
#$mother.menu.graphs.menu add command -label Edit -command {editGraph} \
        -foreground {gray50}

$mother.menu.graphs.menu add command -label "Pick Graph" -command {getGraph}

$mother.menu.graphs.menu add separator 

$mother.menu.graphs.menu add command -label Delete -command {delGraph} \
       -state disabled

#
# The help menu
#

menu $mother.menu.help.menu
$mother.menu.help.menu add command -label "Help ..." \
    -command {AbacusHelp help}
$mother.menu.help.menu add separator 
$mother.menu.help.menu add command -label "Webpage" \
    -command { if [info exists env(ABACUS_BROWSER)] { 
	exec $env(ABACUS_BROWSER) http://www-cad.eecs.berkeley.edu/HomePages/aml/abacus/abacus.html &
    } else {
	HelpMessage "Please configure you environment variable ABACUS_BROWSER first" 1 1 } }
$mother.menu.help.menu add command -label "Search ..." \
    -command {AbacusHelp}
$mother.menu.help.menu add separator 
$mother.menu.help.menu add command -label "About ..." \
    -command {AbacusHelp about}

    pack $mother.menu.file $mother.menu.edit $mother.menu.view \
            $mother.menu.format $mother.menu.tools $mother.menu.graphs \
            -side left
    pack $mother.menu.help -side right
    pack $mother.menu -fill x -expand yes
}

#
# $Log: menubar.tcl,v $
# Revision 1.25  1998/10/25 22:24:33  cthulhu
# Added cut to edit menu.
#
# Revision 1.24  1998/10/25 22:11:09  cthulhu
# After an import we now highlight the active cell so entry is updated.
#
# Revision 1.23  1998/10/07 21:57:06  cthulhu
# Merged Paste with PasteSpecial - now single Paste command.
# Fixed bug in editPasteSpecial form.
# Weblink in help menu now points to Berkeley site instead of INESC.
#
# Revision 1.22  1998/10/01 22:19:31  cthulhu
# Fixed pastes calls.
#
# Revision 1.21  1998/09/30 00:39:26  cthulhu
# Added autosave.
# Graph/Edit is now Graph/Pick Graph.
#
# Revision 1.20  1998/08/25 20:59:23  cthulhu
# Data menu is now called tools and has an extra Run Macro option.
#
# Revision 1.19  1998/08/06 21:08:33  aml
# Released alpha version of Abacus.
#
# Revision 1.18  1997/03/27 10:00:37  aml
# Started implementing graphs.
# Fixed bug in tkCanvasPs.c
# Created bindings for composite characters in Portuguese.
#
# Revision 1.17  1997/02/10  15:10:05  aml
# Print settings now are saved to file.
# Fixed buggy error message when loading sheets.
#
# Revision 1.16  1997/01/07 01:07:41  aml
# Error propagation for formulas fixed.
# Edit operations in place.
#
# Revision 1.15  1996/12/31  17:38:37  aml
# On-demand calculation improved. Loops are detected.
# Automatic recalculation can now be disabled.
# Printing was improved.
#
# Revision 1.14  1996/12/11 21:39:57  aml
# Sumif implemented.
# Diverse time functions implemented.
# Fixed needtoscroll2 to avoid out of control scroll.
#
# Revision 1.13  1996/11/22 16:29:12  aml
# First cut at transforming canvas into a true cell widget.
# Text, lines and rectangles are now relative to row and colunm numbers.
# It still has a bug with wrong estimation of column widths.
#
# Revision 1.12  1996/10/09 13:55:03  aml
# First cut of full print.
#
# Revision 1.11  1996/09/19 12:17:01  aml
# Created row and column insert.
# Fixed small problem with display of vergrown cells.
#
# Revision 1.10  1996/09/16  18:42:17  aml
# Some performance problems addressed by reducing tag use.
# Several performance problems remain when heavy use is made
# of borders and shading in large spreadsheets.
#
# Revision 1.9  1996/09/15  19:24:21  aml
# Rulling and shading.
# Optionally hide cell borders.
# Works well, but is very slow for large spreadsheets.
#
# Revision 1.8  1996/09/02  10:51:14  aml
# Cell fonts created, loaded and saved.
# Row height created.
#
# Revision 1.7  1996/04/27  11:12:33  aml
# Inserted check and delete button.
# Font selection widget created.
# Fixed bug canvas_information destructor.
#
# Revision 1.6  1996/03/07  20:32:56  aml
# Created print range ability.
# Set in gray non-working menus.
# Created RangeKill command.
# Created round function and macros for single argument functions.
#
# Revision 1.5  1996/02/19  15:47:34  aml
# Fixed abnormality with mouse click.
# Variable width columns implemented, but not yet saved.
# Labels are now a lex element, fixing some aberrant behavior that existed.
#
# Revision 1.4  1996/01/09 18:34:48  aml
# Load, save, open, close and exit now work properly (hopefuly).
# Sheet utility functions also work : SheetExists, SheetEmpty, SheetModified
#
# Revision 1.3  1996/01/07  09:07:31  aml
# Sheet::save and Sheet::load created.
# Program can now write and read wk1 files.
# Slight changes made to relative references. Bit 14 is now always 0.
#
# Revision 1.2  1995/11/08  22:24:54  aml
# Added call to new
#
# Revision 1.1  1995/11/08  22:08:54  aml
# Initial revision
#
#