!{\src2tex{textfont=tt}}
!!****f* ABINIT/rdlda
!! NAME
!! rdlda
!!
!! FUNCTION
!! Read QPLDA type file
!! This file format is superceded by _KSS files. This is the reason why
!! the description of input/output is not up to date
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!! iunit=unit file number
!! nopx: maximum number of symmetry operations, i.e. dimension of op
!! nbx: maximum number of bands, i.e. dimension of en, occ, wf
!! nkx: maximum number of k-points in IBZ, i.e. dim. of kvec, en, occ, wf
!! ngx: maximum number of G-vectors in calculation, i.e. dim. of gvec, wf
!! nwx: maximum number of plane-waves to be used for wave-functions
!!
!! OUTPUT
!! tit: 2*80-character description of LDA input file
!! i*: flags
!! a1, a2, a3: real-space lattice vectors in au
!! b1, b2, b3: reciprocal-space lattice vectors in au**-1
!! ucvol: unit cell volume in au**3
!! bzvol: reciprocal cell volume
!! op: symmetry operation matrices
!! gvec: RL vectors G
!! kibz: k-points in IBZ
!! en: LDA energies (Hartrees)
!! occ: occupations of bands (2.0=full)
!! wf: LDA wave functions (G) in plane wave order [Norm:|vector|=1]
!! n*r: number of*read from file
!! if nb<nbx then nbr=nb else nbr=nbx
!! if ng<ngx then ngr=ng else ngr=ngx
!! if ng<nwx then nwr=ng else nwr=nwx
!! if nop<nopx then nopr=nop else nopr=nopx
!! nop: number of symmetry operations contained in file
!! nb: number of bands contained in file
!! nk: number of k-points in IBZ contained in file
!! ng: number of G-vectors in calculation contained in file

!! **if nk<nkx then nkr=nk else ERROR**:
!!  due to the structure of LDA file with regard of energies and
!!  occupations, (all energies/occupations in one record) it is
!!  impossible to read nkx less than nk elements; implicit do in
!!  those sections is not synctactically correct and explicit do
!!  doesn''t go as look for EOR at each loop.
!! check the return value of nop, nb, ng to see how many elements
!! were loaded
!!
!! SIDE EFFECTS
!!  i1= (to be described)
!!
!! TODO
!! Follow abinit rules, including allocate instead of automatic arrays
!!
!! PARENTS
!!      screening,sigma
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine rdlda(iunit,nopx,nbx,nkx,ngx,nwx,nop,nb,nk,ng,tit,i1,i2,i3,&
& a1,a2,a3,op,gvec,kibz,en,occ,wf)

 use defs_basis

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: iunit,nbx,ngx,nkx,nopx,nwx
 integer,intent(inout) :: i1
 integer,intent(out) :: i2,i3,nb,ng,nk,nop
!arrays
 integer,intent(out) :: gvec(3,ngx)
 real(dp),intent(out) :: a1(3),a2(3),a3(3),en(nkx,nbx),kibz(3,nkx),occ(nkx,nbx)
 real(dp),intent(out) :: op(3,3,nopx)
 complex,intent(out) :: wf(nwx,nbx,nkx)
 character(len=80),intent(out) :: tit(2)

!Local variables-------------------------------
!scalars
 integer :: i,i10,i11,i12,i13,i14,i15,i16,i4,i5,i6,i7,i8,i9,ib,ibp,idum,ig,ik
 integer :: isym,isymend,isymin,j,k,nbr,nbw,ngr,nkr,nopr,nwr
 real(dp) :: bzvol,cinf,csup,einf,esup,sum,ucvol
 complex :: cdum
 logical,parameter :: debug=.false.,verbose=.true.
 logical :: form
!arrays
 real(dp) :: b1(3),b2(3),b3(3)
!no_abirules
!temporary variables introduced by GMR for SP-DP compatibility
 real :: a1_sp(3),a2_sp(3),a3_sp(3)
 real :: op_sp(3,3,nopx)
 real :: kibz_sp(3,nkx)
 real :: en_sp(nkx,nbx)
 real :: occ_sp(nkx,nbx)
 real :: dum

! *************************************************************************

!i1=0->file formatted->FORM=.TRUE.
!i1!=0->file unformatted->FORM=.FALSE.
 if(i1==0) then
   form=.true.
 else
   form=.false.
 end if


 if(form) then
   write (*,*) 'opening LDA input file formatted unit ',iunit
   open (iunit,status='unknown',form='formatted')
 else
   write (*,*) 'opening LDA input file unformatted unit ',iunit
!  open (iunit,status='unknown',form='unformatted')
   rewind(iunit)
! ******TEMP Add recl for FPS unformatted file
!  open (iunit, status='unknown',form='UNFORMATTED',RECL=500000)
! ******
 end if


 write (*,*) 'reading title of file:'
 if(form) then
   read (iunit,'(a80,/,a80)') tit(1),tit(2)
 else
   read (iunit) tit(1)
   read (iunit) tit(2)
 end if

 write (6,'(1x,a80,/,1x,a80)') tit(1),tit(2)
 write (*,*)


!Flags used so far:
!i1=0 if QPLDA file is formatted, 1 if unformatted
!i2=0 if RWG format, 1 if BF format
!i3=1 if non-symmorphic operations (+vectors) included, otherwise 0

 write (*,*) 'reading flags'

 if(form) then
   read (iunit,'(16i5)') i1,i2,i3,i4,i5,i6,i7,i8,i9,i10,i11,i12,i13,i14,i15,i16
 else
   read (iunit) i1,i2,i3,i4,i5,i6,i7,i8,i9,i10,i11,i12,i13,i14,i15,i16
 end if

!check that flag i1 is consistent with value of FORM assumed
 if((form).and.(i1/=0)) then
   write (*,*)&
&  'error rdlda 1: input file unformatted read as formatted.'
   stop
 end if
 if((.not.form).and.(i1/=1)) then
   write (*,*)&
&  'error rdlda 2: input file formatted read as unformatted.'
   stop
 end if

 if(debug)&
& write (6,'(16i4)') i1,i2,i3,i4,i5,i6,i7,i8,i9,i10,i11,i12,i13,i14,i15,i16
 write (*,*)


 write (*,*) 'reading real-space lattice vectors'

 if(form) then
   read (iunit,'(3e26.18)') a1_sp,a2_sp,a3_sp
 else
   read (iunit) a1_sp,a2_sp,a3_sp
 end if
 a1(:)=a1_sp(:)
 a2(:)=a2_sp(:)
 a3(:)=a3_sp(:)

 if(verbose) then
!  calculate Brillouin zone and Unit cell volumes
   ucvol=a1(1)*(a2(2)*a3(3)-a2(3)*a3(2))&
&  +a1(2)*(a2(3)*a3(1)-a2(1)*a3(3))+a1(3)*(a2(1)*a3(2)-a2(2)*a3(1))
   bzvol=8*pi*pi*pi/ucvol

!  calculate reciprocal-space lattice vectors b1-b3
   b1(1)=2.0*pi*(a2(2)*a3(3)-a2(3)*a3(2))/ucvol
   b1(2)=2.0*pi*(a2(3)*a3(1)-a2(1)*a3(3))/ucvol
   b1(3)=2.0*pi*(a2(1)*a3(2)-a2(2)*a3(1))/ucvol
   b2(1)=2.0*pi*(a3(2)*a1(3)-a3(3)*a1(2))/ucvol
   b2(2)=2.0*pi*(a3(3)*a1(1)-a3(1)*a1(3))/ucvol
   b2(3)=2.0*pi*(a3(1)*a1(2)-a3(2)*a1(1))/ucvol
   b3(1)=2.0*pi*(a1(2)*a2(3)-a1(3)*a2(2))/ucvol
   b3(2)=2.0*pi*(a1(3)*a2(1)-a1(1)*a2(3))/ucvol
   b3(3)=2.0*pi*(a1(1)*a2(2)-a1(2)*a2(1))/ucvol

!  tol10 enhance the portability
   write (6,'(a,/,(5x,3f12.6))')&
&   ' real-space lattice vectors in cartesians [au]:',a1+tol10,a2+tol10,a3+tol10
   write (6,'(/,a,/,(5x,3f12.6))')&
&   ' calculated reciprocal lattice vectors in cartesians [au]:',b1,b2,b3
   write (6,'(2(/,a,f12.6,a))')&
&   ' brillouin zone volume = ',bzvol,' [au]',&
&   ' unit cell volume      = ',ucvol+tol10,' [au]'
 end if
 write (*,*)


!read symmetry operations (real-space-lattice units) and CONVERT
!to reciprocal-lattice units   [nop+1 lines]
![Note: if R is the matrix in lattice units, then the corresponding
!matrix in RL units is transpose(R**-1).  But since the set of
!operations contains inverse pairs, we only need to tranpose
!the matrices.  Thus op(J,I) rather than op(I,J).]

 write (*,*) 'reading symmetry operations'

 if(form) then
   read (iunit,'(i12)') nop
 else
   read (iunit) nop
 end if

 write (*,*) 'number of translationless symmetry operations',nop

 if(nop<=nopx) then
   nopr=nop
 else
   write (*,*) 'warning rdlda 3: reading only a number of ',&
&  'symmetry operations ',nopx
   nopr=nopx
 end if

 if(nop<=nopx) then
   if(form) then
     read (iunit,'(3e26.18)') (((op_sp(j,i,k),i=1,3),j=1,3),k=1,nop)
   else
     read (iunit) (((op_sp(j,i,k),i=1,3),j=1,3),k=1,nop)
   end if
 else
   if(form) then
     read (iunit,'(3e26.18)') (((op_sp(j,i,k),i=1,3),j=1,3),k=1,nopx),&
&     (((dum,i=1,3),j=1,3),k=nopx+1,nop)
   else
     read (iunit) (((op_sp(j,i,k),i=1,3),j=1,3),k=1,nopx),&
&     (((dum,i=1,3),j=1,3),k=nopx+1,nop)
   end if
 end if
 op(:,:,:)=op_sp(:,:,:)

 if(verbose) then
   write(*,*) 'symmetry operations [reciprocal lattice units]:'
   do isymin=1,nopr,3
     isymend=isymin+2
     if(isymend>nopr) isymend=nopr
     do i=1,3
       write(6,'(2(3f8.4,4x),3f8.4)')&
&       ((op(i,j,isym),j=1,3),isym=isymin,isymend)
     end do
     write(*,*)
   end do
   write(*,*)
 end if


 if(i3==1) then
!  read (iunit,'(3e26.18)') ((voffset(i,j),i=1,3),j=1,nop)
   write (*,*) 'error rdlda 4:      program is not able to handle',&
&   'non-symorphic translation vectors; run cnvnsy first or check i3'
   stop
 end if


 write (*,*) 'reading reciprocal lattice vectors'
!ie in the basis of the reciprocal lattice basis vectors

 if(form) then
   read (iunit,'(i12)') ng
 else
   read (iunit) ng
 end if

 write (*,*) 'number of G vectors found, i.e. of plane waves ',ng

 if(ng<=ngx) then
   ngr=ng
 else
   ngr=ngx
 end if
 write (*,*) 'reading a number of G vectors ',ngr

 if(ng<=ngx) then
   if(form) then
     read (iunit,'(3i5)') ((gvec(i,ig),i=1,3),ig=1,ng)
   else
     read (iunit) ((gvec(i,ig),i=1,3),ig=1,ng)
   end if
 else
   if(form) then
     read (iunit,'(3i5)') ((gvec(i,ig),i=1,3),ig=1,ngx),&
&     ((idum,i=1,3),ig=ngx+1,ng)
   else
     read (iunit) ((gvec(i,ig),i=1,3),ig=1,ngx),&
&     ((idum,i=1,3),ig=ngx+1,ng)
   end if
 end if

 if(verbose) write(6,'(a,/,5(i5,a,3i3))')&
& ' G vectors [reciprocal lattice units]:',(ig,':',(gvec(i,ig),i=1,3),ig=1,ngr)
 write (*,*)


 write (*,*) 'reading k-points'

 if(form) then
   read (iunit,'(i12)') nk
 else
   read (iunit) nk
 end if

 write (*,*) 'number of k-points ',nk

 if(nk<=nkx) then
   nkr=nk
 else
   nkr=nkx
   write (*,*)
   write (*,*) '**error rdlda 5: ',&
&   'k dimension of vectors initialized at ',nkx
   write (*,*) '                  increase the dimension at ',nk
   stop
 end if

 if(nk<=nkx) then
   if(form) then
     read (iunit,'(3e26.18)') ((kibz_sp(i,ik),i=1,3),ik=1,nk)
   else
     read (iunit) ((kibz_sp(i,ik),i=1,3),ik=1,nk)
   end if
 else
   if(form) then
     read (iunit,'(3e26.18)') ((kibz_sp(i,ik),i=1,3),ik=1,nkx),&
&     ((dum,i=1,3),ik=nkx+1,nk)
   else
     read (iunit) ((kibz_sp(i,ik),i=1,3),ik=1,nkx),&
&     ((dum,i=1,3),ik=nkx+1,nk)
   end if
 end if
 kibz(:,:)=kibz_sp(:,:)

 if(verbose) write (6,'(a,/,(i5,3f12.6))')&
& ' k-points [reciprocal lattice units]:',(ik,(kibz(i,ik),i=1,3),ik=1,nkr)
 write (*,*)


 write (*,*) 'reading energies'

 if(form) then
   read (iunit,'(i12)') nb
 else
   read (iunit) nb
 end if

 write (*,*) 'number of bands found ',nb

 if(nb<=nbx) then
   nbr=nb
 else
   nbr=nbx
 end if
 write (*,*) 'reading a number of bands ',nbr

 if(nb<=nbx) then
   if(nk<=nkx) then
     if(form) then
       read (iunit,'(3e26.18)') ((en_sp(ik,ib),ik=1,nk),ib=1,nb)
     else
       read (iunit) ((en_sp(ik,ib),ik=1,nk),ib=1,nb)
     end if
   else
     if(form) then
       do ib=1,nb
         read (iunit,'(3e26.18)') (en_sp(ik,ib),ik=1,nkx),(dum,ik=nkx+1,nk)
       end do
     else
       do ib=1,nb
         read (iunit) (en_sp(ik,ib),ik=1,nkx),(dum,ik=nkx+1,nk)
       end do
     end if
   end if
 else
   if(nk<=nkx) then
     if(form) then
       read (iunit,'(3e26.18)') ((en_sp(ik,ib),ik=1,nk),ib=1,nbx),&
&       ((dum,ik=1,nk),ib=nbx+1,nb)
     else
       read (iunit) ((en_sp(ik,ib),ik=1,nk),ib=1,nbx),&
&       ((dum,ik=1,nk),ib=nbx+1,nb)
     end if
   else
     if(form) then
       do ib=1,nbx
         read (iunit,'(3e26.18)') (en_sp(ik,ib),ik=1,nkx),(dum,ik=nkx+1,nk)
       end do
       do ib=nbx+1,nb
         read (iunit,'(3e26.18)') (dum,ik=1,nk)
       end do
     else
       do ib=1,nbx
         read (iunit) (en_sp(ik,ib),ik=1,nkx),(dum,ik=nkx+1,nk)
       end do
       do ib=nbx+1,nb
         read (iunit) (dum,ik=1,nk)
       end do
     end if
   end if
 end if
 en(:,:)=en_sp(:,:)

 write (*,*)


 write (*,*) 'reading numbers of occupation'
 if(nb<=nbx) then
   if(nk<=nkx) then
     if(form) then
       read (iunit,'(3e26.18)') ((occ_sp(ik,ib),ik=1,nk),ib=1,nb)
     else
       read (iunit) ((occ_sp(ik,ib),ik=1,nk),ib=1,nb)
     end if
   else
     if(form) then
       do ib=1,nb
         read (iunit,'(3e26.18)') (occ_sp(ik,ib),ik=1,nkx),(dum,ik=nkx+1,nk)
       end do
     else
       do ib=1,nb
         read (iunit) (occ_sp(ik,ib),ik=1,nkx),(dum,ik=nkx+1,nk)
       end do
     end if
   end if
 else
   if(nk<=nkx) then
     if(form) then
       read (iunit,'(3e26.18)') ((occ_sp(ik,ib),ik=1,nk),ib=1,nbx),&
&       ((dum,ik=1,nk),ib=nbx+1,nb)
     else
       read (iunit) ((occ_sp(ik,ib),ik=1,nk),ib=1,nbx),&
&       ((dum,ik=1,nk),ib=nbx+1,nb)
     end if
   else
     if(form) then
       do ib=1,nbx
         read (iunit,'(3e26.18)') (occ_sp(ik,ib),ik=1,nkx),(dum,ik=nkx+1,nk)
       end do
       do ib=nbx+1,nb
         read (iunit,'(3e26.18)') (dum,ik=1,nk)
       end do
     else
       do ib=1,nbx
         read (iunit) (occ_sp(ik,ib),ik=1,nkx),(dum,ik=nkx+1,nk)
       end do
       do ib=nbx+1,nb
         read (iunit) (dum,ik=1,nk)
       end do
     end if
   end if
 end if
 occ(:,:)=occ_sp(:,:)

 write (*,*)

 if(verbose) then
   nbw=15
   if(nbr<nbw) nbw=nbr
   do ik=1,nkr
!    write (6,'(/,a,i5,a,/,(5f12.6))')&
!&    ' eigenvalues for k-point',ik,' [Ha]:',(en(ik,ib),ib=1,nbw)
     write (6,'(/,a,i5,a,/,(5f12.6))')&
&     ' eigenvalues for k-point',ik,' [eV]:',(Ha_eV*en(ik,ib),ib=1,nbw)
     write (6,'(/,a,i5,a,/,(5f12.6))')&
&     ' occupations for k-point',ik,':',(occ(ik,ib),ib=1,nbw)
   end do
   write (*,*)
 end if

!reading wavefunctions
!(a(G), normalised to 1) and write to scratch file
!test on the normalization and orthgonalization
 einf=10e+24
 esup=-1.0
 cinf=10e+24
 csup=-1.0

 write (*,*) 'reading wavefunctions'

 if(ng<=nwx) then
   nwr=ng
 else
   nwr=nwx
 end if
 write(*,*) 'reading a number of plane-waves ',nwr

 do ik=1,nkr
   if(nb<=nbx) then
     do ib=1,nb
       if(ng<=nwx) then
         if(form) then
           read (iunit,'(3e26.18)') (wf(ig,ib,ik),ig=1,ng)
         else
           read (iunit) (wf(ig,ib,ik),ig=1,ng)
         end if
       else
         if(form) then
           read (iunit,'(3e26.18)') (wf(ig,ib,ik),ig=1,nwx),(cdum,ig=nwx+1,ng)
         else
           read (iunit) (wf(ig,ib,ik),ig=1,nwx),(cdum,ig=nwx+1,ng)
         end if
       end if
     end do
   else
     do ib=1,nbx
       if(ng<=nwx) then
         if(form) then
           read (iunit,'(3e26.18)') (wf(ig,ib,ik),ig=1,ng)
         else
           read (iunit) (wf(ig,ib,ik),ig=1,ng)
         end if
       else
         if(form) then
           read (iunit,'(3e26.18)') (wf(ig,ib,ik),ig=1,nwx),(cdum,ig=nwx+1,ng)
         else
           read (iunit) (wf(ig,ib,ik),ig=1,nwx),(cdum,ig=nwx+1,ng)
         end if
       end if
     end do
     do ib=nbx+1,nb
       if(form) then
         read (iunit,'(3e26.18)') (cdum,ig=1,ng)
       else
         read (iunit) (cdum,ig=1,ng)
       end if
     end do
   end if
 end do


 if(debug) then
   write (6,'(a,5f12.6)') ' wavefunction sample ',wf(1,1,1),wf(2,1,1)
   write (6,'(a,5f12.6)') ' wavefunction sample ',wf(1,2,1),wf(2,2,1)
 end if

 write(*,*) 'test on the normalization of the wavefunctions'

 do ik=1,nkr
   do ib=1,nbr
     sum=0.0
     do ig=1,nwr
       sum=sum+conjg(wf(ig,ib,ik))*wf(ig,ib,ik)
     end do
     if(sum<einf) einf=sum
     if(sum>esup) esup=sum
   end do
!  test on the orthogonalization of wavefunctions
   do ib=1,nbr
     do ibp=ib+1,nbr
       cdum=0.0
       do ig=1,nwx
         cdum=cdum+conjg(wf(ig,ib,ik))*wf(ig,ibp,ik)
       end do
       if(abs(cdum)<cinf) cinf=abs(cdum)
       if(abs(cdum)>csup) csup=abs(cdum)
     end do
   end do
 end do

 write(6,'(a,f9.6,/,a,f9.6)')&
& ' min sum_G |a(n,k,G)| = ',einf,&
& ' max sum_G |a(n,k,G)| = ',esup
 write(*,*) 'test on the orthogonalization of the wavefunctions'
 write(6,'(a,f9.6,/,a,f9.6)')&
& ' min sum_G a(n,k,G)* a(n",k,G) = ',cinf,&
& ' max sum_G a(n,k,G)* a(n",k,G) = ',csup
 write (*,*)


 write (*,*) 'closing file'
!close (iunit)
 write (*,*)

end subroutine rdlda
!!***
