/**
 * @author Johnny Willemsen <jwillemsen@remedy.nl>
 *
 * $Id: SubscriberQos.h 89223 2010-02-25 08:32:11Z msmit $
 *
 * Wrapper facade for NDDS.
 */

#ifndef DDS4CCM_SUBSCRIBERQOS_H
#define DDS4CCM_SUBSCRIBERQOS_H

#include "EntityFactoryQosPolicy.h"
#include "GroupDataQosPolicy.h"
#include "PartitionQosPolicy.h"
#include "PresentationQosPolicy.h"

#if defined (CIAO_DDS4CCM_OPENDDS) && (CIAO_DDS4CCM_OPENDDS==1)
typedef ::DDS::SubscriberQos DDS_SubscriberQos;
#endif

#if defined (CIAO_DDS4CCM_NDDS) && (CIAO_DDS4CCM_NDDS==1)
inline void
operator<<= (::DDS::SubscriberQos &ddsqos, const ::DDS_SubscriberQos & qos)
{
  ddsqos.presentation <<= qos.presentation;
  ddsqos.partition <<= qos.partition;
  ddsqos.group_data <<= qos.group_data;
  ddsqos.entity_factory <<= qos.entity_factory;
}

inline void
operator<<= (::DDS_SubscriberQos &ddsqos, const ::DDS::SubscriberQos & qos)
{
  ddsqos.presentation <<= qos.presentation;
  ddsqos.partition <<= qos.partition;
  ddsqos.group_data <<= qos.group_data;
  ddsqos.entity_factory <<= qos.entity_factory;
}

inline void
operator>>= (const ::DDS_SubscriberQos &qos, ::DDS::SubscriberQos & ddsqos)
{
  ddsqos.presentation <<= qos.presentation;
  ddsqos.partition <<= qos.partition;
  ddsqos.group_data <<= qos.group_data;
  ddsqos.entity_factory <<= qos.entity_factory;
}

inline void
operator>>= (const ::DDS::SubscriberQos &qos, ::DDS_SubscriberQos & ddsqos)
{
  ddsqos.presentation <<= qos.presentation;
  ddsqos.partition <<= qos.partition;
  ddsqos.group_data <<= qos.group_data;
  ddsqos.entity_factory <<= qos.entity_factory;
}
#endif

#endif /* DDS4CCM_SUBSCRIBERQOS_H */
