//This file is part of AcetoneISO. Copyright 2006,2007,2008,2009,2010 Marco Di Antonio and Fabrizio Di Marco (acetoneiso@gmail.com)
//
//    AcetoneISO is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    AcetoneISO is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with AcetoneISO.  If not, see <http://www.gnu.org/licenses/>. 


void acetoneiso::foldertoiso() {
  QFile mkisofs;
  mkisofs.setFileName("/usr/bin/genisoimage");
  QDir Home = QDir::home();
  QFile file(Home.path() + "/.acetoneiso/acetoneiso.conf");
  file.open(QIODevice::ReadOnly);//lo apro in sola lettura
  QString str1 = (leggiRigo( 1, &file ));
  file.close();
  
  if (!mkisofs.exists()) {
    QMessageBox::warning(this, "AcetoneISO::Warning!",tr("no genisoimage found in /usr/bin"));
    return;
  }

  QString folder = QFileDialog::getExistingDirectory(this, tr("AcetoneISO::Select Folder to be Converted"), Home.path());
  if (folder.isEmpty() ) {
    return;
  }

  QDir fol (folder);
  QString iso;
  iso = fol.dirName();

  QString fileName = QFileDialog::getSaveFileName(this, tr("AcetoneISO::Save ISO"), Home.path() , tr("Images (*.iso)"));

  if ( fileName.isNull() ) {
    return;
  }

  if (str1.contains("standard", Qt::CaseInsensitive)) {
		  
    showProgressDisplay();
    MKisofs = new QProcess();
    MKisofs->setReadChannel(QProcess::StandardOutput);
    MKisofs->setProcessChannelMode(QProcess::MergedChannels);
    connect(MKisofs, SIGNAL(readyReadStandardOutput()), SLOT(updateProgressDisplay_MKisofs() )); 
    connect(MKisofs, SIGNAL(finished(int, QProcess::ExitStatus)), this, SLOT(printOut(int, QProcess::ExitStatus)));
    MKisofs->start("genisoimage",QStringList() << "-R" << "-J" << "-o" << fileName << folder  );
  }
  else {	
    bool ok;
    QString text = QInputDialog::getText(this, tr("ISO ID"), tr("Please insert an ID for the ISO"), QLineEdit::Normal, tr(""), &ok);

    if (!ok){
      return;
    }
  
    showProgressDisplay();
    MKisofs = new QProcess();
    MKisofs->setReadChannel(QProcess::StandardOutput);
    MKisofs->setProcessChannelMode(QProcess::MergedChannels);
    connect(MKisofs, SIGNAL(readyReadStandardOutput()), SLOT(updateProgressDisplay_MKisofs() )); 
    connect(MKisofs, SIGNAL(finished(int, QProcess::ExitStatus)), this, SLOT(printOut(int, QProcess::ExitStatus)));
    MKisofs->start("genisoimage",QStringList()  << "-R" << "-J" << "-V" << text << "-o" << fileName << folder  );

  }

  file.close();
  
}


