; watch.lisp
; Copyright (C) 2013, Regents of the University of Texas
; License: A 3-clause BSD license.  See the LICENSE file distributed with ACL2.

; This version of ACL2 is a descendent of ACL2 Version 1.9, Copyright
; (C) 1997 Computational Logic, Inc.  See the documentation topic NOTE-2-0.

; This file was originally part of the HONS version of ACL2.  The original
; version of ACL2(h) was contributed by Bob Boyer and Warren A. Hunt, Jr.  The
; design of this system of Hash CONS, function memoization, and fast
; association lists (applicative hash tables) was initially implemented by
; Boyer and Hunt.

(in-package "ACL2")

(include-book "tools/include-raw" :dir :system)

; cert_param: (hons-only)

; [Jared]: I pulled the WATCH related functionality out of ACL2(h) and into
; this ttag-based book.  In the process I ripped out the previous if-profiling
; stuff, which made it much easier to disentangle watch from memoize.

; WARNING: We never use WATCH anymore.  We do not know if or how it works.  It
; is very likely that this code will not work correctly.

(defttag :watch)

; Originally we had this:

; (include-raw "output-raw.lsp")

; But profile.lisp has that form, too, and we have see compilation fail (using
; ANSI GCL) when parallel `make' was causing the file to be compiled twice in
; parallel.  So we avoid this double-compilation by including profile.lisp
; instead.

(include-book "profile")

(include-raw "watch-raw.lsp")

