#!/bin/bash

BRIGHTNESS=$(cat /proc/acpi/sony/brightness)

if [ "$BRIGHTNESS" -gt 8 ]; then
	BRIGHTNESS=1
fi

if [ "x$1" = "xdown" ]; then
   if [ "x$BRIGHTNESS" != "x1" ]; then
      BRIGHTNESS=$(( $BRIGHTNESS - 1 ))
      echo $BRIGHTNESS > /proc/acpi/sony/brightness
   else
      [ -x /usr/bin/spicctrl ] && /usr/bin/spicctrl -b 0   
   fi
   # Recent nvidia Sonys have ACPI methods that do nothing. Thanks, Sony.
   [ -x /usr/bin/smartdimmer ] && smartdimmer -d 2>/dev/null
elif [ "x$1" = "xup" ]; then
   if [ "x$BRIGHTNESS" != "x8" ]; then
      BRIGHTNESS=$(( $BRIGHTNESS + 1 ))
      echo $BRIGHTNESS > /proc/acpi/sony/brightness
   fi
   [ -x /usr/bin/smartdimmer ] && smartdimmer -i 2>/dev/null
else
   echo >&2 Unknown argument $1
fi
