/*****************************************************************
/
/ File   :   AdmHndlr.h
/ Author :   David Corcoran
/ Date   :   October 15, 1999
/ Purpose:   This handles administrative functions like reset/power.
/            See http://www.linuxnet.com for more information.
/ License:   See file LICENSE
/
******************************************************************/

#ifndef __AdmHndlr_h__
#define __AdmHndlr_h__

#define ADM_PORT_COM1    0x0001
#define ADM_PORT_COM2    0x0002
#define ADM_PORT_COM3    0x0004
#define ADM_PORT_COM4    0x0008
#define ADM_PORT_USB     0x0010

#define ADM_CARDTYPE_T0  0x0C
#define ADM_CARDTYPE_T1  0x0D

#define ADM_NOTIFY_TRUE  0x01
#define ADM_NOTIFY_FALSE 0x02
#define ADM_BULK_IN_LEN    64

#define ADM_OPTION_EMV_OFF		0x00
#define ADM_OPTION_EMV_ON		0x10
#define ADM_OPTION_MEMCARD_OFF	0x00
#define ADM_OPTION_MEMCARD_ON	0x20

ULONG Adm_Initialize( char*, DWORD, DWORD);
ULONG Adm_UnInitialize( DWORD );
ULONG Adm_PowerICC( DWORD, PUCHAR, PULONG );
ULONG Adm_ResetICC( DWORD, PUCHAR, PULONG );
ULONG Adm_SetNotification( DWORD, UCHAR ); 
ULONG Adm_Transmit( DWORD, PUCHAR, ULONG, PUCHAR, PULONG );
ULONG Adm_SetWWT( DWORD, ULONG );
ULONG Adm_GetAcrStats( DWORD Lun, PUCHAR pucStatus );
ULONG Adm_UnPowerICC( DWORD );
ULONG Adm_IsICCPresent( DWORD );
ULONG Adm_SelectCard( DWORD, ULONG );
ULONG Adm_Select442818( DWORD, PUCHAR, PULONG );
UCHAR Adm_CheckSum( PUCHAR, ULONG );
ULONG Adm_ReadData( DWORD, ULONG, PUCHAR, ULONG );
ULONG Adm_WriteData( DWORD, ULONG, PUCHAR, ULONG );
ULONG Adm_WriteProtection( DWORD, ULONG, PUCHAR, ULONG );
ULONG Adm_PresentCode( DWORD, PUCHAR );

ULONG
Adm_SetCardPPS(	DWORD	lun,
				UCHAR	protocol,
				UCHAR	fl,
				UCHAR	dl,
				PUCHAR	pResultPPS,
				PULONG	pResultPPSLen);

ULONG
Adm_SetReaderPPS(	DWORD	lun,
					PUCHAR	pPPS,
					ULONG	ppsLen);

ULONG
Adm_DoPPSExchange(	DWORD	lun,
					PUCHAR	pPPS,
					ULONG	ppsLen);

ULONG
Adm_DoPPSExchangeATR(	DWORD	lun,
						PUCHAR	pATR,
						ULONG	atrLen);

int	/* 1 -- Support, 0 -- Not Support */
Adm_SupportPPS(	UCHAR	fl,
				UCHAR	dl);

UCHAR
Adm_GetMaxSupportFl();

UCHAR
Adm_GetMaxSupportDl();

ULONG
Adm_SetOption(DWORD, UCHAR);

ULONG
Adm_Control(DWORD, PUCHAR, DWORD, PUCHAR, PDWORD);

#endif
