#
# Module:     BKDInit.pm   
# Date:       03/05/04   
# Version:    1.3   
# Edited by:  teon@teon.org   
# Description:   
# 
#  This is a plugin, which allows you to manage configuration of BKD-Init
#  script (BitKeeper init.d script for Debian).
#   
# License:   
#  
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License Version 2 as
#  published by the Free Software Foundation.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
#  USA.
#
# This file is part of adduser-ng program.
# 
# Copyright (C) 2003-2004 Bartosz Oler <liar@bzimage.us>
# Copyright (C) 2003-2004 Robert Olejnik <teon@teon.org>
#

package AddUser::plugins::BKDInit;

use strict;
use AddUser::StdLib;

my $_PLUGIN = 'BKDInit';
my $_APIVERSION = 0x1;


sub new {
	my ($c, %args) = @_;
	my $class = ref($c) || $c;

	$args{opts} = {
			'bkdinit_config' => '/etc/default/bkd',
			'bkdinit_path' => '/etc/init.d/bkd',
                        'repository_name' => '',
			'repository_path' => '',
			'port' => '14690',
			'uid' => '',
			'gid' => '',
			'bkd_log_file' => '',
			'bkd_exclude_commands' => '',
			'bkd_print_headers' => 'no',
			'bkd_debug_mode' => 'no',
			'bkd_jail' => 'yes',
			'clone_repository_from' => '',
			'setup_new_repository' => 'no',
			'bk_path' => '/usr/local/bin/bk',
			'restart_bkdinit' => 'yes',
                        };

        $args{APIVERSION} = $_APIVERSION;
        $args{NAME} = $_PLUGIN;

	bless \%args, $class;
}



#
# this is the configuration part of the plugin
#
sub configure {
	my $self     = shift;
        my $conf     = $self->{plugins_options}{GroupConfig};
        my $ui       = $self->{plugins_options}{UI};
        my $verbose  = $self->{plugins_options}{verbose};
        my $keywords = $self->{plugins_options}{keywords};
	my $docs     = &get_documentation($self->{plugins_options}{documentation_dir}, $_PLUGIN);

	$self->{plugins_options}{docs} = $docs->{options}{option};
	$ui->display("$_PLUGIN", $docs->{description}."\n") if $verbose;

        while (!wrapper_getlong($self, $_PLUGIN, 'bkdinit_config')) {};
        while (!wrapper_getlong($self, $_PLUGIN, 'bkdinit_path')) {};
	wrapper_getlong($self, $_PLUGIN, 'repository_name');
	wrapper_getlong($self, $_PLUGIN, 'repository_path');
	wrapper_getlong($self, $_PLUGIN, 'port');
	wrapper_getlong($self, $_PLUGIN, 'uid');
	wrapper_getlong($self, $_PLUGIN, 'gid');
	wrapper_getlong($self, $_PLUGIN, 'bkd_log_file');
	wrapper_getlong($self, $_PLUGIN, 'bkd_exclude_commands');
	wrapper_getsingle($self, $_PLUGIN, 'bkd_print_headers', ('no', 'yes'));
	wrapper_getsingle($self, $_PLUGIN, 'bkd_debug_mode', ('no', 'yes'));
	wrapper_getsingle($self, $_PLUGIN, 'bkd_jail', ('no', 'yes'));
	wrapper_getlong($self, $_PLUGIN, 'clone_repository_from');
	if (! $self->{opts}{clone_repository_from}) {
		wrapper_getlong($self, $_PLUGIN, 'setup_new_repository');
	}
	if ($self->{opts}{clone_repository_from} or $self->{opts}{setup_new_repository}) {
		while (!wrapper_getlong($self, $_PLUGIN, 'bk_path')) {};
	}
	wrapper_getsingle($self, $_PLUGIN, 'restart_bkdinit', ('yes', 'no'));

	open(FH, '<', $self->{opts}{bkdinit_config}) || return $ERRNO{'ERROR'};
	if (scalar(grep {/^$self->{opts}{repository_name}:$self->{opts}{repository_path}:/} <FH>)) {
		close FH;
		return $ERRNO{'DONE'};
	}
	close FH;

	return $ERRNO{'OK'};
}



#
# when the plugin is configured, it can do the main part: execute
#
sub execute {
	my $self     = shift;
        my $conf     = $self->{plugins_options}{GroupConfig};
        my $ui       = $self->{plugins_options}{UI};
        my $verbose  = $self->{plugins_options}{verbose};
        my $keywords = $self->{plugins_options}{keywords};

	my $args = '';
	if ($self->{opts}{bkd_log_file}) {
		$args .= '-l'.$self->{opts}{bkd_log_file}.',';
	}
	if ($self->{opts}{bkd_print_headers} eq 'yes') {
		$args .= '-h,';
	}
	if ($self->{opts}{bkd_debug_mode} eq 'yes') {
		$args .= '-D,';
	}
	if ($self->{opts}{bkd_jail} eq 'yes') {
		$args .= '-C,';
	}
	if ($self->{opts}{bkd_exclude_commands}) {
		my @exc_cmds = split(/,/, $self->{opts}{bkd_exclude_commands});
		$args .= map { '-x'.$_.',' } @exc_cmds;
	}
	chop $args if length $args;

	open(FH, '>>', $self->{opts}{bkdinit_config}) || return $ERRNO{'ERROR'};
	print FH $self->{opts}{repository_name}.':'.$self->{opts}{repository_path}.':'.
	    $self->{opts}{port}.':'.$self->{opts}{uid}.':'.$self->{opts}{gid}.':'
	    .$args . "\n";
	close FH;

	my $err = 0;
	if ($self->{opts}{clone_repository_from}) {
		$err = system($self->{opts}{bk_path}, 
		    ('clone',
		    $self->{opts}{clone_repository_from},
		    $self->{opts}{repository_path}));
	}
	return $ERRNO{'ERROR'} if $err;

	if (! $self->{opts}{clone_repository_from} && $self->{opts}{setup_new_repository} eq 'yes') {
		$err = system($self->{opts}{bk_path}, ('setup', $self->{opts}{repository_path}));
	}
	if ($self->{opts}{restart_bkdinit} eq 'yes') {
		$err = system($self->{opts}{bkdinit_path}, ('restart'));
	}
	#
	# XXX: Should we add conf. option like rollback_on_failed_restart?
	# Should we add similiar options for everything what can cause a rollback?
	#
	return $ERRNO{'ERROR'} if $err;

	return $ERRNO{'OK'};
}



#
# if something goes wrong during the execution, we can rollback the changes.
#
sub rollback {
	my $self    = shift;
        my $conf    = $self->{plugins_options}{GroupConfig};
        my $ui      = $self->{plugins_options}{UI};
        my $verbose = $self->{plugins_options}{verbose};

	$ui->display("Rollback...", "Doing a rollback.");
        my $tmp = create_file("/tmp", "adduser.");

	open(IN, '<', $self->{opts}{bkdinit_config}) || return $ERRNO{'ERROR'};
	open(OUT, '>', $tmp) || return $ERRNO{'ERROR'};
	while (<IN>) {
		print OUT $_ unless /^$self->{opts}{repository_name}:$self->{opts}{repository_path}:/;
	}
	close OUT;
	close IN;
	au_move($tmp, $self->{opts}{bkdinit_config});

	return $ERRNO{'OK'};
}
# }}}

1;
