#
# Module:     Quota.pm   
# Date:       03/05/04   
# Version:    1.15   
# Edited by:  teon@teon.org   
# Description:   
#
#  This plugin, is used to control new users disk quota.
# 
# License:  
#  
#  This program is free software; you can redistribute it and/or modify  
#  it under the terms of the GNU General Public License Version 2 as  
#  published by the Free Software Foundation.  
#  
#  This program is distributed in the hope that it will be useful,  
#  but WITHOUT ANY WARRANTY; without even the implied warranty of  
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
#  GNU General Public License for more details.  
#  
#  You should have received a copy of the GNU General Public License  
#  along with this program; if not, write to the Free Software  
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,  
#  USA.  
#  
# This file is part of adduser-ng program.  
#  
# Copyright (C) 2003-2004 Bartosz Oler <liar@bzimage.us>  
# Copyright (C) 2003-2004 Robert Olejnik <teon@teon.org>  
#

package AddUser::plugins::Quota;

use strict;
use Quota;
use AddUser::StdLib;



my $_PLUGIN = 'Quota';
my $_APIVERSION = 0x1;


# new
# {{{

sub new {
	my ($c, %args) = @_;
	my $class = ref($c) || $c;

	$args{opts} = {
                'quota_device_path'  => '',
                'uid'                => '',
                'blocks_soft_limit'  => '',
                'blocks_hard_limit'  => '',
                'inodes_soft_limit'  => '',
                'inodes_hard_limit'  => '',
                'time_init'          => '0',
                'is_group'           => 'no'
        };

        $args{APIVERSION} = $_APIVERSION;
        $args{NAME} = $_PLUGIN;

	bless \%args, $class;
}

# }}}




# configure
# =========
#
# {{{

sub configure {
	my $self     = shift;
        my $conf     = $self->{plugins_options}{GroupConfig};
        my $ui       = $self->{plugins_options}{UI};
        my $verbose  = $self->{plugins_options}{verbose};
        my $keywords = $self->{plugins_options}{keywords};
	my $docs     = &get_documentation($self->{plugins_options}{documentation_dir}, $_PLUGIN);

	$self->{plugins_options}{docs} = $docs->{options}{option};
	$ui->display("$_PLUGIN", $docs->{description}."\n") if $verbose;

        # main configuration
        wrapper_getlong($self, $_PLUGIN, 'quota_device_path');

	while ($self->{opts}{'quota_device_path'} eq "") {
	    $ui->display_error("Quota Error!", "Please insert a proper value for 'quota_device_path' option!");
	    wrapper_getlong($self, $_PLUGIN, 'quota_device_path');
	}

	# resolving device from path
	my $path = $self->{opts}{'quota_device_path'};
	my $dev  = Quota::getqcarg($path);

	if(not $dev) {
	    $ui->display_error("Quota Error!", "Can't find device mount point with
	    Quota on $path. Maybe you entered a wrong path ?");
	    return $ERRNO{'ERROR'};
	}

	$self->{opts}{'quota_device_path'} = $dev;

        wrapper_getlong($self, $_PLUGIN, 'blocks_soft_limit');

	while ($self->{opts}{'blocks_soft_limit'} eq "") {
	    $ui->display_error("Quota Error!", "Please insert a proper value for 'blocks_soft_limit' option!");
	    wrapper_getlong($self, $_PLUGIN, 'blocks_soft_limit');
	}

        wrapper_getlong($self, $_PLUGIN, 'blocks_hard_limit');

	while ($self->{opts}{'blocks_hard_limit'} eq "") {
	    $ui->display_error("Quota Error!", "Please insert a proper value for 'blocks_hard_limit' option!");
	    wrapper_getlong($self, $_PLUGIN, 'blocks_hard_limit');
	}

        wrapper_getlong($self, $_PLUGIN, 'inodes_soft_limit');

	while ($self->{opts}{'inodes_soft_limit'} eq "") {
	    $ui->display_error("Quota Error!", "Please insert a proper value for 'inodes_soft_limit' option!");
	    wrapper_getlong($self, $_PLUGIN, 'inodes_soft_limit');
	}

        wrapper_getlong($self, $_PLUGIN, 'inodes_hard_limit');

	while ($self->{opts}{'inodes_hard_limit'} eq "") {
	    $ui->display_error("Quota Error!", "Please insert a proper value for 'inodes_hard_limit' option!");
	    wrapper_getlong($self, $_PLUGIN, 'inodes_hard_limit');
	}

        wrapper_getlong($self, $_PLUGIN, 'time_init');

	while ($self->{opts}{'time_init'} eq "") {
	    $ui->display_error("Quota Error!", "Please insert a proper value for 'time_init' option!");
	    wrapper_getlong($self, $_PLUGIN, 'time_init');
	}

        wrapper_getsingle($self, $_PLUGIN, 'is_group', ('no', 'yes'));

	return $ERRNO{'OK'};
}

# }}}




# execute
# =======
#
# {{{

sub execute {
	my $self    = shift;
        my $conf    = $self->{plugins_options}{GroupConfig};
        my $ui      = $self->{plugins_options}{UI};
        my $verbose = $self->{plugins_options}{verbose};

        my ($tmp, $uid, $err);

        #
        # finish up the configuration:
        #
        # quota plugin, must know the user uid, before it takes any actions,
        # it can only be done, after the user is added (to be more specific,
        # after UserAdd plugin's done), so this part of code can only be in
        # the execute method of this plugin..
        #
        #
        if (not (($tmp, $tmp, $uid, $tmp, $tmp, $tmp, $tmp, $tmp, $tmp, $tmp) = getpwnam($self->{plugins_options}{login})) ) {
                $ui->display_error("Quota Error", "Can't get UID for user: $self->{plugins_options}{login} !");
                return $ERRNO{'ERROR'};
        }

	$ui->display("Quota plugin VERBOSE", "Found users: " .
	$self->{plugins_options}{login} . " uid: " . $uid) if $verbose;
        
        $self->{opts}{'uid'} = $uid;

        my $dev = $self->{opts}{'quota_device_path'};
        my $blocks_soft = $self->{opts}{'blocks_soft_limit'};
        my $blocks_hard = $self->{opts}{'blocks_hard_limit'};
        my $inodes_soft = $self->{opts}{'inodes_soft_limit'};
        my $inodes_hard = $self->{opts}{'inodes_hard_limit'};
        my $tlo = $self->{opts}{'time_init'};
        my $isgrp;
	if ($self->{opts}{'is_group'} eq 'no' or $self->{opts}{'is_group'} == 0) {
	    $isgrp = 0;
	} else {
	    $isgrp = 1;
	}

	$ui->display("Quota plugin VERBOSE", "Command to run: Quota::setqlim($dev, $uid, $blocks_soft, $blocks_hard, $inodes_soft, $inodes_hard, $tlo, $isgrp)") if $verbose;

        # update quota
        if(Quota::setqlim($dev, $uid, $blocks_soft, $blocks_hard, $inodes_soft, $inodes_hard, $tlo, $isgrp) != 0) {
                $err = Quota::strerr;
		$ui->display_error("Quota plugin", "Error while setting quota for $self->{plugins_options}{login}:\n$err\n$!");
		return $ERRNO{'ERROR'};
	}

        # sync the quota device
        if(Quota::sync($dev) != 0) {
                $err = Quota::strerr;
		$ui->display_error("Quota plugin", "Error while syncing the quota device: ${dev}:\n$err");
		return $ERRNO{'ERROR'};
        }

	return $ERRNO{'OK'};
}

# }}}


# rollback
# ========
#
# {{{

sub rollback {
	my $self    = shift;
        my $conf    = $self->{plugins_options}{GroupConfig};
        my $ui      = $self->{plugins_options}{UI};
        my $verbose = $self->{plugins_options}{verbose};

	$ui->display("Quota Rollback...", "Updating Quota went unfortunetly, this is only a notice, as there is nothing to be done to rollback");

	return $ERRNO{'OK'};
}

# }}}

1;
