/*
   Project: Adun

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/
#include "AdunKernel/AdunBondedTopology.h"

@implementation AdBondedTopology

/****************************

Accessing Data Source

****************************/

- (void) _retrieveTopologies
{
	NSDebugLLog(@"AdBondedTopology", @"Retrieving topology tables\n");
	topologyDict = [dataSource objectValueForBondedInteractions: self];
	NSDebugLLog(@"AdBondedTopology", @"Retrieved tables for the following types %@", [[topologyDict keyEnumerator] allObjects]);
}

/****************************

Initialisation

****************************/

- (id) init
{
	return [self initWithEnvironment: nil];
}

- (id) initWithEnvironment: (id) object
{
	return [self initWithEnvironment: object observe: YES];
}

- (id) initWithEnvironment: (id) object observe: (BOOL) value
{
	if(self = [super initWithEnvironment: object observe: value])
	{
		NSDebugLLog(@"AdBondedTopology",@"Intialising Bonded Topology :");
		dependantsDict = [NSMutableDictionary dictionaryWithCapacity:1];
		[dependantsDict retain];
		dataSourceProtocolName = @"AdBondedTopologyDataSource";
		dataSourceProtocol = @protocol(AdBondedTopologyDataSource);
		[dataSourceProtocolName retain];
	}

	return self;
}


- (void) dealloc
{
	[dataSourceProtocolName release];
	[dependantsDict release];
	[super dealloc];
}

- (void) setEnvironment: (id) object
{
	environment = object;
}

/***************************

 Accessors 

***************************/

- (NSDictionary*) interactions
{
	return topologyDict;
}

/***************************

Protocol Implementations

****************************/

- (void) reloadData
{	
	if(dataSource != nil)
		[self _retrieveTopologies];
	else
		[NSException raise: NSInternalInconsistencyException
			format: @"No data source has been set (%@)", [self description]];
}

- (id) initWithCoder: (NSCoder*) decoder
{
	self = [super initWithCoder: decoder];
	if([decoder allowsKeyedCoding])
	{
		dataSource = [decoder decodeObjectForKey: @"DataSource"];
	}
	else
		[NSException raise: NSInvalidArgumentException
			format: @"%@ class does not support non keyed coding", [self class]];

	dataSourceProtocolName = @"AdBondedTopologyDataSource";
	dataSourceProtocol = @protocol(AdBondedTopologyDataSource);
	[dataSourceProtocolName retain];

	environment = [AdEnvironment globalEnvironment];
	
	[self reloadData];
	return self;
}

- (void) encodeWithCoder: (NSCoder*) encoder
{
	[super encodeWithCoder: encoder];
	if([encoder allowsKeyedCoding])
	{
		[encoder encodeConditionalObject: dataSource forKey: @"DataSource"];
	}
	else
		[NSException raise: NSInvalidArgumentException
			format: @"%@ class does not support non keyed coding", [self class]];
}


@end
