/*
   Project: Adun

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/
#include "AdunKernel/AdunNonBondedListHandler.h"

@class CellListHandler;
@class SimpleListHandler;

@implementation AdNonBondedListHandler

+ (id) objectForEnvironment: (id) object
{
	NSString* managementMethod = [object valueForKey:@"ListManagementMethod"];
	
	if(object == nil)
		return [[[CellListHandler alloc] initWithEnvironment: object] autorelease];
	else
	{
		if([managementMethod isEqual: @"Simple"])
			return [[[SimpleListHandler alloc] initWithEnvironment: object observe: YES] autorelease];
		else if([managementMethod isEqual: @"Cell"])
			return [[[CellListHandler alloc] initWithEnvironment: object observe: YES] autorelease];
		else
		{
			NSWarnLog(@"Unknown list management method %@. Defaulting to Cell", managementMethod);
			return [[[CellListHandler alloc] initWithEnvironment: object] autorelease];
		}
	}
}

+ (id) objectForEnvironment: (id) object observes: (BOOL) value
{
	NSString* managementMethod = [object valueForKey:@"ListManagementMethod"];
	
	if(object == nil)
		return [[[CellListHandler alloc] initWithEnvironment: object] autorelease];
	else
	{
		if([managementMethod isEqual: @"Simple"])
			return [[[SimpleListHandler alloc] initWithEnvironment: object observe: value] autorelease];
		else if([managementMethod isEqual: @"Cell"])
			return [[[CellListHandler alloc] initWithEnvironment: object observe: value] autorelease];
		else
		{
			NSWarnLog(@"Unknown list management method %@. Defaulting to Cell", managementMethod);
			return [[[CellListHandler alloc] initWithEnvironment: object] autorelease];
		}
	}
}

- (id) initWithEnvironment: (id) object
{
	return [self initWithEnvironment: object observe: YES];
}

- (id) init
{
	return [self initWithEnvironment: nil];
}

- (void) dealloc
{
	[super dealloc];
}

- (id) initWithCoder: (NSCoder*) decoder
{
	self = [super initWithCoder: decoder];
	return self;
}

- (void) encodeWithCoder: (NSCoder*) encoder
{
	[super encodeWithCoder: encoder];
}

- (void) createList
{
	printf("Object %@: Method %@\n", [self description], NSStringFromSelector(_cmd));
	printf("All subclasses must provide their own implementation of this method\n");
	exit(2);
}

- (void) update
{
	printf("Object %@: Method %@\n", [self description], NSStringFromSelector(_cmd));
	printf("All subclasses must provide their own implementation of this method\n");
	exit(2);
}

- (void) setCutoff: (int) aValue
{
	printf("Object %@: Method %@\n", [self description], NSStringFromSelector(_cmd));
	printf("All subclasses must provide their own implementation of this method\n");
	exit(2);
}

- (void) setCoordinates: (NSValue*) aValue
{
	printf("Object %@: Method %@\n", [self description], NSStringFromSelector(_cmd));
	printf("All subclasses must provide their own implementation of this method\n");
	exit(2);
}

- (void) setNonbondedTopology: (NSArray*) anArray
{
	printf("Object %@: Method %@\n", [self description], NSStringFromSelector(_cmd));
	printf("All subclasses must provide their own implementation of this method\n");
	exit(2);
}

- (void) setParameters: (NSValue*) aValue
{
	printf("Object %@: Method %@\n", [self description], NSStringFromSelector(_cmd));
	printf("All subclasses must provide their own implementation of this method\n");
	exit(2);
}

- (NSValue*) nonbondedInteractions
{
	printf("Object %@: Method %@\n", [self description], NSStringFromSelector(_cmd));
	printf("All subclasses must provide their own implementation of this method\n");
	exit(2);
}

- (int) numberNonbondedInteractions
{
	printf("Object %@: Method %@\n", [self description], NSStringFromSelector(_cmd));
	printf("All subclasses must provide their own implementation of this method\n");
	exit(2);
}


@end

