/*
   Project: Adun

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/
/** \file **/
#ifndef ADUN_STATE
#define ADUN_STATE

#include <stdio.h>
#include <stdlib.h>
#include "AdunKernel/AdUpdating.h"
#include "AdunKernel/AdunIOManager.h"
#include "AdunKernel/AdunSystem.h"
#include "AdunKernel/AdunSystemComponent.h"
#include "AdunKernel/AdunDynamics.h"
#include "AdunKernel/AdunBondedTopology.h"
#include "AdunKernel/AdunNonBondedTopology.h"	
#include "AdunKernel/AdunTimer.h"
#include "AdunKernel/AdFrameworkFunctions.h"

/*!
\ingroup Inter
AdState contains and monitors the current state of the system.
\todo Move CalcKineticEnergy to Base
\todo Implement setCurrentState as a ForceField only message and e.g. setCurrentStateFromForceField: 
change currentState to return a dict with the dereferenced values
\todo Handling of longRangeNonbonded component of the system
\todo implement setSystem
\todo Currently cant deal with the event that the system has not loaded a data source - will cause a seg fault
*/

@interface AdState: AdObject <AdUpdating, AdFrameUpdating>
{
	@private
	BOOL kineticUpdate;
	int DOF;
	double time;
	double timestep;
	int no_of_atoms;
	int update_interval;
	int log_interval;
	double ke_2_temp;
	double total;
	double potential;
	double kinetic;
	double temperature;
	AdMatrix* coordinates;
	AdMatrix* velocities;
	id system;
	id longRangeNonbonded;
	id nonbonded;
	id currentState;
	NSString* systemName;
	NSArray* atomTypes;
	AdDynamics* dynamics;
	AdBondedTopology* bonded;
	AdTimer* scheduler;
}

- (id) initWithEnvironment: (id) object system: (id) aSystem;
- (id) initWithEnvironment: (id) object system: (id) aSystem observe: (BOOL) value;
- (void) setCurrentForceFieldState: (NSDictionary*) currentState;
- (double) totalEnergy;
- (double) potentialEnergy;
- (double) kineticEnergy;
- (double) temperature;
- (double) time;
- (void) setKineticUpdate: (BOOL) value;
- (void) setSystem: (id) object;
- (NSDictionary*) allEnergies;
- (void) clearTimer;
/**
Reaquires system variables and recalculates various quantities
e.g. DOF, Temperature etc. Does not clear the timer or reset 
anything
*/
- (void) updateSystemData;
@end

#endif

