/*
   Project: Adun

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/
/** \file **/
#ifndef _ADUN_SYSTEM_COMPONENT_
#define _ADUN_SYSTEM_COMPONENT_

#include "AdunKernel/AdunObject.h"
#include "AdunKernel/AdDelegation.h"

/*!
\ingroup Inter
Abstract class for system components implementing common functionality
\todo Since this class holds the dataSource reference it should encode/decode it
Currently each of the subclasses do this independantly
\todo Same goes for delegate (though at the moment I dont think any of the subclasses use it)
*/

@interface AdSystemComponent: AdObject <AdDelegation, AdDataSourceDelegation>
{
	id delegate;
	id dataSource;
	NSString* dataSourceProtocolName;
	Protocol* dataSourceProtocol;
}
@end

#endif

