/*
   Project: UL

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   Created: 2005-07-15 11:25:33 +0200 by michael johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/

#include "ULIndexSetConversions.h"

#define	GSI_ARRAY_TYPE	NSRange
#define GSI_ARRAY_TYPES	GSI_ARRAY_EXTRA
#define	GSI_ARRAY_NO_RELEASE	1
#define	GSI_ARRAY_NO_RETAIN	1

#include "GNUstepBase/GSIArray.h"

@implementation NSIndexSet (ULIndexSetConversions)

+ (NSIndexSet*) indexSetFromRangeArray: (NSRange*) rangeArray ofLength: (int) length;
{
	NSMutableIndexSet *indexSet;
	int i;

	indexSet = [NSMutableIndexSet indexSet];
	for(i=0; i<length; i++)
		[indexSet addIndexesInRange: rangeArray[i]];

	NSDebugLLog(@"ULIndexSetConversions", @"Created index set from range array");

	return [[[NSIndexSet alloc] initWithIndexSet: indexSet] autorelease];
}

- (NSRange*) indexSetToRangeArrayOfLength: (int*) length
{
	int i, j;
	NSRange* rangeArray;
	int numberOfRanges;
	GSIArray _myArray;		
	
	_myArray = ((GSIArray)(self->_data));
	numberOfRanges = (_myArray == 0) ? 0 : GSIArrayCount(_myArray);
	rangeArray = (NSRange*)malloc(numberOfRanges*sizeof(NSRange));
 	for(i = 0; i < numberOfRanges; i++)
		rangeArray[i] = GSIArrayItemAtIndex(_myArray, i).ext;

	*length = numberOfRanges;

	return rangeArray;
}

- (id) initWithCoder: (NSCoder*) decoder
{
	int length;
	NSRange* rangeArray;
	NSIndexSet* indexSet;
	id temp;

	NSDebugLLog(@"ULIndexSetConversions", @"Decoding rangeArray");

	if([decoder allowsKeyedCoding])
		rangeArray = (NSRange*)[decoder decodeBytesForKey:@"" returnedLength: &length];
	else
		rangeArray = (NSRange*)[decoder decodeBytesWithReturnedLength: &length];

	length /= sizeof(NSRange);
	indexSet = [NSIndexSet indexSetFromRangeArray: rangeArray ofLength: length];
	NSDebugLLog(@"ULIndexSetConversions", @"Decoded %d bytes. complete", length);

	if([self isMemberOfClass: [NSMutableIndexSet class]])
		return [indexSet mutableCopy];
	else
		return [indexSet retain];

}

- (void) encodeWithCoder: (NSCoder*) encoder
{
	NSRange* rangeArray;
	int numberOfRanges;
	GSIArray _myArray;		
	NSData* data;	

	_myArray = ((GSIArray)(self->_data));

	NSDebugLLog(@"ULIndexSetConversions", @"Encoding index set");
	rangeArray = [self indexSetToRangeArrayOfLength: &numberOfRanges];
	if([encoder allowsKeyedCoding])
		[encoder encodeBytes: (uint8_t*)rangeArray
			length: numberOfRanges*sizeof(NSRange)
			forKey: @""];
	else
		[encoder encodeBytes: rangeArray
			length: numberOfRanges*sizeof(NSRange)];

	free(rangeArray);
	NSDebugLLog(@"ULIndexSetConversions", @"Encoding complete");
}

-(int) numberOfRanges
{
	GSIArray _myArray;		
	
	_myArray = ((GSIArray)(self->_data));
	return (_myArray == 0) ? 0 : GSIArrayCount(_myArray);
}

@end
