/*
   Project: UL

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   Created: 2005-05-31 16:30:43 +0200 by michael johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/

#ifndef _ULOPTIONSVIEWCONTROLLER_H_
#define _ULOPTIONSVIEWCONTROLLER_H_

#include <Foundation/Foundation.h>
#include <AppKit/AppKit.h>
#include "ULOptionsController.h"
#include "ULDatabaseInterface.h"
#include "ULOutlineViewDelegate.h"
#include "ViewController.h"

/**
\ingroup interface
*/

@interface ULOptionsViewController : NSObject
{
	NSWindow* window;
	id optionsController;	
	id modelViewController;
	id tabView;
	id outlineDelegate;
	id setButton;
	id saveButton;
	id cancelButton;
	NSArray* modelObjects;
	NSArray* displayTypes;
	id currentModelObject;
}

- (id) initWithOptionsController: (id) optController modelViewController: (id) mVC;
- (void) open: (id) sender;
- (void) setAndSave: (id) sender;
/**
Sets the current options to loaded but doesnt open the metadata window
*/
- (void) set: (id) sender;
- (void) close: (id) sender;
- (void) newOptions: (id) sender;
- (void) display: (id) sender;
- (void) displayMetadataForModelObject: (id) modelObject allowEditing: (BOOL) value;
- (void) displayMetadataForModelObject: (id) modelObject 
	allowEditing: (BOOL) value 
	runModal: (BOOL) flag;

@end

#endif // _ULOPTIONSVIEWCONTROLLER_H_

