/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qcheckbox.h>

#include <pop3wizardbase.h>
#include <pop3wizard.h>

#include <accountsconfig.h>

Pop3Wizard::Pop3Wizard(AccountsConfig::Account *a, QWidget *parent, const char *name=0) :
	Pop3WizardBase(parent, name, true)
{
	//eliminating the "Help" button temporarely
	helpButton()->hide();
	setNextEnabled(userInfo, false);
	setNextEnabled(POP3, false);
	
	element=a;
	if(!element)
		close();
}
void Pop3Wizard::emailChanged(const QString &str)
{
	setNextEnabled(userInfo, str.length()>0 && element->name.length()>0);
	element->from=str;
}

void Pop3Wizard::leaveClicked()
{
	element->leaveOnServer=leaveCheck->isChecked();
}

void Pop3Wizard::nameChanged(const QString &str)
{
	setNextEnabled(userInfo, str.length()>0 && element->from.length()>0);
	element->name=str;
}

void Pop3Wizard::smtpPortChanged(const QString &str)
{
	element->SMTPport=str.toInt();
	setFinishEnabled(SMTP, element->SMTPport);
}

void Pop3Wizard::passChanged(const QString &str)
{
	element->passwd=str;
}

void Pop3Wizard::passClicked()
{
	passEdit->setEnabled(passCheck->isChecked());
	element->rememberPasswd=passCheck->isChecked();
	if(element->rememberPasswd)
		element->passwd=passEdit->text();
	else
		element->passwd="";
}

void Pop3Wizard::pop3Changed(const QString &str)
{
	setNextEnabled(POP3, str.length()>0);
	element->Server=str;
}

void Pop3Wizard::pop3PortChanged(const QString &str)
{
	element->port=str.toInt();
	setNextEnabled(POP3, element->port);
}

void Pop3Wizard::replyChanged(const QString &str)
{
	element->replyTo=str;
}

void Pop3Wizard::smtpChanged(const QString &str)
{
	setFinishEnabled(SMTP, str.length()>0);
	element->SMTPServer=str;
}

void Pop3Wizard::userChanged(const QString &str)
{
	element->user=str;
}

void Pop3Wizard::accountNameChanged(const QString &str)
{
	setNextEnabled(userInfo, str.length());
	element->accountName=str;
	setCaption(QString("Create a new POP3 account")+ (str.length()?": ":".") + str);
}

void Pop3Wizard::sortClicked()
{
	element->sort=sortCheck->isChecked();
}

void Pop3Wizard::syncClicked()
{
	element->sync=syncCheck->isChecked();
}


void Pop3Wizard::accept()
{
	element->type="POP3";
	element->enabled=true;
	element->persistence=-1;
	element->sync=true;
	element->accountName=element->accountName;
	element->port=portEdit->text().toInt();
	element->SMTPport=smtpPortEdit->text().toInt();
	QDialog::accept();
}

void Pop3Wizard::reject()
{
	element->SMTPServer = element->Server = "";
	QDialog::reject();
}



