/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <partobj.h>
#include <vpartattribute.h>
#include <clientvfs.h>

PartObject::PartObject(QString _path):VObject(_path)
{
  sync();
}

PartObject::PartObject(QString _path, QByteArray &_data):VObject(_path)
{
  if( !_data || !_data.size() )
	  sync();
  else
    _narrow(_data);
}

bool PartObject::sync()
{
	VPartAttribute *attr=(VPartAttribute *)ClientVFS::thisInstance()->_fact_ref(path()+".fattr", "vpartattribute");
	if(attr)
	{
		attr->sync();
		_filename=attr->name;
		_mimeType=attr->mimetype;
		_contentID=attr->cid;
		_partType=attr->mtype;
		_encoding=attr->encoding;
		delete attr;
		return true;
	}
	else
	{
		printf("Warning: [part sync] could not create part attribute object, bailing out\n");
		return false;
	}
}

bool PartObject::save()
{
	VPartAttribute *attr=(VPartAttribute *)ClientVFS::thisInstance()->_fact_ref(path()+".fattr", "vpartattribute");
	if(attr)
	{
		attr->name=_filename;
		attr->mimetype=_mimeType;
		attr->cid=_contentID;
		attr->mtype=_partType;
		attr->encoding=_encoding;
		
		// debug
		// printf("partobject: [save] saving attribute...\n");
		
		bool res=attr->save();
		delete attr;
		
		// debug
		// printf("partobject: [save] save result was %s\n", res?"true":"false");
		
		return res;
	}
	else
	{
		// printf("Warning: [part save] could not create part attribute object, bailing out\n");
		return false;
	}
}

QString PartObject::filename()
{
	return _filename;
}

void PartObject::setFilename(const QString &newName)
{
	_filename=newName;
}

QString PartObject::mimeType()
{
	return _mimeType;
}

void PartObject::setMimeType(const QString &newMimeType)
{
	_mimeType=newMimeType;
}

QString PartObject::contentID()
{
	return _contentID;
}

void PartObject::setContentID(const QString &newContentID)
{
	_contentID=newContentID;
}

QString PartObject::partType()
{
	return _partType;
}

void PartObject::setPartType(const QString &newPartType)
{
	_partType=newPartType;
}

QString PartObject::encoding()
{
	return _encoding;
}

void PartObject::setEncoding(const QString &newEncoding)
{
	_encoding=newEncoding;
}

bool PartObject::getProperty(const QString &query, Any &property)
{
	return false;
}

bool PartObject::setProperty(const QString &query, Any &property)
{
	return false;
}

QueryProcessor::QueryType PartObject::queryType(const QString &query)
{
	return QueryProcessor::InvalidQuery;
}

PartObject *PartObjectFactory::_new(QString _path)
{
	return ClientVFS::thisInstance()->template _new<PartObject>(_path);
}

PartObject *PartObjectFactory::_new(QString _path, QByteArray &_data)
{
	return ClientVFS::thisInstance()->template _new<PartObject>(_path, _data);
}
